/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.BoundedHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Cache {
    private static final TraceComponent tc = Tr.register(Cache.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.client.internal.resources.OidcClientMessages");
    private Map<String, Object> primaryTable;
    private Map<String, Object> secondaryTable;
    private Map<String, Object> tertiaryTable;
    private int entryLimit = 50000;
    private long timeoutInMilliSeconds = 300000L;
    private Timer timer;
    static final long serialVersionUID = -4926194510643922892L;

    public Cache(int entryLimit, long timeoutInMilliSeconds) {
        if (entryLimit > 0) {
            this.entryLimit = entryLimit;
        }
        this.primaryTable = Collections.synchronizedMap(new BoundedHashMap(this.entryLimit));
        this.secondaryTable = Collections.synchronizedMap(new BoundedHashMap(this.entryLimit));
        this.tertiaryTable = Collections.synchronizedMap(new BoundedHashMap(this.entryLimit));
        if (timeoutInMilliSeconds > 0L) {
            this.timeoutInMilliSeconds = timeoutInMilliSeconds;
        }
        this.scheduleEvictionTask(this.timeoutInMilliSeconds);
    }

    public int size() {
        return this.entryLimit;
    }

    private void scheduleEvictionTask(long timeoutInMilliSeconds) {
        long period;
        EvictionTask evictionTask = new EvictionTask();
        this.timer = new Timer(true);
        long delay = period = timeoutInMilliSeconds;
        this.timer.schedule((TimerTask)evictionTask, delay, period);
    }

    public synchronized void remove(Object key) {
        this.primaryTable.remove(key);
        this.secondaryTable.remove(key);
        this.tertiaryTable.remove(key);
    }

    public synchronized Object get(String key) {
        Object curEntry = this.primaryTable.get(key);
        if (curEntry == null && (curEntry = this.secondaryTable.get(key)) == null) {
            curEntry = this.tertiaryTable.get(key);
        }
        return curEntry;
    }

    public synchronized void put(String key, Object value) {
        this.primaryTable.put(key, value);
    }

    protected synchronized void evictStaleEntries() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            int size = this.primaryTable.size() + this.secondaryTable.size() + this.tertiaryTable.size();
            Tr.debug((TraceComponent)tc, (String)("The current cache size is " + size + "( " + this.primaryTable.size() + ", " + this.secondaryTable.size() + ", " + this.tertiaryTable.size() + ")"), (Object[])new Object[0]);
        }
        this.tertiaryTable = this.secondaryTable;
        this.secondaryTable = this.primaryTable;
        this.primaryTable = Collections.synchronizedMap(new BoundedHashMap(this.entryLimit));
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class EvictionTask
    extends TimerTask {
        static final long serialVersionUID = 1727730422922432142L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private EvictionTask() {
        }

        @Override
        public void run() {
            Cache.this.evictStaleEntries();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EvictionTask.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.client.internal.resources.OidcClientMessages");
        }
    }
}

