/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.health.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.EARApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.health.internal.AppTracker;
import com.ibm.ws.microprofile.health.internal.HealthCheckService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.ApplicationState;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={AppTracker.class, ApplicationStateListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class AppTrackerImpl
implements AppTracker,
ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(AppTrackerImpl.class, (String)"HEALTH", (String)"com.ibm.ws.microprofile.health.resources.Health");
    private final HashMap<String, Set<String>> appModules = new HashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, ApplicationState> appStateMap = new HashMap<String, ApplicationState>();
    private HealthCheckService healthCheckService;
    static final long serialVersionUID = 8479995198716872012L;

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"AppTrackerImpl is activated", (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc, int reason) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"AppTrackerImpl is deactivated", (Object[])new Object[0]);
        }
    }

    @Override
    public Set<String> getAppNames() {
        return this.appModules.keySet();
    }

    @Override
    public Set<String> getModuleNames(String appName) {
        return this.appModules.get(appName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FFDCIgnore(value={UnableToAdaptException.class})
    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
        Container appContainer;
        String appName = appInfo.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("applicationStarting() : appName = " + appInfo.getName()), (Object[])new Object[0]);
        }
        if ((appContainer = appInfo.getContainer()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("applicationStarting() : appContainer=null for " + appInfo), (Object[])new Object[0]);
            }
            return;
        }
        try {
            NonPersistentCache cache = (NonPersistentCache)appContainer.adapt(NonPersistentCache.class);
            ApplicationClassesContainerInfo acci = (ApplicationClassesContainerInfo)cache.getFromCache(ApplicationClassesContainerInfo.class);
            if (acci == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("applicationStarting() : applicationClassesContainerInfo=null for " + appInfo), (Object[])new Object[0]);
                }
                return;
            }
        }
        catch (UnableToAdaptException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("applicationStarting() : Failed to adapt NonPersistentCache: container=" + appContainer + " : \n" + e.getMessage()), (Object[])new Object[0]);
            }
            return;
        }
        if (appInfo instanceof EARApplicationInfo) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("applicationStarting() : App " + appInfo.getName() + " is an EAR file."), (Object[])new Object[0]);
            }
            EARApplicationInfo earAppInfo = (EARApplicationInfo)appInfo;
            this.registerEARApplication(appContainer, earAppInfo);
        } else {
            WebModuleMetaData webModuleMetaData = this.getWebModuleMetaData(appContainer);
            if (webModuleMetaData != null) {
                String appModuleName = this.getAppModuleNameFromMetaData(webModuleMetaData);
                this.addAppModuleNames(appName, appModuleName);
            }
        }
        this.lock.writeLock().lock();
        try {
            this.appStateMap.put(appName, ApplicationState.STARTING);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("applicationStarting(): starting app added in appStateMap = " + this.appStateMap.toString() + " for app: " + appName), (Object[])new Object[0]);
        }
    }

    @FFDCIgnore(value={UnableToAdaptException.class})
    private void registerEARApplication(Container appContainer, EARApplicationInfo earAppInfo) {
        for (Entry entry : appContainer) {
            try {
                WebModuleMetaData webModuleMetaData;
                Container c = (Container)entry.adapt(Container.class);
                if (c == null || (webModuleMetaData = this.getWebModuleMetaData(c)) == null) continue;
                String appName = earAppInfo.getName();
                String appModuleName = this.getAppModuleNameFromMetaData(webModuleMetaData);
                this.addAppModuleNames(appName, appModuleName);
            }
            catch (UnableToAdaptException e) {
                if (!tc.isDebugEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("registerEARApplication() : Failed to adapt entry: entry=" + entry + " : \n" + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    private String getAppModuleNameFromMetaData(WebModuleMetaData webModuleMetaData) {
        String appModuleName = null;
        appModuleName = webModuleMetaData.getJ2EEName().toString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getAppModuleNameFromMetaData() : appModuleName = " + appModuleName), (Object[])new Object[0]);
        }
        return appModuleName;
    }

    @FFDCIgnore(value={UnableToAdaptException.class})
    private WebModuleMetaData getWebModuleMetaData(Container container) {
        NonPersistentCache overlayCache;
        WebModuleMetaData wmmd;
        block3: {
            wmmd = null;
            overlayCache = null;
            try {
                overlayCache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
            }
            catch (UnableToAdaptException e) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("getWebModuleMetaData() : Failed to adapt NonPersistentCache: container=" + container + " : \n" + e.getMessage()), (Object[])new Object[0]);
            }
        }
        if (overlayCache != null) {
            wmmd = (WebModuleMetaData)overlayCache.getFromCache(WebModuleMetaData.class);
        }
        return wmmd;
    }

    private synchronized void addAppModuleNames(String appName, String moduleAndAppName) {
        HashSet moduleNames = null;
        if (moduleAndAppName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"addAppModuleNames(): moduleAndAppName is null.", (Object[])new Object[0]);
            }
            return;
        }
        String moduleName = moduleAndAppName.split("#")[1];
        if (this.appModules.containsKey(appName)) {
            moduleNames = (HashSet)this.appModules.get(appName);
            moduleNames.add(moduleName);
            this.appModules.replace(appName, moduleNames);
        } else {
            moduleNames = new HashSet();
            moduleNames.add(moduleName);
            this.appModules.put(appName, moduleNames);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addAppModuleNames(): modules added = " + this.appModules.toString() + " for app: " + appName), (Object[])new Object[0]);
        }
    }

    @Override
    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
        String appName = appInfo.getName();
        this.lock.writeLock().lock();
        try {
            if (this.appStateMap.containsKey(appName)) {
                this.appStateMap.replace(appName, ApplicationState.STARTING, ApplicationState.STARTED);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("applicationStarted(): started app updated in appStateMap = " + this.appStateMap.toString() + " for app: " + appName), (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isStarted(String appName) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.appStateMap.get(appName) == ApplicationState.STARTED;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void applicationStopping(ApplicationInfo appInfo) {
    }

    @Override
    public void applicationStopped(ApplicationInfo appInfo) {
        String appName = appInfo.getName();
        this.lock.writeLock().lock();
        try {
            this.appStateMap.remove(appName);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("applicationStopped(): stopped app removed from appStateMap = " + this.appStateMap.toString() + " for app: " + appName), (Object[])new Object[0]);
        }
        this.unregisterApplication(appInfo, appName);
    }

    private void unregisterApplication(ApplicationInfo appInfo, String appName) {
        Container appContainer = appInfo.getContainer();
        if (appContainer == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unregisterApplication() : appContainer=null for " + appInfo), (Object[])new Object[0]);
            }
            return;
        }
        if (appInfo instanceof EARApplicationInfo) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unregisterApplication() : App " + appInfo.getName() + " is an EAR file."), (Object[])new Object[0]);
            }
            EARApplicationInfo earAppInfo = (EARApplicationInfo)appInfo;
            this.unregisterEARApplication(appContainer, earAppInfo);
        } else {
            WebModuleMetaData webModuleMetaData = this.getWebModuleMetaData(appContainer);
            if (webModuleMetaData != null) {
                String appModuleName = this.getAppModuleNameFromMetaData(webModuleMetaData);
                this.moduleStopped(appName, appModuleName);
            }
        }
    }

    @FFDCIgnore(value={UnableToAdaptException.class})
    private void unregisterEARApplication(Container appContainer, EARApplicationInfo earAppInfo) {
        for (Entry entry : appContainer) {
            try {
                WebModuleMetaData webModuleMetaData;
                Container c = (Container)entry.adapt(Container.class);
                if (c == null || (webModuleMetaData = this.getWebModuleMetaData(c)) == null) continue;
                String appName = earAppInfo.getName();
                String appModuleName = this.getAppModuleNameFromMetaData(webModuleMetaData);
                this.moduleStopped(appName, appModuleName);
            }
            catch (UnableToAdaptException e) {
                if (!tc.isDebugEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("unregisterEARApplication() : Failed to adapt entry: entry=" + entry + " : \n" + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    public synchronized void moduleStopped(String appName, String appModuleName) {
        Set<String> modules = this.appModules.get(appName);
        String moduleName = appModuleName.split("#")[1];
        if (modules != null) {
            modules.remove(moduleName);
            if (modules.size() <= 0) {
                this.appModules.remove(appName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("moduleStopped(): app module removed = " + this.appModules.toString() + " for app: " + appName), (Object[])new Object[0]);
            }
        }
        if (this.healthCheckService != null) {
            this.healthCheckService.removeModuleReferences(appName, moduleName);
        }
    }

    @Override
    public void setHealthCheckService(HealthCheckService healthService) {
        this.healthCheckService = healthService;
    }
}

