/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.health.services.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.health.services.HealthCheckBeanCallException;
import com.ibm.ws.microprofile.health.services.HealthCheckCDIBeanInvoker;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
@Component(service={HealthCheckCDIBeanInvoker.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class HealthCheckCDIBeanInvokerImpl
implements HealthCheckCDIBeanInvoker {
    private static final com.ibm.ejs.ras.TraceComponent tc = Tr.register(HealthCheckCDIBeanInvokerImpl.class);
    private final Map<String, BeanManager> beanManagers;
    private CDIService cdiService;
    static final long serialVersionUID = -2071997208814561832L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public HealthCheckCDIBeanInvokerImpl() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)new Object[0]);
        }
        this.beanManagers = new HashMap<String, BeanManager>();
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    @Reference(service=CDIService.class)
    protected void setCdiService(CDIService cdiService) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"setCdiService", (Object)new Object[]{cdiService});
        }
        this.cdiService = cdiService;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"setCdiService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected void unsetCdiService(CDIService cdiService) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"unsetCdiService", (Object)new Object[]{cdiService});
        }
        if (this.cdiService == cdiService) {
            this.cdiService = null;
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"unsetCdiService");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Set<HealthCheckResponse> checkAllBeans(String appName, String moduleName) throws HealthCheckBeanCallException {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"checkAllBeans", (Object)new Object[]{appName, moduleName});
        }
        BeanManager beanManager = this.getBeanManager(appName, moduleName);
        HashSet<HealthCheckResponse> retVal = new HashSet<HealthCheckResponse>();
        for (Object obj : this.getHealthCheckBeans(beanManager)) {
            HealthCheck tempHCBean = (HealthCheck)obj;
            try {
                retVal.add(tempHCBean.call());
            }
            catch (Throwable throwable) {
                void e;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.health.services.impl.HealthCheckCDIBeanInvokerImpl", (String)"74", (Object)this, (Object[])new Object[]{appName, moduleName});
                HealthCheckBeanCallException hcbce = new HealthCheckBeanCallException((Throwable)e);
                hcbce.setBeanName(obj.getClass().toString());
                throw hcbce;
            }
            Tr.event((com.ibm.ejs.ras.TraceComponent)tc, (String)("HealthCheck beanClass: " + obj.getClass() + " called"));
        }
        HashSet<HealthCheckResponse> hashSet = retVal;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"checkAllBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private Set<Object> getHealthCheckBeans(BeanManager beanManager) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckBeans", (Object)new Object[]{beanManager});
        }
        HashSet<Object> healthCheckBeans = new HashSet<Object>();
        if (beanManager != null) {
            Set beans = beanManager.getBeans(HealthCheck.class, new Annotation[]{new AnnotationLiteral<Health>(){
                static final long serialVersionUID = -6930944473618618190L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = com.ibm.websphere.ras.Tr.register(1.class, (String)"HEALTH", (String)"com.ibm.ws.microprofile.health.resources.Health");
                }
            }});
            for (Bean bean : beans) {
                Tr.event((com.ibm.ejs.ras.TraceComponent)tc, (String)("Bean Found: HealthCheck beanClass = " + bean.getBeanClass() + ", class = " + bean.getClass() + ", name = " + bean.getName()));
                healthCheckBeans.add(beanManager.getReference(bean, (Type)bean.getBeanClass(), beanManager.createCreationalContext((Contextual)bean)));
            }
        }
        HashSet<Object> hashSet = healthCheckBeans;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private BeanManager getBeanManager(String appName, String moduleName) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getBeanManager", (Object)new Object[]{appName, moduleName});
        }
        String key = appName + "#" + moduleName;
        BeanManager manager = this.beanManagers.get(key);
        if (manager == null) {
            if (this.beanManagers.containsKey(key) || this.cdiService == null) {
                BeanManager beanManager = null;
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                    beanManager = beanManager;
                    Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getBeanManager", beanManager);
                }
                return beanManager;
            }
            manager = this.cdiService.getCurrentModuleBeanManager();
            this.beanManagers.put(key, manager);
        }
        BeanManager beanManager = manager;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            beanManager = beanManager;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getBeanManager", (Object)beanManager);
        }
        return beanManager;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void removeModuleReferences(String appName, String moduleName) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"removeModuleReferences", (Object)new Object[]{appName, moduleName});
        }
        String key = appName + "#" + moduleName;
        this.beanManagers.remove(key);
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"removeModuleReferences");
        }
    }
}

