/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.admin.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.admin.ConfigurationDictionary;
import com.ibm.ws.config.admin.ExtendedConfiguration;
import com.ibm.ws.config.admin.internal.ConfigAdminServiceFactory;
import com.ibm.ws.config.admin.internal.ConfigurationStorageHelper;
import com.ibm.ws.config.admin.internal.ExtendedConfigurationImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConfigurationStore
implements Runnable {
    private static final TraceComponent tc = Tr.register(ConfigurationStore.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private final ConfigAdminServiceFactory caFactory;
    private final Map<String, ExtendedConfigurationImpl> configurations;
    private long configCount = 0L;
    private final File persistentConfig;
    private final Lock saveMonitor = new ReentrantLock();
    private volatile Future<?> saveTask = null;
    private boolean shutdown = false;
    private final ReentrantReadWriteLock storeMonitor = new ReentrantReadWriteLock();
    static final long serialVersionUID = -5542992233292865756L;

    public ConfigurationStore(ConfigAdminServiceFactory configAdminServiceFactory, BundleContext bc) {
        this.caFactory = configAdminServiceFactory;
        this.persistentConfig = bc.getDataFile("configs.data");
        this.configurations = this.loadConfigurationDatas(this.persistentConfig);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("config store pids are [" + this.configurations.keySet() + "]"), (Object[])new Object[0]);
        }
    }

    private final void readLock() {
        this.storeMonitor.readLock().lock();
    }

    private final void readUnlock() {
        this.storeMonitor.readLock().unlock();
    }

    public final void writeLock() {
        if (this.storeMonitor.getReadHoldCount() > 0) {
            throw new IllegalMonitorStateException("Requesting upgrade to write lock.");
        }
        this.storeMonitor.writeLock().lock();
    }

    public final void writeUnlock() {
        this.storeMonitor.writeLock().unlock();
    }

    public void removeConfiguration(String pid) {
        this.writeLock();
        try {
            this.configurations.remove(pid);
        }
        finally {
            this.writeUnlock();
        }
        this.save();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removed configuration pid = " + pid + ", remaining pids are [" + this.configurations.keySet() + "]"), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedConfigurationImpl getConfiguration(String pid, String location) {
        ExtendedConfigurationImpl config;
        this.readLock();
        try {
            config = this.configurations.get(pid);
        }
        finally {
            this.readUnlock();
        }
        if (config != null) {
            return config;
        }
        this.writeLock();
        try {
            config = this.configurations.get(pid);
            if (config == null) {
                config = new ExtendedConfigurationImpl(this.caFactory, location, null, pid, null, null, null);
                this.configurations.put(pid, config);
            }
        }
        finally {
            this.writeUnlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("added config " + config), (Object[])new Object[0]);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedConfiguration createFactoryConfiguration(String factoryPid, String location) {
        ExtendedConfigurationImpl config;
        this.writeLock();
        try {
            String pid;
            while (this.configurations.containsKey(pid = factoryPid + "_" + this.configCount++)) {
            }
            config = new ExtendedConfigurationImpl(this.caFactory, location, factoryPid, pid, null, null, null);
            this.configurations.put(pid, config);
        }
        finally {
            this.writeUnlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("added created factory config " + config), (Object[])new Object[0]);
        }
        return config;
    }

    public ExtendedConfigurationImpl findConfiguration(String pid) {
        this.readLock();
        try {
            ExtendedConfigurationImpl extendedConfigurationImpl = this.configurations.get(pid);
            return extendedConfigurationImpl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedConfigurationImpl[] getFactoryConfigurations(String factoryPid) {
        this.readLock();
        try {
            ArrayList<ExtendedConfigurationImpl> resultList = new ArrayList<ExtendedConfigurationImpl>();
            for (ExtendedConfigurationImpl config : this.configurations.values()) {
                String otherFactoryPid = config.getFactoryPid();
                if (otherFactoryPid == null || !otherFactoryPid.equals(factoryPid)) continue;
                resultList.add(config);
            }
            ExtendedConfigurationImpl[] extendedConfigurationImplArray = resultList.toArray(new ExtendedConfigurationImpl[resultList.size()]);
            return extendedConfigurationImplArray;
        }
        finally {
            this.readUnlock();
        }
    }

    public ExtendedConfiguration[] listConfigurations(Filter filter) {
        ArrayList<ExtendedConfigurationImpl> resultList = new ArrayList<ExtendedConfigurationImpl>();
        this.readLock();
        try {
            resultList.addAll(this.configurations.values());
        }
        finally {
            this.readUnlock();
        }
        Iterator it = resultList.iterator();
        while (it.hasNext()) {
            ExtendedConfigurationImpl config = (ExtendedConfigurationImpl)it.next();
            if (config.matchesFilter(filter)) continue;
            it.remove();
        }
        int size = resultList.size();
        return size == 0 ? null : resultList.toArray(new ExtendedConfigurationImpl[size]);
    }

    public void unbindConfigurations(Bundle bundle) {
        ArrayList<ExtendedConfigurationImpl> currentConfigs;
        this.readLock();
        try {
            currentConfigs = new ArrayList<ExtendedConfigurationImpl>(this.configurations.values());
        }
        finally {
            this.readUnlock();
        }
        for (ExtendedConfigurationImpl config : currentConfigs) {
            config.unbind(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveConfigurationDatas(boolean shutdown) throws IOException {
        Future<?> currentSaveTask;
        this.saveMonitor.lock();
        try {
            currentSaveTask = this.saveTask;
            this.saveTask = null;
            this.shutdown = shutdown;
        }
        finally {
            this.saveMonitor.unlock();
        }
        if (currentSaveTask == null) {
            return;
        }
        this.readLock();
        try {
            ConfigurationStorageHelper.store(this.persistentConfig, this.configurations.values());
            if (shutdown && currentSaveTask != null) {
                currentSaveTask.cancel(false);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    private Map<String, ExtendedConfigurationImpl> loadConfigurationDatas(File configDatas) {
        if (configDatas.isFile()) {
            ConfigurationStorageHelper.ConfigStorageConsumer<String, ExtendedConfigurationImpl> consumer = new ConfigurationStorageHelper.ConfigStorageConsumer<String, ExtendedConfigurationImpl>(){
                static final long serialVersionUID = 1305683639483194838L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ExtendedConfigurationImpl consumeConfigData(String location, Set<String> uniqueVars, Set<ConfigID> references, ConfigurationDictionary dict) {
                    String pid = (String)dict.get("service.pid");
                    String factoryPid = (String)dict.get("service.factoryPid");
                    return new ExtendedConfigurationImpl(ConfigurationStore.this.caFactory, location, factoryPid, pid, dict, references, uniqueVars);
                }

                @Override
                public String getKey(ExtendedConfigurationImpl configuration) {
                    return configuration.getPid(false);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
                }
            };
            try {
                return ConfigurationStorageHelper.load(configDatas, consumer);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.config.admin.internal.ConfigurationStore", (String)"246", (Object)this, (Object[])new Object[]{configDatas});
                return new HashMap<String, ExtendedConfigurationImpl>();
            }
        }
        return new HashMap<String, ExtendedConfigurationImpl>();
    }

    void save() {
        if (this.saveTask != null) {
            return;
        }
        this.saveMonitor.lock();
        try {
            if (this.shutdown) {
                return;
            }
            if (this.saveTask == null) {
                this.saveTask = this.caFactory.updateQueue.addScheduled(this);
            }
        }
        finally {
            this.saveMonitor.unlock();
        }
    }

    @Override
    public void run() {
        try {
            this.saveConfigurationDatas(false);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.config.admin.internal.ConfigurationStore", (String)"278", (Object)this, (Object[])new Object[0]);
        }
    }
}

