/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.admin.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.internal.ConfigAdminServiceFactory;
import com.ibm.ws.config.admin.internal.ConfigurationStore;
import com.ibm.ws.config.admin.internal.ExtendedConfigurationImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ManagedServiceFactoryTracker
extends ServiceTracker<ManagedServiceFactory, ManagedServiceFactory> {
    private static final String ME = ManagedServiceFactoryTracker.class.getName();
    private static final TraceComponent tc = Tr.register(ManagedServiceFactoryTracker.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private final ConfigAdminServiceFactory caFactory;
    private final Map<String, ManagedServiceFactory> managedServiceFactories = new HashMap<String, ManagedServiceFactory>();
    private final Map<String, ServiceReference<ManagedServiceFactory>> managedServiceFactoryReferences = new HashMap<String, ServiceReference<ManagedServiceFactory>>();
    static final long serialVersionUID = -2719224650925081263L;

    public ManagedServiceFactoryTracker(ConfigAdminServiceFactory casf, BundleContext bc) {
        super(bc, ManagedServiceFactory.class.getName(), null);
        this.caFactory = casf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedServiceFactory addingService(ServiceReference<ManagedServiceFactory> reference) {
        String[] factoryPids = ManagedServiceFactoryTracker.getServicePid(reference);
        if (factoryPids == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("handleRegistration(): Invalid service.pid type: " + reference), (Object[])new Object[0]);
            }
            return null;
        }
        ManagedServiceFactory msf = (ManagedServiceFactory)this.context.getService(reference);
        if (msf == null) {
            return null;
        }
        ConfigurationStore configurationStore = this.caFactory.getConfigurationStore();
        synchronized (configurationStore) {
            for (String factoryPid : factoryPids) {
                this.add(reference, factoryPid, msf);
            }
        }
        return msf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedService(ServiceReference<ManagedServiceFactory> reference, ManagedServiceFactory service) {
        String[] pids = ManagedServiceFactoryTracker.getServicePid(reference);
        List<Object> newPids = Collections.emptyList();
        if (pids != null) {
            newPids = Arrays.asList(pids);
        }
        ConfigurationStore configurationStore = this.caFactory.getConfigurationStore();
        synchronized (configurationStore) {
            List<String> previousPids = this.getPidsForManagedServiceFactory(service);
            HashSet<String> prevSet = new HashSet<String>(previousPids);
            HashSet newSet = new HashSet(newPids);
            if (!prevSet.equals(newSet)) {
                for (String string : previousPids) {
                    if (newSet.contains(string)) continue;
                    this.remove(reference, string);
                }
                for (String string : newPids) {
                    if (prevSet.contains(string)) continue;
                    this.add(reference, string, service);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<ManagedServiceFactory> reference, ManagedServiceFactory service) {
        String[] factoryPids = ManagedServiceFactoryTracker.getServicePid(reference);
        if (factoryPids == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("removedService(): Invalid service.pid type: " + reference), (Object[])new Object[0]);
            }
            return;
        }
        ConfigurationStore configurationStore = this.caFactory.getConfigurationStore();
        synchronized (configurationStore) {
            for (String pid : factoryPids) {
                this.remove(reference, pid);
            }
        }
        this.context.ungetService(reference);
    }

    private static String[] getServicePid(ServiceReference<ManagedServiceFactory> reference) {
        Object pidObj = reference.getProperty("service.pid");
        if (pidObj instanceof String) {
            return new String[]{(String)pidObj};
        }
        if (pidObj instanceof String[]) {
            return (String[])pidObj;
        }
        if (pidObj instanceof Collection) {
            Collection pidCollection = (Collection)pidObj;
            return pidCollection.toArray(new String[pidCollection.size()]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(ServiceReference<ManagedServiceFactory> reference, String factoryPid, ManagedServiceFactory service) {
        int i;
        ExtendedConfigurationImpl[] configs = this.caFactory.getConfigurationStore().getFactoryConfigurations(factoryPid);
        try {
            for (i = 0; i < configs.length; ++i) {
                configs[i].lock();
            }
            if (this.trackManagedServiceFactory(factoryPid, reference, service)) {
                for (i = 0; i < configs.length; ++i) {
                    if (configs[i].isDeleted()) continue;
                    if (configs[i].bind(reference.getBundle())) {
                        Dictionary<String, Object> properties = configs[i].getProperties();
                        this.caFactory.modifyConfiguration(reference, properties, service);
                        this.asyncUpdated(service, configs[i].getFactoryPid(), configs[i].getPid(), properties);
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("add(): Configuration for service.pid=" + configs[i].getPid() + " could not be bound to " + reference.getBundle().getLocation()), (Object[])new Object[0]);
                }
            }
        }
        finally {
            for (i = 0; i < configs.length; ++i) {
                configs[i].unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ServiceReference<ManagedServiceFactory> reference, String factoryPid) {
        int i;
        ExtendedConfigurationImpl[] configs = this.caFactory.getConfigurationStore().getFactoryConfigurations(factoryPid);
        try {
            for (i = 0; i < configs.length; ++i) {
                configs[i].lock();
            }
            this.untrackManagedServiceFactory(factoryPid, reference);
        }
        finally {
            for (i = 0; i < configs.length; ++i) {
                configs[i].unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean trackManagedServiceFactory(String factoryPid, ServiceReference<ManagedServiceFactory> reference, ManagedServiceFactory service) {
        Map<String, ServiceReference<ManagedServiceFactory>> map = this.managedServiceFactoryReferences;
        synchronized (map) {
            if (this.managedServiceFactoryReferences.containsKey(factoryPid)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("trackManagedServiceFactory(): " + ManagedServiceFactory.class.getName() + " already registered for " + "service.pid" + "=" + factoryPid), (Object[])new Object[0]);
                }
                return false;
            }
            this.managedServiceFactoryReferences.put(factoryPid, reference);
            this.managedServiceFactories.put(factoryPid, service);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void untrackManagedServiceFactory(String factoryPid, ServiceReference<ManagedServiceFactory> reference) {
        Map<String, ServiceReference<ManagedServiceFactory>> map = this.managedServiceFactoryReferences;
        synchronized (map) {
            this.managedServiceFactoryReferences.remove(factoryPid);
            this.managedServiceFactories.remove(factoryPid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedServiceFactory getManagedServiceFactory(String factoryPid) {
        Map<String, ServiceReference<ManagedServiceFactory>> map = this.managedServiceFactoryReferences;
        synchronized (map) {
            return this.managedServiceFactories.get(factoryPid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceReference<ManagedServiceFactory> getManagedServiceFactoryReference(String factoryPid) {
        Map<String, ServiceReference<ManagedServiceFactory>> map = this.managedServiceFactoryReferences;
        synchronized (map) {
            return this.managedServiceFactoryReferences.get(factoryPid);
        }
    }

    private Future<?> asyncDeleted(final ManagedServiceFactory service, final String factoryPid, final String pid) {
        return this.caFactory.updateQueue.add(factoryPid, new Runnable(){
            static final long serialVersionUID = -5712083020447357803L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                try {
                    service.deleted(pid);
                }
                catch (Throwable throwable) {
                    void t;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.admin.internal.ManagedServiceFactoryTracker$1", (String)"245", (Object)this, (Object[])new Object[0]);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("asyncDelete(): Exception thrown while trying to update ManagedServiceFactory.  Exception = " + t.toString()), (Object[])new Object[0]);
                    }
                    FFDCFilter.processException((Throwable)t, (String)ME, (String)"asyncDelete()", (Object[])new Object[]{factoryPid, pid, service});
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
            }
        });
    }

    private Future<?> asyncUpdated(final ManagedServiceFactory service, final String factoryPid, final String pid, final Dictionary<String, ?> properties) {
        return this.caFactory.updateQueue.add(factoryPid, new Runnable(){
            static final long serialVersionUID = -1252515470911687814L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("asyncUpdated: service.updated called for " + pid + " (" + factoryPid + ")"), (Object[])new Object[0]);
                }
                try {
                    service.updated(pid, properties);
                }
                catch (Throwable throwable) {
                    void t;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.admin.internal.ManagedServiceFactoryTracker$2", (String)"268", (Object)this, (Object[])new Object[0]);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("asyncUpdated(): Exception thrown while trying to update ManagedServiceFactory.  Exception = " + t.toString()), (Object[])new Object[0]);
                    }
                    FFDCFilter.processException((Throwable)t, (String)ME, (String)"asyncUpdated()", (Object[])new Object[]{factoryPid, pid, service});
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
            }
        });
    }

    protected Future<?> notifyDeleted(ExtendedConfigurationImpl config) {
        config.checkLocked();
        String factoryPid = config.getFactoryPid(false);
        ServiceReference<ManagedServiceFactory> reference = this.getManagedServiceFactoryReference(factoryPid);
        if (reference != null && config.bind(reference.getBundle())) {
            return this.asyncDeleted(this.getManagedServiceFactory(factoryPid), factoryPid, config.getPid(false));
        }
        return null;
    }

    protected Future<?> notifyUpdated(ExtendedConfigurationImpl config) {
        config.checkLocked();
        String factoryPid = config.getFactoryPid();
        ServiceReference<ManagedServiceFactory> reference = this.getManagedServiceFactoryReference(factoryPid);
        if (reference != null && config.bind(reference.getBundle())) {
            ManagedServiceFactory msf = this.getManagedServiceFactory(factoryPid);
            Dictionary<String, Object> properties = config.getProperties();
            this.caFactory.modifyConfiguration(reference, properties, msf);
            return this.asyncUpdated(msf, factoryPid, config.getPid(), properties);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getPidsForManagedServiceFactory(ManagedServiceFactory service) {
        ArrayList<String> pids = new ArrayList<String>();
        Map<String, ServiceReference<ManagedServiceFactory>> map = this.managedServiceFactoryReferences;
        synchronized (map) {
            for (Map.Entry<String, ManagedServiceFactory> entry : this.managedServiceFactories.entrySet()) {
                if (entry.getValue() != service) continue;
                pids.add(entry.getKey());
            }
            return pids;
        }
    }
}

