/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal.schema;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.config.xml.internal.DepthAwareXMLStreamReader;
import com.ibm.ws.config.xml.internal.MetaTypeHelper;
import com.ibm.ws.config.xml.internal.schema.AttributeDefinitionSpecification;
import com.ibm.ws.config.xml.internal.schema.DesignateSpecification;
import com.ibm.ws.config.xml.internal.schema.MetaTypeInformationSpecification;
import com.ibm.ws.config.xml.internal.schema.ObjectClassDefinitionSpecification;
import com.ibm.ws.config.xml.internal.schema.SchemaBundle;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.DesignatedXMLInputFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.equinox.metatype.impl.ExtendableHelper;
import org.osgi.framework.Bundle;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SchemaMetaTypeParser {
    public static final char LOCALE_SEPARATOR = '_';
    private static final QName ID;
    private static final QName DESCRIPTION;
    private static final QName NAME;
    private static final QName TYPE;
    private static final QName REQUIRED;
    private static final QName CARDINALITY;
    private static final QName DEFAULT;
    private static final QName LABEL;
    private static final QName VALUE;
    private static final QName OCDREF;
    private static final QName PID;
    private static final QName FACTORY_PID;
    private static final QName MIN;
    private static final QName MAX;
    private static final QName LOCALIZATION;
    public static final String METATYPE_URI = "http://www.osgi.org/xmlns/metatype/v";
    public static final String METADATA = "MetaData";
    public static final String OCD = "OCD";
    public static final String AD = "AD";
    public static final String OPTION = "Option";
    public static final String DESIGNATE = "Designate";
    public static final String OBJECT = "Object";
    public static final String VAR_INDICATOR = "%";
    public static final String METATYPE_PAT = "OSGI-INF/metatype";
    public static final String METATYPE_PROP = "OSGI-INF/l10n";
    public static final String XML_EXT = ".xml";
    public static final String PROP_EXT = ".properties";
    private static final ResourceBundle _msgs;
    private final XMLInputFactory inputFactory = DesignatedXMLInputFactory.newInstance();
    private final List<MetaTypeInformationSpecification> metatypeList = new ArrayList<MetaTypeInformationSpecification>();
    MetaTypeInformationSpecification metatype = null;
    Properties messages = null;
    Bundle bundle = null;
    private final Locale locale;
    private final Map<String, List<File>> prodJars;
    static final long serialVersionUID = -2651758798767927075L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SchemaMetaTypeParser(Locale locale, List<File> j, String productName) {
        this.locale = locale;
        this.prodJars = new HashMap<String, List<File>>();
        this.prodJars.put(productName, j);
    }

    public SchemaMetaTypeParser(Locale locale, Map<String, List<File>> prodJars) {
        this.locale = locale;
        this.prodJars = prodJars;
    }

    /*
     * WARNING - void declaration
     */
    public List<MetaTypeInformationSpecification> getMetatypeInformation() {
        try {
            for (Map.Entry<String, List<File>> prodEntry : this.prodJars.entrySet()) {
                List<File> jars = prodEntry.getValue();
                String productName = prodEntry.getKey();
                for (File jar : jars) {
                    JarFile jarFile = new JarFile(jar);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    ArrayList<String> metatypePath = new ArrayList<String>();
                    HashMap<String, URL> metatypePropMap = new HashMap<String, URL>();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String entryName = entry.getName();
                        if (entry.isDirectory()) continue;
                        if (entryName.endsWith(XML_EXT) && entryName.startsWith(METATYPE_PAT)) {
                            metatypePath.add(entryName);
                        }
                        if (!entryName.endsWith(PROP_EXT)) continue;
                        metatypePropMap.put(entryName, new URL("jar:" + jar.toURI() + "!/" + entryName));
                    }
                    boolean generateNewMetatype = true;
                    for (String metatype : metatypePath) {
                        JarEntry metatypeEntry = jarFile.getJarEntry(metatype);
                        InputStream metatypeInputStream = jarFile.getInputStream(metatypeEntry);
                        this.parse(metatypeInputStream, jarFile, generateNewMetatype, metatypePropMap, productName);
                        generateNewMetatype = false;
                    }
                }
            }
        }
        catch (IOException iOException) {
            void ioe;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.config.xml.internal.schema.SchemaMetaTypeParser", (String)"157", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException((Throwable)ioe);
        }
        catch (XMLStreamException ioe) {
            void xse;
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.config.xml.internal.schema.SchemaMetaTypeParser", (String)"159", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException((Throwable)xse);
        }
        return this.metatypeList;
    }

    private void parse(InputStream metatypeXML, JarFile jarFile, boolean generateNewMetatype, Map<String, URL> metatypePropMap, String productName) throws XMLStreamException, IOException {
        XMLStreamReader xmlStreamReader = this.inputFactory.createXMLStreamReader(metatypeXML);
        DepthAwareXMLStreamReader parser = new DepthAwareXMLStreamReader(xmlStreamReader);
        if (generateNewMetatype) {
            this.bundle = new SchemaBundle(jarFile, metatypePropMap, productName);
            this.metatype = new MetaTypeInformationSpecification(this.bundle);
            this.metatypeList.add(this.metatype);
        }
        int depth = parser.getDepth();
        while (parser.hasNext(depth)) {
            String name;
            int event = parser.next();
            if (event != 1 || !(name = xmlStreamReader.getName().getLocalPart()).equalsIgnoreCase(METADATA)) continue;
            this.parseMetaData(parser);
        }
    }

    private void parseMetaData(DepthAwareXMLStreamReader parser) throws XMLStreamException {
        int attrCount = parser.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            QName qname = parser.getAttributeName(i);
            if (!qname.equals(LOCALIZATION)) continue;
            try {
                InputStream is;
                this.messages = new Properties();
                String attrVal = parser.getAttributeValue(i);
                URL messagePath = this.generateMetatypePropertiesName(attrVal, this.locale.toString());
                if (messagePath == null) {
                    messagePath = this.generateMetatypePropertiesName(attrVal, null);
                }
                InputStream inputStream = is = messagePath != null ? messagePath.openStream() : null;
                if (is != null) {
                    this.messages.load(is);
                    continue;
                }
                this.warning("missing.metatype.file", this.bundle.getSymbolicName() + '/' + this.bundle.getVersion());
                continue;
            }
            catch (IOException attrVal) {
                FFDCFilter.processException((Throwable)attrVal, (String)"com.ibm.ws.config.xml.internal.schema.SchemaMetaTypeParser", (String)"207", (Object)this, (Object[])new Object[]{parser});
            }
        }
        int depth = parser.getDepth();
        while (parser.hasNext(depth)) {
            int event = parser.next();
            if (event != 1) continue;
            String name = parser.getName().getLocalPart();
            if (name.equalsIgnoreCase(OCD)) {
                this.metatype.addObjectClassSpecification(this.parseOCD(parser));
                continue;
            }
            if (!name.equalsIgnoreCase(DESIGNATE)) continue;
            this.metatype.addDesignateSpecification(this.parseDesignate(parser));
        }
        this.metatype.validate();
    }

    private void warning(String message, Object ... args) {
        String msg = message;
        try {
            msg = _msgs.getString(message);
        }
        catch (MissingResourceException missingResourceException) {
            FFDCFilter.processException((Throwable)missingResourceException, (String)"com.ibm.ws.config.xml.internal.schema.SchemaMetaTypeParser", (String)"234", (Object)this, (Object[])new Object[]{message, args});
        }
        if (args.length > 0) {
            msg = MessageFormat.format(msg, args);
        }
        System.out.println(msg);
    }

    private URL generateMetatypePropertiesName(String metatypeName, String locale) {
        String lookupName = locale != null && locale.length() > 0 ? metatypeName + '_' + locale + PROP_EXT : metatypeName + PROP_EXT;
        URL url = this.bundle.getEntry(lookupName);
        if (url == null) {
            int pos;
            int n = pos = locale == null ? -1 : locale.lastIndexOf(95);
            if (pos != -1) {
                url = this.generateMetatypePropertiesName(metatypeName, locale.substring(0, pos));
            }
        }
        return url;
    }

    private String getLocalizedName(String nameKey) {
        if (nameKey != null && nameKey.startsWith(VAR_INDICATOR)) {
            String key = nameKey.substring(1);
            String localized = this.messages.getProperty(key);
            return localized != null ? localized : nameKey;
        }
        return nameKey;
    }

    private ObjectClassDefinitionSpecification parseOCD(DepthAwareXMLStreamReader parser) throws XMLStreamException {
        ObjectClassDefinitionSpecification ocd = new ObjectClassDefinitionSpecification();
        HashMap<String, Map<String, String>> extAttributes = new HashMap<String, Map<String, String>>();
        int attrCount = parser.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            Map<String, String> attrMap;
            QName attrName = parser.getAttributeName(i);
            String attrVal = parser.getAttributeValue(i);
            if (attrName.equals(ID)) {
                ocd.setID(attrVal);
            } else if (attrName.equals(NAME)) {
                ocd.setName(this.getLocalizedName(attrVal));
            } else if (attrName.equals(DESCRIPTION)) {
                ocd.setDescription(this.getLocalizedName(attrVal));
            }
            String namespace = attrName.getNamespaceURI();
            if (namespace.length() == 0 || namespace.startsWith(METATYPE_URI)) continue;
            if (extAttributes.containsKey(namespace)) {
                attrMap = (Map)extAttributes.get(namespace);
                attrMap.put(attrName.getLocalPart(), attrVal);
                continue;
            }
            attrMap = new HashMap();
            ((HashMap)attrMap).put(attrName.getLocalPart(), attrVal);
            extAttributes.put(namespace, attrMap);
        }
        ocd.setExtensionAttributes(new ExtendableHelper(extAttributes));
        int depth = parser.getDepth();
        while (parser.hasNext(depth)) {
            String name;
            int event = parser.next();
            if (event != 1 || !(name = parser.getName().getLocalPart()).equalsIgnoreCase(AD)) continue;
            ocd.addAttribute(this.parseAD(parser));
        }
        return ocd;
    }

    private AttributeDefinitionSpecification parseAD(DepthAwareXMLStreamReader parser) throws XMLStreamException {
        AttributeDefinitionSpecification ad = new AttributeDefinitionSpecification();
        HashMap<String, Map<String, String>> extAttributes = new HashMap<String, Map<String, String>>();
        int attrCount = parser.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            Map<String, String> attrMap;
            QName qname = parser.getAttributeName(i);
            String attrVal = parser.getAttributeValue(i);
            if (qname.equals(ID)) {
                ad.setId(attrVal);
            } else if (qname.equals(NAME)) {
                ad.setName(this.getLocalizedName(attrVal));
                String defaultName = ad.getName();
                String attributeName = this.getLocalizedName(attrVal + "$Ref");
                ad.setAttributeName(attributeName.equals(attrVal + "$Ref") ? defaultName : attributeName);
            } else if (qname.equals(DESCRIPTION)) {
                ad.setDescription(this.getLocalizedName(attrVal));
            } else if (qname.equals(TYPE)) {
                ad.setType(this.parseType(attrVal));
            } else if (qname.equals(CARDINALITY)) {
                ad.setCardinality(Integer.parseInt(attrVal));
            } else if (qname.equals(DEFAULT)) {
                List<String> values = MetaTypeHelper.parseValue(attrVal);
                ad.setDefaultValue(values.toArray(new String[values.size()]));
            } else if (qname.equals(REQUIRED)) {
                ad.setRequired(Boolean.parseBoolean(attrVal));
            } else if (qname.equals(MIN)) {
                ad.setMinValue(attrVal);
            } else if (qname.equals(MAX)) {
                ad.setMaxValue(attrVal);
            }
            String namespace = qname.getNamespaceURI();
            if (namespace.length() == 0 || namespace.startsWith(METATYPE_URI)) continue;
            if (extAttributes.containsKey(namespace)) {
                attrMap = (Map)extAttributes.get(namespace);
                attrMap.put(qname.getLocalPart(), attrVal);
                continue;
            }
            attrMap = new HashMap();
            ((HashMap)attrMap).put(qname.getLocalPart(), attrVal);
            extAttributes.put(namespace, attrMap);
        }
        ad.setExtendedAttributes(new ExtendableHelper(extAttributes));
        int depth = parser.getDepth();
        while (parser.hasNext(depth)) {
            String name;
            int event = parser.next();
            if (event != 1 || !(name = parser.getName().getLocalPart()).equalsIgnoreCase(OPTION)) continue;
            ad.addValueOption(this.parseOption(parser));
        }
        return ad;
    }

    private DesignateSpecification parseDesignate(DepthAwareXMLStreamReader parser) throws XMLStreamException {
        DesignateSpecification ds = new DesignateSpecification();
        String pid = null;
        String factoryPid = null;
        int attrCount = parser.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            QName qname = parser.getAttributeName(i);
            String attrVal = parser.getAttributeValue(i);
            if (qname.equals(PID)) {
                pid = attrVal;
                continue;
            }
            if (!qname.equals(FACTORY_PID)) continue;
            factoryPid = attrVal;
        }
        if (factoryPid != null) {
            ds.setIsFactory(true);
            ds.setPid(factoryPid);
        } else if (pid != null) {
            ds.setIsFactory(false);
            ds.setPid(pid);
        } else {
            throw new IllegalStateException("pid and factoryPid is null");
        }
        int depth = parser.getDepth();
        while (parser.hasNext(depth)) {
            String name;
            int event = parser.next();
            if (event != 1 || !(name = parser.getName().getLocalPart()).equalsIgnoreCase(OBJECT)) continue;
            ds.setOcdId(this.parseObject(parser));
        }
        return ds;
    }

    private String parseObject(DepthAwareXMLStreamReader parser) {
        int attrCount = parser.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            QName qName = parser.getAttributeName(i);
            String attrVal = parser.getAttributeValue(i);
            if (!qName.equals(OCDREF)) continue;
            return attrVal;
        }
        return null;
    }

    private String[] parseOption(DepthAwareXMLStreamReader parser) {
        int attrCount = parser.getAttributeCount();
        String[] option = new String[2];
        for (int i = 0; i < attrCount; ++i) {
            QName qname = parser.getAttributeName(i);
            String attrVal = parser.getAttributeValue(i);
            if (qname.equals(VALUE)) {
                option[0] = attrVal;
                continue;
            }
            if (!qname.equals(LABEL)) continue;
            option[1] = this.getLocalizedName(attrVal);
        }
        return option;
    }

    private int parseType(String type) {
        if ((type = type.toLowerCase()).equals("long")) {
            return 2;
        }
        if (type.equals("double")) {
            return 7;
        }
        if (type.equals("float")) {
            return 8;
        }
        if (type.equals("integer")) {
            return 3;
        }
        if (type.equals("byte")) {
            return 6;
        }
        if (type.equals("char")) {
            return 5;
        }
        if (type.equals("boolean")) {
            return 11;
        }
        if (type.equals("short")) {
            return 4;
        }
        if (type.equals("password")) {
            return 12;
        }
        return 1;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SchemaMetaTypeParser.class, null, null);
        ID = new QName("id");
        DESCRIPTION = new QName("description");
        NAME = new QName("name");
        TYPE = new QName("type");
        REQUIRED = new QName("required");
        CARDINALITY = new QName("cardinality");
        DEFAULT = new QName("default");
        LABEL = new QName("label");
        VALUE = new QName("value");
        OCDREF = new QName("ocdref");
        PID = new QName("pid");
        FACTORY_PID = new QName("factoryPid");
        MIN = new QName("min");
        MAX = new QName("max");
        LOCALIZATION = new QName("localization");
        _msgs = ResourceBundle.getBundle("com.ibm.ws.config.internal.resources.ConfigMessages");
    }
}

