/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.rules;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.rules.Operator;
import com.ibm.ws.sip.container.rules.PhoneComparison;

public class Equal
extends Operator {
    private static final LogMgr c_logger = Log.get(Equal.class);
    private String m_value;
    private boolean m_ignoreCase;

    public Equal(String var, String value, boolean ignoreCase) {
        super(var);
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{var, value, new Boolean(ignoreCase)};
            c_logger.traceEntry((Object)this, "Equal", params);
        }
        this.m_value = value;
        this.m_ignoreCase = ignoreCase;
    }

    @Override
    protected boolean evaluate(String value) {
        return this.m_ignoreCase ? value.equalsIgnoreCase(this.m_value) : value.equals(this.m_value);
    }

    @Override
    protected boolean evaluate(PhoneComparison value) {
        return value.equals(this.m_value, this.m_ignoreCase);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(16);
        buffer.append(this.getVariable());
        buffer.append(" EQUAL '");
        buffer.append(this.m_value);
        buffer.append("'");
        return buffer.toString();
    }
}

