/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport.connections.tls;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPListenningConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPStreamConectionAdapter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SIPConnectionImpl
extends SIPStreamConectionAdapter
implements HandshakeCompletedListener {
    private static final LogMgr c_logger = Log.get(SIPConnectionImpl.class);
    private SSLSocketFactory m_factory;

    SIPConnectionImpl(SIPListenningConnection listenningConnection, Socket socket) {
        super(listenningConnection, socket);
    }

    SIPConnectionImpl(SIPListenningConnection listenningConnection, SSLSocketFactory factory, InetAddress remoteAdress, int remotePort) {
        super(listenningConnection, InetAddressCache.getHostAddress(remoteAdress), remotePort);
        this.m_factory = factory;
    }

    @Override
    public boolean isReliable() {
        return true;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public String getTransport() {
        return "tls";
    }

    public boolean equals(Object obj) {
        boolean retVal = false;
        if (obj == this) {
            retVal = true;
        } else if (obj instanceof SIPConnectionImpl) {
            retVal = obj.toString().equals(this.toString());
        }
        return retVal;
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocket socket = (SSLSocket)this.m_factory.createSocket();
        this.m_socket = socket;
        socket.addHandshakeCompletedListener(this);
        return socket;
    }

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent evt) {
        Object[] params = new Object[]{this.getRemoteHost(), new Integer(this.getRemotePort())};
        if (c_logger.isInfoEnabled()) {
            c_logger.info("info.com.ibm.ws.sip.stack.transaction.transport.connections.tls.SIPConnectionImpl.handshakeCompleted", (Object)"Connect", params);
        }
    }
}

