/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.identitystore;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.identitystore.ELHelper;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Set;
import javax.security.enterprise.identitystore.IdentityStore;
import javax.security.enterprise.identitystore.LdapIdentityStoreDefinition;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class LdapIdentityStoreDefinitionWrapper {
    private static final TraceComponent tc = Tr.register(LdapIdentityStoreDefinitionWrapper.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
    private final String bindDn;
    private final ProtectedString bindDnPassword;
    private final String callerBaseDn;
    private final String callerNameAttribute;
    private final String callerSearchBase;
    private final String callerSearchFilter;
    private final LdapIdentityStoreDefinition.LdapSearchScope callerSearchScope;
    private final String groupMemberAttribute;
    private final String groupMemberOfAttribute;
    private final String groupNameAttribute;
    private final String groupSearchBase;
    private final String groupSearchFilter;
    private final LdapIdentityStoreDefinition.LdapSearchScope groupSearchScope;
    private final LdapIdentityStoreDefinition idStoreDefinition;
    private final Integer maxResults;
    private final Integer priority;
    private final Integer readTimeout;
    private final String url;
    private final Set<IdentityStore.ValidationType> useFor;
    private final ELHelper elHelper;
    static final long serialVersionUID = 5636214725278183944L;

    LdapIdentityStoreDefinitionWrapper(LdapIdentityStoreDefinition idStoreDefinition) {
        if (idStoreDefinition == null) {
            throw new IllegalArgumentException("The LdapIdentityStoreDefinition cannot be null.");
        }
        this.idStoreDefinition = idStoreDefinition;
        this.elHelper = new ELHelper();
        this.bindDn = this.evaluateBindDn(true);
        this.bindDnPassword = this.evaluateBindDnPassword(true);
        this.callerBaseDn = this.evaluateCallerBaseDn(true);
        this.callerNameAttribute = this.evaluateCallerNameAttribute(true);
        this.callerSearchBase = this.evaluateCallerSearchBase(true);
        this.callerSearchFilter = this.evaluateCallerSearchFilter(true);
        this.callerSearchScope = this.evaluateCallerSearchScope(true);
        this.groupMemberAttribute = this.evaluateGroupMemberAttribute(true);
        this.groupMemberOfAttribute = this.evaluateGroupMemberOfAttribute(true);
        this.groupNameAttribute = this.evaluateGroupNameAttribute(true);
        this.groupSearchBase = this.evaluateGroupSearchBase(true);
        this.groupSearchFilter = this.evaluateGroupSearchFilter(true);
        this.groupSearchScope = this.evaluateGroupSearchScope(true);
        this.maxResults = this.evaluateMaxResults(true);
        this.priority = this.evaluatePriority(true);
        this.readTimeout = this.evaluateReadTimeout(true);
        this.url = this.evaluateUrl(true);
        this.useFor = this.evaluateUseFor(true);
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateBindDn(boolean immediateOnly) {
        try {
            return this.elHelper.processString("bindDn", this.idStoreDefinition.bindDn(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"bindDn", ""});
            }
            return "";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private ProtectedString evaluateBindDnPassword(boolean immediateOnly) {
        String result;
        try {
            result = this.elHelper.processString("bindDnPassword", this.idStoreDefinition.bindDnPassword(), immediateOnly, true);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"bindDnPassword", ""});
            }
            result = "";
        }
        return result == null ? null : new ProtectedString(result.toCharArray());
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateCallerBaseDn(boolean immediateOnly) {
        try {
            return this.elHelper.processString("callerBaseDn", this.idStoreDefinition.callerBaseDn(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"callerBaseDn", ""});
            }
            return "";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateCallerNameAttribute(boolean immediateOnly) {
        try {
            return this.elHelper.processString("callerNameAttribute", this.idStoreDefinition.callerNameAttribute(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"callerNameAttribute", "uid"});
            }
            return "uid";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateCallerSearchBase(boolean immediateOnly) {
        try {
            return this.elHelper.processString("callerSearchBase", this.idStoreDefinition.callerSearchBase(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"callerSearchBase", ""});
            }
            return "";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateCallerSearchFilter(boolean immediateOnly) {
        try {
            return this.elHelper.processString("callerSearchFilter", this.idStoreDefinition.callerSearchFilter(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"callerSearchFilter", ""});
            }
            return "";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private LdapIdentityStoreDefinition.LdapSearchScope evaluateCallerSearchScope(boolean immediateOnly) {
        try {
            return this.elHelper.processLdapSearchScope("callerSearchScopeExpression", this.idStoreDefinition.callerSearchScopeExpression(), this.idStoreDefinition.callerSearchScope(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"callerSearchScope/callerSearchScopeExpression", "LdapSearchScope.SUBTREE"});
            }
            return LdapIdentityStoreDefinition.LdapSearchScope.SUBTREE;
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateGroupMemberAttribute(boolean immediateOnly) {
        try {
            return this.elHelper.processString("groupMemberAttribute", this.idStoreDefinition.groupMemberAttribute(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"groupMemberAttribute", "member"});
            }
            return "member";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateGroupMemberOfAttribute(boolean immediateOnly) {
        try {
            return this.elHelper.processString("groupMemberOfAttribute", this.idStoreDefinition.groupMemberOfAttribute(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"groupMemberOfAttribute", "memberOf"});
            }
            return "memberOf";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateGroupNameAttribute(boolean immediateOnly) {
        try {
            return this.elHelper.processString("groupNameAttribute", this.idStoreDefinition.groupNameAttribute(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"groupNameAttribute", "cn"});
            }
            return "cn";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateGroupSearchBase(boolean immediateOnly) {
        try {
            return this.elHelper.processString("groupSearchBase", this.idStoreDefinition.groupSearchBase(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"groupSearchBase", ""});
            }
            return "";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateGroupSearchFilter(boolean immediateOnly) {
        try {
            return this.elHelper.processString("groupSearchFilter", this.idStoreDefinition.groupSearchFilter(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"There was an error resolving the '{1}' configuration object. Ensure any EL expressions are resolveable. The value will be defaulted to '{2}'", (Object[])new Object[]{"groupSearchFilter", ""});
            }
            return "";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private LdapIdentityStoreDefinition.LdapSearchScope evaluateGroupSearchScope(boolean immediateOnly) {
        try {
            return this.elHelper.processLdapSearchScope("groupSearchScopeExpression", this.idStoreDefinition.groupSearchScopeExpression(), this.idStoreDefinition.groupSearchScope(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"groupSearchScope/groupSearchScopeExpression", "LdapSearchScope.SUBTREE"});
            }
            return LdapIdentityStoreDefinition.LdapSearchScope.SUBTREE;
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private Integer evaluateMaxResults(boolean immediateOnly) {
        try {
            return this.elHelper.processInt("maxResultsExpression", this.idStoreDefinition.maxResultsExpression(), this.idStoreDefinition.maxResults(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"maxResults/maxResultsExpression", "1000"});
            }
            return 1000;
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private Integer evaluatePriority(boolean immediateOnly) {
        try {
            return this.elHelper.processInt("priorityExpression", this.idStoreDefinition.priorityExpression(), this.idStoreDefinition.priority(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"priority/priorityExpression", "80"});
            }
            return 80;
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private Integer evaluateReadTimeout(boolean immediateOnly) {
        try {
            return this.elHelper.processInt("readTimeoutExpression", this.idStoreDefinition.readTimeoutExpression(), this.idStoreDefinition.readTimeout(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"readTimeout/readTimeoutExpression", "0"});
            }
            return 0;
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateUrl(boolean immediateOnly) {
        try {
            return this.elHelper.processString("url", this.idStoreDefinition.url(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"url", ""});
            }
            return "";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private Set<IdentityStore.ValidationType> evaluateUseFor(boolean immediateOnly) {
        try {
            return this.elHelper.processUseFor(this.idStoreDefinition.useForExpression(), this.idStoreDefinition.useFor(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            HashSet<IdentityStore.ValidationType> values = new HashSet<IdentityStore.ValidationType>();
            values.add(IdentityStore.ValidationType.PROVIDE_GROUPS);
            values.add(IdentityStore.ValidationType.VALIDATE);
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"useFor/useForExpression", values});
            }
            return values;
        }
    }

    String getBindDn() {
        return this.bindDn != null ? this.bindDn : this.evaluateBindDn(false);
    }

    ProtectedString getBindDnPassword() {
        return this.bindDnPassword != null ? this.bindDnPassword : this.evaluateBindDnPassword(false);
    }

    String getCallerBaseDn() {
        return this.callerBaseDn != null ? this.callerBaseDn : this.evaluateCallerBaseDn(false);
    }

    String getCallerNameAttribute() {
        return this.callerNameAttribute != null ? this.callerNameAttribute : this.evaluateCallerNameAttribute(false);
    }

    String getCallerSearchBase() {
        return this.callerSearchBase != null ? this.callerSearchBase : this.evaluateCallerSearchBase(false);
    }

    String getCallerSearchFilter() {
        return this.callerSearchFilter != null ? this.callerSearchFilter : this.evaluateCallerSearchFilter(false);
    }

    LdapIdentityStoreDefinition.LdapSearchScope getCallerSearchScope() {
        return this.callerSearchScope != null ? this.callerSearchScope : this.evaluateCallerSearchScope(false);
    }

    String getGroupMemberAttribute() {
        return this.groupMemberAttribute != null ? this.groupMemberAttribute : this.evaluateGroupMemberAttribute(false);
    }

    String getGroupMemberOfAttribute() {
        return this.groupMemberOfAttribute != null ? this.groupMemberOfAttribute : this.evaluateGroupMemberOfAttribute(false);
    }

    String getGroupNameAttribute() {
        return this.groupNameAttribute != null ? this.groupNameAttribute : this.evaluateGroupNameAttribute(false);
    }

    String getGroupSearchBase() {
        return this.groupSearchBase != null ? this.groupSearchBase : this.evaluateGroupSearchBase(false);
    }

    String getGroupSearchFilter() {
        return this.groupSearchFilter != null ? this.groupSearchFilter : this.evaluateGroupSearchFilter(false);
    }

    LdapIdentityStoreDefinition.LdapSearchScope getGroupSearchScope() {
        return this.groupSearchScope != null ? this.groupSearchScope : this.evaluateGroupSearchScope(false);
    }

    int getMaxResults() {
        return this.maxResults != null ? this.maxResults : this.evaluateMaxResults(false);
    }

    int getPriority() {
        return this.priority != null ? this.priority : this.evaluatePriority(false);
    }

    int getReadTimeout() {
        return this.readTimeout != null ? this.readTimeout : this.evaluateReadTimeout(false);
    }

    String getUrl() {
        return this.url != null ? this.url : this.evaluateUrl(false);
    }

    Set<IdentityStore.ValidationType> getUseFor() {
        return this.useFor != null ? this.useFor : this.evaluateUseFor(false);
    }

    private boolean isCTS() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                static final long serialVersionUID = -3362919483554635238L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() throws SecurityException, NullPointerException, IllegalArgumentException {
                    String result = System.getProperty("cts");
                    return result != null && result.equalsIgnoreCase("true");
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.javaeesec.identitystore.LdapIdentityStoreDefinitionWrapper", (String)"745", (Object)this, (Object[])new Object[0]);
            return false;
        }
    }
}

