/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Krb5DefaultFile {
    private static final TraceComponent tc = Tr.register(Krb5DefaultFile.class, (String)"spnego", (String)"com.ibm.ws.security.spnego.internal.resources.SpnegoMessages");
    public static final String WINNT_INI = "c:/winnt/krb5.ini";
    public static final String WINNT_KEYTAB = "c:/winnt/krb5.keytab";
    public static final String WINDOWS_INI = "c:/windows/krb5.ini";
    public static final String WINDOWS_KEYTAB = "c:/windows/krb5.keytab";
    public static final String LINUX_CONF = "/etc/krb5.conf";
    public static final String LINUX_KEYTAB = "/etc/krb5.keytab";
    public static final String ISERIES_CONF = "/QIBM/UserData/OS400/NetworkAuthentication/krb5.conf";
    public static final String ISERIES_KEYTAB = "/QIBM/UserData/OS400/NetworkAuthentication/krb5.keytab";
    public static final String ZOS_AND_OTHER_UNIX_CONF = "/etc/krb5/krb5.conf";
    public static final String ZOS_AND_OTHER_UNIX_KEYTAB = "/etc/krb5/krb5.keytab";
    private static final String[] WIN_KRB5_INI = new String[]{"c:/winnt/krb5.ini", "c:/windows/krb5.ini"};
    private static final String[] WIN_KRB5_KEYTAB = new String[]{"c:/winnt/krb5.keytab", "c:/windows/krb5.keytab"};
    private static final String[] LINUX_KRB5_CONF = new String[]{"/etc/krb5.conf"};
    private static final String[] LINUX_KRB5_KEYTAB = new String[]{"/etc/krb5.keytab"};
    private static final String[] ISERIES_KRB5_CONF = new String[]{"/QIBM/UserData/OS400/NetworkAuthentication/krb5.conf"};
    private static final String[] ISERIES_KRB5_KEYTAB = new String[]{"/QIBM/UserData/OS400/NetworkAuthentication/krb5.keytab"};
    private static final String[] ZOS_AND_OTHER_UNIX_KRB5_CONF = new String[]{"/etc/krb5/krb5.conf"};
    private static final String[] ZOS_AND_OTHER_UNIX_KRB5_KEYTAB = new String[]{"/etc/krb5/krb5.keytab"};
    private String[] krb5ConfigFiles = null;
    private String[] krb5KeytabFiles = null;
    private final WsLocationAdmin locationAdmin;
    static final long serialVersionUID = 8719548175417753747L;

    Krb5DefaultFile(WsLocationAdmin locationAdmin) {
        this.locationAdmin = locationAdmin;
        this.resolveDefaultKrb5FileWithPath();
    }

    public String getDefaultKrb5ConfigFile() {
        return this.getDefaultKrb5File(KRB5.CONF);
    }

    public String getDefaultKrb5KeytabFile() {
        return this.getDefaultKrb5File(KRB5.KEYTAB);
    }

    protected String getDefaultKrb5File(KRB5 file) {
        String[] fns = this.krb5ConfigFiles;
        if (file == KRB5.KEYTAB) {
            fns = this.krb5KeytabFiles;
        }
        ArrayList<String> fileNotFound = new ArrayList<String>();
        for (String fn : fns) {
            WsResource wsResource = this.locationAdmin.resolveResource(fn);
            if (wsResource != null && wsResource.exists()) {
                if (file == KRB5.KEYTAB) {
                    Tr.info((TraceComponent)tc, (String)"SPNEGO_USE_DEFAULT_KRB5_KEYTAB_FILE", (Object[])new Object[]{fn});
                } else {
                    Tr.info((TraceComponent)tc, (String)"SPNEGO_USE_DEFAULT_KRB5_CONFIG_FILE", (Object[])new Object[]{fn});
                }
                return fn;
            }
            fileNotFound.add(fn);
        }
        if (file == KRB5.KEYTAB) {
            Tr.error((TraceComponent)tc, (String)"SPNEGO_DEFAULT_KRB5_KEYTAB_FILE_NOT_FOUND", (Object[])new Object[]{fileNotFound});
        } else {
            Tr.error((TraceComponent)tc, (String)"SPNEGO_DEFAULT_KRB5_CONF_FILE_NOT_FOUND", (Object[])new Object[]{fileNotFound});
        }
        return null;
    }

    protected void resolveDefaultKrb5FileWithPath() {
        OS os = this.getOperatingSystem();
        if (os == OS.WINDOWS) {
            this.krb5ConfigFiles = WIN_KRB5_INI;
            this.krb5KeytabFiles = WIN_KRB5_KEYTAB;
        } else if (os == OS.LINUX) {
            this.krb5ConfigFiles = LINUX_KRB5_CONF;
            this.krb5KeytabFiles = LINUX_KRB5_KEYTAB;
        } else if (os == OS.ISERIES) {
            this.krb5ConfigFiles = ISERIES_KRB5_CONF;
            this.krb5KeytabFiles = ISERIES_KRB5_KEYTAB;
        } else {
            this.krb5ConfigFiles = ZOS_AND_OTHER_UNIX_KRB5_CONF;
            this.krb5KeytabFiles = ZOS_AND_OTHER_UNIX_KRB5_KEYTAB;
        }
    }

    protected OS getOperatingSystem() {
        String osName = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -2828928402156849477L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty("os.name");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"spnego", (String)"com.ibm.ws.security.spnego.internal.resources.SpnegoMessages");
            }
        });
        if (osName != null) {
            return this.resolvePlatform(osName);
        }
        return OS.UNKNOWN;
    }

    protected OS resolvePlatform(String osName) {
        OS platform = OS.UNKNOWN;
        if ((osName = osName.toLowerCase()).indexOf("win") != -1) {
            platform = OS.WINDOWS;
        } else if (osName.indexOf("os/390") != -1 || osName.indexOf("z/os") != -1 || osName.indexOf("zos") != -1) {
            platform = OS.ZOS;
        } else if (osName.indexOf("400") != -1) {
            platform = OS.ISERIES;
        } else if (osName.indexOf("linux") != -1) {
            platform = OS.LINUX;
        } else if (osName.indexOf("aix") != -1) {
            platform = OS.AIX;
        } else if (osName.indexOf("hp") != -1) {
            platform = OS.HP;
        } else if (osName.indexOf("solaris") != -1 || osName.indexOf("sun") != -1) {
            platform = OS.SOLARIS;
        } else if (osName.indexOf("mac os") != -1 || osName.indexOf("darwin") != -1) {
            platform = OS.MAC;
        }
        return platform;
    }

    @Trivial
    protected static enum KRB5 {
        CONF,
        KEYTAB;

    }

    @Trivial
    protected static enum OS {
        AIX,
        HP,
        LINUX,
        ISERIES,
        MAC,
        SOLARIS,
        WINDOWS,
        ZOS,
        UNKNOWN;

    }
}

