/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.web.WebUtils;
import com.ibm.ws.security.openidconnect.client.jose4j.util.Jose4jUtil;
import com.ibm.ws.security.openidconnect.clients.common.AuthorizationCodeHandler;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.HashUtils;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientHttpUtil;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientRequest;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientUtil;
import com.ibm.ws.security.openidconnect.clients.common.OidcUtil;
import com.ibm.ws.security.openidconnect.clients.common.UserInfoHelper;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.PostParameterHelper;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.wsspi.ssl.SSLSupport;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OIDCClientAuthenticatorUtil {
    public static final TraceComponent tc = Tr.register(OIDCClientAuthenticatorUtil.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    SSLSupport sslSupport = null;
    private Jose4jUtil jose4jUtil = null;
    public static final String[] OIDC_COOKIES = new String[]{"WASOidcState", "WASReqURLOidc", "WASOidcCode", "WASOidcNonce"};
    static final long serialVersionUID = -2570500656335283905L;

    public OIDCClientAuthenticatorUtil() {
    }

    public OIDCClientAuthenticatorUtil(SSLSupport sslspt) {
        this.sslSupport = sslspt;
        this.jose4jUtil = this.getJose4jUtil(this.sslSupport);
    }

    protected Jose4jUtil getJose4jUtil(SSLSupport sslSupport) {
        return new Jose4jUtil(sslSupport);
    }

    /*
     * WARNING - void declaration
     */
    public ProviderAuthenticationResult handleRedirectToServer(HttpServletRequest req, HttpServletResponse res, ConvergedClientConfig clientConfig) {
        String authorizationEndpoint = clientConfig.getAuthorizationEndpointUrl();
        if (!OIDCClientAuthenticatorUtil.checkHttpsRequirement(clientConfig, authorizationEndpoint)) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_URL_PROTOCOL_NOT_HTTPS", (Object[])new Object[]{authorizationEndpoint});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        if (clientConfig.createSession()) {
            try {
                req.getSession(true);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil", (String)"82", (Object)this, (Object[])new Object[]{req, res, clientConfig});
            }
        }
        String strRandom = OidcUtil.generateRandom(9);
        String timestamp = OidcUtil.getTimeStamp();
        String state = timestamp + strRandom;
        if (!req.getMethod().equalsIgnoreCase("GET") && req.getParameter("oidc_client") != null) {
            state = state + req.getParameter("oidc_client");
        }
        String cookieValue = HashUtils.createStateCookieValue(clientConfig, state);
        String cookieName = "WASOidcState" + HashUtils.getStrHashCode(state);
        boolean isHttpsRequest = req.getScheme().toLowerCase().contains("https");
        int cookieLifeTime = (int)clientConfig.getAuthenticationTimeLimitInSeconds();
        Cookie cookie = OidcClientUtil.createCookie(cookieName, cookieValue, cookieLifeTime, req);
        if (clientConfig.isHttpsRequired() && isHttpsRequest) {
            cookie.setSecure(true);
        }
        res.addCookie(cookie);
        String redirect_url = this.setRedirectUrlIfNotDefined(req, clientConfig);
        if (!OIDCClientAuthenticatorUtil.checkHttpsRequirement(clientConfig, redirect_url)) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_URL_PROTOCOL_NOT_HTTPS", (Object[])new Object[]{redirect_url});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        String acr_values = req.getParameter("acr_values");
        String authzEndPointUrlWithQuery = null;
        try {
            boolean scopeMissing;
            boolean openidScopeMissing = !clientConfig.isSocial() && !this.isOpenIDScopeSpecified(clientConfig);
            boolean bl = scopeMissing = clientConfig.getScope() == null || clientConfig.getScope().length() == 0;
            if (openidScopeMissing || scopeMissing) {
                Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_REQUEST_MISSING_OPENID_SCOPE", (Object[])new Object[]{clientConfig.getClientId(), clientConfig.getScope()});
                return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
            }
            authzEndPointUrlWithQuery = this.buildAuthorizationUrlWithQuery(req, (OidcClientRequest)req.getAttribute("com.ibm.wsspi.security.oidc.client.request"), state, clientConfig, redirect_url, acr_values);
            WebAppSecurityConfig webAppSecConfig = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig();
            PostParameterHelper pph = new PostParameterHelper(webAppSecConfig);
            pph.save(req, res);
            if (clientConfig.isClientSideRedirect()) {
                String domain = OidcClientUtil.getSsoDomain(req);
                this.doClientSideRedirect(res, authzEndPointUrlWithQuery, state, domain);
            } else {
                String urlCookieName = "WASReqURLOidc" + HashUtils.getStrHashCode(state);
                Cookie c = OidcClientUtil.createCookie(urlCookieName, this.getReqURL(req), cookieLifeTime, req);
                if (clientConfig.isHttpsRequired() && isHttpsRequest) {
                    cookie.setSecure(true);
                }
                res.addCookie(c);
            }
        }
        catch (UnsupportedEncodingException openidScopeMissing) {
            void e;
            FFDCFilter.processException((Throwable)openidScopeMissing, (String)"com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil", (String)"142", (Object)this, (Object[])new Object[]{req, res, clientConfig});
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_AUTHORIZE_ERR", (Object[])new Object[]{clientConfig.getClientId(), e.getLocalizedMessage(), "UTF-8"});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        catch (IOException e) {
            void ioe;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil", (String)"145", (Object)this, (Object[])new Object[]{req, res, clientConfig});
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_AUTHORIZE_ERR", (Object[])new Object[]{clientConfig.getClientId(), ioe.getLocalizedMessage(), "UTF-8"});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        return new ProviderAuthenticationResult(AuthResult.REDIRECT_TO_PROVIDER, 200, null, null, null, authzEndPointUrlWithQuery);
    }

    public ProviderAuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, ConvergedClientConfig clientConfig) {
        ProviderAuthenticationResult oidcResult = null;
        if (!OIDCClientAuthenticatorUtil.isEndpointValid(clientConfig)) {
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        boolean isImplicit = false;
        if ("implicit".equals(clientConfig.getGrantType())) {
            isImplicit = true;
        }
        String authzCode = null;
        String responseState = null;
        Hashtable<String, String> reqParameters = new Hashtable<String, String>();
        String encodedReqParams = CookieHelper.getCookieValue((Cookie[])req.getCookies(), (String)"WASOidcCode");
        OidcClientUtil.invalidateReferrerURLCookie(req, res, "WASOidcCode");
        if (encodedReqParams != null && !encodedReqParams.isEmpty()) {
            boolean validCookie = this.validateReqParameters(clientConfig, reqParameters, encodedReqParams);
            if (validCookie) {
                authzCode = reqParameters.get("code");
                responseState = reqParameters.get("state");
            } else {
                oidcResult = new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
                Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_BAD_PARAM_COOKIE", (Object[])new Object[]{encodedReqParams, clientConfig.getClientId()});
                return oidcResult;
            }
        }
        if (responseState != null) {
            String access_token;
            String id_token = req.getParameter("id_token");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("id_token:" + id_token), (Object[])new Object[0]);
            }
            if (id_token != null) {
                reqParameters.put("id_token", id_token);
            }
            if ((access_token = req.getParameter("access_token")) != null) {
                reqParameters.put("access_token", access_token);
            }
            if (req.getMethod().equals("POST") && req instanceof IExtendedRequest) {
                ((IExtendedRequest)req).setMethod("GET");
            }
        }
        if (responseState == null) {
            oidcResult = this.handleRedirectToServer(req, res, clientConfig);
        } else if (isImplicit) {
            oidcResult = this.handleImplicitFlowTokens(req, res, responseState, clientConfig, reqParameters);
        } else {
            AuthorizationCodeHandler authzCodeHandler = new AuthorizationCodeHandler(this.sslSupport);
            oidcResult = authzCodeHandler.handleAuthorizationCode(req, res, authzCode, responseState, clientConfig);
        }
        if (oidcResult.getStatus() != AuthResult.REDIRECT_TO_PROVIDER) {
            WebAppSecurityConfig webAppSecConfig = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig();
            PostParameterHelper pph = new PostParameterHelper(webAppSecConfig);
            pph.restore(req, res, true);
            OidcClientUtil.invalidateReferrerURLCookies(req, res, OIDC_COOKIES);
        }
        return oidcResult;
    }

    ProviderAuthenticationResult handleImplicitFlowTokens(HttpServletRequest req, HttpServletResponse res, String responseState, ConvergedClientConfig clientConfig, Hashtable<String, String> reqParameters) {
        OidcClientRequest oidcClientRequest = (OidcClientRequest)req.getAttribute("com.ibm.wsspi.security.oidc.client.request");
        ProviderAuthenticationResult oidcResult = null;
        oidcResult = this.verifyResponseState(req, res, responseState, clientConfig);
        if (oidcResult != null) {
            return oidcResult;
        }
        oidcClientRequest.setTokenType("ID Token");
        oidcResult = this.jose4jUtil.createResultWithJose4J(responseState, reqParameters, clientConfig, oidcClientRequest);
        if (clientConfig.getUserInfoEndpointUrl() != null) {
            boolean needHttps = clientConfig.getUserInfoEndpointUrl().toLowerCase().startsWith("https");
            SSLSocketFactory sslSocketFactory = null;
            try {
                sslSocketFactory = new OidcClientHttpUtil().getSSLSocketFactory(clientConfig, this.sslSupport, false, needHttps);
            }
            catch (SSLException sSLException) {
                FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil", (String)"264", (Object)this, (Object[])new Object[]{req, res, responseState, clientConfig, reqParameters});
            }
            new UserInfoHelper(clientConfig).getUserInfoIfPossible(oidcResult, reqParameters, sslSocketFactory);
        }
        return oidcResult;
    }

    public static boolean checkHttpsRequirement(ConvergedClientConfig clientConfig, String urlStr) {
        boolean metHttpsRequirement = true;
        if (clientConfig.isHttpsRequired()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Checking if URL starts with https: " + urlStr), (Object[])new Object[0]);
            }
            if (urlStr != null && !urlStr.startsWith("https")) {
                metHttpsRequirement = false;
            }
        }
        return metHttpsRequirement;
    }

    public static boolean isEndpointValid(ConvergedClientConfig clientConfig) {
        String url = null;
        url = clientConfig.getGrantType() == "implicit" ? clientConfig.getTokenEndpointUrl() : clientConfig.getAuthorizationEndpointUrl();
        return url != null;
    }

    public String setRedirectUrlIfNotDefined(HttpServletRequest req, ConvergedClientConfig clientConfig) {
        String redirect_url = null;
        redirect_url = clientConfig.isSocial() ? this.getRedirectUrlFromServerToClient(clientConfig.getId(), clientConfig.getContextPath(), clientConfig.getRedirectUrlFromServerToClient()) : clientConfig.getRedirectUrlFromServerToClient();
        if (redirect_url == null || redirect_url.isEmpty()) {
            String uri = clientConfig.getContextPath() + "/redirect/" + clientConfig.getId();
            redirect_url = new OidcClientUtil().getRedirectUrl(req, uri);
        }
        redirect_url = clientConfig.getRedirectUrlWithJunctionPath(redirect_url);
        return redirect_url;
    }

    /*
     * WARNING - void declaration
     */
    public String getRedirectUrlFromServerToClient(String clientId, String contextPath, String redirectToRPHostAndPort) {
        String redirectURL;
        block5: {
            redirectURL = null;
            if (redirectToRPHostAndPort != null && redirectToRPHostAndPort.length() > 0) {
                try {
                    final String fHostPort = redirectToRPHostAndPort;
                    URL url = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){
                        static final long serialVersionUID = -4277573649820552558L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        public Object run() throws Exception {
                            return new URL(fHostPort);
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
                        }
                    });
                    int port = url.getPort();
                    String path = url.getPath();
                    if (path == null) {
                        path = "";
                    }
                    if (path.endsWith("/")) {
                        path = path.substring(0, path.length() - 1);
                    }
                    String entryPoint = path + contextPath + "/redirect/" + clientId;
                    redirectURL = url.getProtocol() + "://" + url.getHost() + (port > 0 ? ":" + port : "");
                    redirectURL = redirectURL + (entryPoint.startsWith("/") ? "" : "/") + entryPoint;
                }
                catch (Exception fHostPort) {
                    void e;
                    FFDCFilter.processException((Throwable)fHostPort, (String)"com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil", (String)"341", (Object)this, (Object[])new Object[]{clientId, contextPath, redirectToRPHostAndPort});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)("the value of redirectToRPHostAndPort might not valid. Please verify that the format is <protocol>://<host>:<port> " + redirectToRPHostAndPort + "\n" + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        return redirectURL;
    }

    private boolean isOpenIDScopeSpecified(ConvergedClientConfig clientConfig) {
        String scope = null;
        scope = clientConfig.getScope();
        return scope.contains("openid");
    }

    String buildAuthorizationUrlWithQuery(HttpServletRequest req, OidcClientRequest oidcClientRequest, String state, ConvergedClientConfig clientConfig, String redirect_url, String acr_values) throws UnsupportedEncodingException {
        String strResponse_type = "code";
        boolean isImplicit = false;
        if ("implicit".equals(clientConfig.getGrantType())) {
            isImplicit = true;
            strResponse_type = clientConfig.getResponseType();
        }
        String clientId = clientConfig.getClientId() == null ? "" : clientConfig.getClientId();
        String query = String.format("response_type=%s&client_id=%s&state=%s&redirect_uri=%s&scope=%s", URLEncoder.encode(strResponse_type, "UTF-8"), URLEncoder.encode(clientId, "UTF-8"), URLEncoder.encode(state, "UTF-8"), URLEncoder.encode(redirect_url, "UTF-8"), URLEncoder.encode(clientConfig.getScope(), "UTF-8"));
        if (clientConfig.isNonceEnabled() || isImplicit) {
            String nonceValue = OidcUtil.generateRandom(20);
            OidcUtil.createNonceCookie(oidcClientRequest, nonceValue, state, clientConfig);
            query = String.format("%s&nonce=%s", query, URLEncoder.encode(nonceValue, "UTF-8"));
        }
        if (acr_values != null && !acr_values.isEmpty()) {
            query = String.format("%s&acr_values=%s", query, URLEncoder.encode(acr_values, "UTF-8"));
        } else if (this.isACRConfigured(clientConfig)) {
            query = String.format("%s&acr_values=%s", query, URLEncoder.encode(clientConfig.getAuthContextClassReference(), "UTF-8"));
        }
        if (clientConfig.getPrompt() != null) {
            query = String.format("%s&prompt=%s", query, URLEncoder.encode(clientConfig.getPrompt(), "UTF-8"));
        }
        if (isImplicit) {
            query = String.format("%s&response_mode=%s", query, URLEncoder.encode("form_post", "UTF-8"));
            String resources = OIDCClientAuthenticatorUtil.getResourcesParameter(clientConfig);
            if (resources != null) {
                query = query + resources;
            }
        }
        query = this.handleCustomParams(clientConfig, query);
        query = this.addForwardLoginParamsToQuery(clientConfig, req, query);
        String s = clientConfig.getAuthorizationEndpointUrl();
        String queryMark = "?";
        if (s != null && s.indexOf("?") > 0) {
            queryMark = "&";
        }
        return s + queryMark + query;
    }

    String addForwardLoginParamsToQuery(ConvergedClientConfig clientConfig, HttpServletRequest req, String query) {
        List<String> forwardAuthzParams = clientConfig.getForwardLoginParameter();
        if (forwardAuthzParams == null || forwardAuthzParams.isEmpty()) {
            return query;
        }
        for (String entry : forwardAuthzParams) {
            String value;
            if (entry == null || (value = req.getParameter(entry)) == null) continue;
            try {
                query = String.format("%s&%s=%s", query, URLEncoder.encode(entry, "UTF-8"), URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil", (String)"434", (Object)this, (Object[])new Object[]{clientConfig, req, query});
            }
        }
        return query;
    }

    private String handleCustomParams(ConvergedClientConfig clientConfig, String query) {
        HashMap<String, String> customParams = clientConfig.getAuthzRequestParams();
        if (customParams != null && !customParams.isEmpty()) {
            Set<Map.Entry<String, String>> entries = customParams.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                try {
                    query = String.format("%s&%s=%s", query, URLEncoder.encode(entry.getKey(), "UTF-8"), URLEncoder.encode(entry.getValue(), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil", (String)"458", (Object)this, (Object[])new Object[]{clientConfig, query});
                }
            }
        }
        return query;
    }

    private boolean isACRConfigured(ConvergedClientConfig clientConfig) {
        boolean isACR = false;
        String acr_values = null;
        acr_values = clientConfig.getAuthContextClassReference();
        if (acr_values != null && !acr_values.isEmpty()) {
            isACR = true;
        }
        return isACR;
    }

    public static String getResourcesParameter(ConvergedClientConfig clientConfig) throws UnsupportedEncodingException {
        String result = null;
        String resources = OIDCClientAuthenticatorUtil.getResources(clientConfig);
        if (resources != null && !resources.isEmpty()) {
            result = "&resource=" + URLEncoder.encode(resources, "UTF-8");
        }
        return result;
    }

    public static String getResources(ConvergedClientConfig clientConfig) {
        String[] resources = clientConfig.getResources();
        String result = null;
        if (resources != null && resources.length > 0) {
            result = "";
            for (int iI = 0; iI < resources.length; ++iI) {
                if (iI > 0) {
                    result = result.concat(" ");
                }
                result = result.concat(resources[iI]);
            }
        }
        return result;
    }

    private void doClientSideRedirect(HttpServletResponse response, String loginURL, String state, String domain) throws IOException {
        response.setStatus(200);
        PrintWriter pw = response.getWriter();
        pw.println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        pw.println("<head>");
        pw.println(this.createJavaScriptForRedirect(loginURL, state, domain));
        pw.println("<title>Redirect To OP</title> ");
        pw.println("</head>");
        pw.println("<body></body>");
        pw.println("</html>");
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, private, max-age=0");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("text/html; charset=UTF-8");
        pw.close();
    }

    private String createJavaScriptForRedirect(String loginURL, String state, String domain) {
        String cookieName = "WASReqURLOidc" + HashUtils.getStrHashCode(state);
        StringBuilder sb = new StringBuilder();
        String strDomain = "";
        if (domain != null && !domain.isEmpty()) {
            strDomain = "domain=" + domain + ";";
        }
        sb.append("<script type=\"text/javascript\" language=\"javascript\">").append("var loc=window.location.href;").append("document.cookie=\"").append(cookieName).append("=\"").append("+loc+").append("\";" + strDomain + " path=/;");
        WebAppSecurityConfig webAppSecurityConfig = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig();
        if (webAppSecurityConfig != null && webAppSecurityConfig.getSSORequiresSSL()) {
            sb.append(" secure;");
        }
        sb.append("\"</script>");
        sb.append("<script type=\"text/javascript\" language=\"javascript\">").append("window.location.replace(\"" + loginURL + "\")").append("</script>");
        String js = sb.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createJavaScriptForRedirect returns [" + js + "]"), (Object[])new Object[0]);
        }
        return js;
    }

    String getReqURL(HttpServletRequest req) {
        String queryString;
        boolean rewritePort = false;
        Integer realPort = null;
        if (req.getScheme().toLowerCase().contains("https")) {
            realPort = new WebUtils().getRedirectPortFromRequest(req);
        }
        int port = req.getServerPort();
        if (realPort != null && realPort != port) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("serverport = " + port + "real port is " + realPort.toString() + ", url will be rewritten to use real port"), (Object[])new Object[0]);
            }
            rewritePort = true;
        }
        StringBuffer reqURL = req.getRequestURL();
        if (rewritePort) {
            reqURL = new StringBuffer();
            reqURL.append(req.getScheme());
            reqURL.append("://");
            reqURL.append(req.getServerName());
            reqURL.append(":");
            reqURL.append(realPort);
            reqURL.append(req.getRequestURI());
        }
        if ((queryString = req.getQueryString()) != null) {
            reqURL.append("?");
            reqURL.append(OidcUtil.encodeQuery(queryString));
        }
        return reqURL.toString();
    }

    @FFDCIgnore(value={IndexOutOfBoundsException.class})
    public boolean validateReqParameters(ConvergedClientConfig clientConfig, Hashtable<String, String> reqParameters, String cookieValue) {
        String requestParameters;
        String encoded;
        boolean validCookie;
        block13: {
            validCookie = true;
            encoded = null;
            String cookieName = "WASOidcCode";
            requestParameters = null;
            try {
                int lastindex = cookieValue.lastIndexOf("_");
                if (lastindex < 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The cookie may have been tampered with.", (Object[])new Object[0]);
                        if (lastindex < 0) {
                            Tr.debug((TraceComponent)tc, (String)"The cookie does not contain an underscore.", (Object[])new Object[0]);
                        }
                        if (lastindex == 0) {
                            Tr.debug((TraceComponent)tc, (String)"The cookie does not contain a value before the underscore.", (Object[])new Object[0]);
                        }
                    }
                    return false;
                }
                encoded = cookieValue.substring(0, lastindex);
                String testCookie = OidcClientUtil.calculateOidcCodeCookieValue(encoded, clientConfig);
                if (!cookieValue.equals(testCookie)) {
                    String msg = "The value for the OIDC state cookie [" + cookieName + "] failed validation.";
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                    }
                    validCookie = false;
                }
            }
            catch (IndexOutOfBoundsException e) {
                validCookie = false;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block13;
                Tr.debug((TraceComponent)tc, (String)"unexpected exception:", (Object[])new Object[]{e});
            }
        }
        if (validCookie) {
            requestParameters = Base64Coder.toString(Base64Coder.base64DecodeString(encoded));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("decodedRequestParameters:" + requestParameters), (Object[])new Object[0]);
            }
            JsonParser parser = new JsonParser();
            JsonObject jsonObject = (JsonObject)parser.parse(requestParameters);
            Set entries = jsonObject.entrySet();
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                JsonElement element = (JsonElement)entry.getValue();
                if (element.isJsonObject() || element.isJsonPrimitive()) {
                    reqParameters.put(key, element.getAsString());
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("parameterKey:" + key + "  value:" + element.getAsString()), (Object[])new Object[0]);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("unexpected json element:" + element.getClass().getName()), (Object[])new Object[0]);
                }
                validCookie = false;
            }
        }
        return validCookie;
    }

    public ProviderAuthenticationResult verifyResponseState(HttpServletRequest req, HttpServletResponse res, String responseState, ConvergedClientConfig clientConfig) {
        Boolean bValidState = false;
        if (responseState != null) {
            bValidState = this.verifyState(req, res, responseState, clientConfig);
        }
        if (!bValidState.booleanValue()) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_RESPONSE_STATE_ERR", (Object[])new Object[]{responseState, clientConfig.getClientId()});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        return null;
    }

    public Boolean verifyState(HttpServletRequest req, HttpServletResponse res, String responseState, ConvergedClientConfig clientConfig) {
        if (responseState.length() < 24) {
            return false;
        }
        long clockSkewMillSeconds = clientConfig.getClockSkewInSeconds() * 1000L;
        long allowHandleTimeMillSeconds = clientConfig.getAuthenticationTimeLimitInSeconds() * 1000L + clockSkewMillSeconds;
        Cookie[] cookies = req.getCookies();
        String cookieName = "WASOidcState" + HashUtils.getStrHashCode(responseState);
        String stateKey = CookieHelper.getCookieValue((Cookie[])cookies, (String)cookieName);
        OidcClientUtil.invalidateReferrerURLCookie(req, res, cookieName);
        String cookieValue = HashUtils.createStateCookieValue(clientConfig, responseState);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("stateKey:'" + stateKey + "' cookieValue:'" + cookieValue + "'"), (Object[])new Object[0]);
        }
        if (cookieValue.equals(stateKey)) {
            long lNumber = OidcUtil.convertNormalizedTimeStampToLong(responseState);
            long lDate = new Date().getTime();
            long difference = lDate - lNumber;
            if (difference < 0L) {
                if ((difference *= -1L) >= clockSkewMillSeconds && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("error current: " + lDate + "  ran at:" + lNumber), (Object[])new Object[0]);
                }
                return difference < clockSkewMillSeconds;
            }
            if (difference >= allowHandleTimeMillSeconds && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("error current: " + lDate + "  ran at:" + lNumber), (Object[])new Object[0]);
            }
            return difference < allowHandleTimeMillSeconds;
        }
        return false;
    }

    public String getIssuerIdentifier(ConvergedClientConfig clientConfig) {
        String issuer = null;
        issuer = clientConfig.getIssuerIdentifier();
        if (issuer == null || issuer.isEmpty()) {
            issuer = this.extractIssuerFromTokenEndpointUrl(clientConfig);
        }
        return issuer;
    }

    String extractIssuerFromTokenEndpointUrl(ConvergedClientConfig clientConfig) {
        String issuer = null;
        String tokenEndpoint = clientConfig.getTokenEndpointUrl();
        if (tokenEndpoint != null) {
            int endOfSchemeIndex = tokenEndpoint.indexOf("//");
            int lastSlashIndex = tokenEndpoint.lastIndexOf("/");
            boolean urlContainsScheme = endOfSchemeIndex > -1;
            boolean urlContainsSlash = lastSlashIndex > -1;
            issuer = !urlContainsScheme && !urlContainsSlash || urlContainsScheme && lastSlashIndex == endOfSchemeIndex + 1 ? tokenEndpoint : tokenEndpoint.substring(0, lastSlashIndex);
        }
        return issuer;
    }
}

