/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.token;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.token.HeaderParameter;
import com.ibm.ws.security.openidconnect.token.JWSHeader;
import com.ibm.ws.security.openidconnect.token.JWTPayload;
import com.ibm.ws.security.openidconnect.token.WSJsonToken;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.joda.time.Duration;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JsonTokenUtil {
    public static final String DELIMITER = ".";
    public static final long DEFAULT_SKEW_IN_SECONDS = 180L;
    public static final Duration SKEW;
    static final long serialVersionUID = 3330392006565442240L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String toBase64(JsonObject json) {
        return JsonTokenUtil.convertToBase64(JsonTokenUtil.toJson(json));
    }

    public static String toJson(JsonObject json) {
        return new Gson().toJson((JsonElement)json);
    }

    public static String toJsonFromObj(Object json) {
        return new Gson().toJson(json);
    }

    public static String convertToBase64(String source) {
        return Base64.encodeBase64URLSafeString((byte[])StringUtils.getBytesUtf8((String)source));
    }

    public static String decodeFromBase64String(String encoded) {
        return new String(Base64.decodeBase64((String)encoded));
    }

    public static String fromBase64ToJsonString(String source) {
        return StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)source));
    }

    public static String toDotFormat(String ... parts) {
        StringBuffer result = new StringBuffer();
        if (parts != null) {
            for (int i = 0; i < parts.length; ++i) {
                String part;
                if (i > 0 && i < parts.length) {
                    result.append(DELIMITER);
                }
                result.append((part = parts[i]) == null ? "" : part);
            }
        }
        return result.toString();
    }

    public static boolean isCurrentTimeInInterval(long clockSkewInSeconds, long issuedAtMsec, long expirationMsec) {
        long skew = clockSkewInSeconds * 1000L;
        long now = System.currentTimeMillis();
        boolean isAfterEarliest = now + skew > issuedAtMsec;
        boolean isBeforeLatest = now - skew < expirationMsec;
        return isAfterEarliest && isBeforeLatest;
    }

    public static String[] splitTokenString(String tokenString) {
        boolean isPlainTextJWT = false;
        if (tokenString.endsWith(DELIMITER)) {
            isPlainTextJWT = true;
        }
        String[] pieces = tokenString.split(Pattern.quote(DELIMITER));
        if (!isPlainTextJWT && pieces.length != 3) {
            throw new IllegalStateException("Expected JWT to have 3 segments separated by '.', but it has " + pieces.length + " segments");
        }
        return pieces;
    }

    public static WSJsonToken deserialize(String[] pieces, String tokenString) {
        String jwtHeaderSegment = pieces[0];
        String jwtPayloadSegment = pieces[1];
        JsonParser parser = new JsonParser();
        JsonObject header = parser.parse(JsonTokenUtil.fromBase64ToJsonString(jwtHeaderSegment)).getAsJsonObject();
        JsonObject payload = parser.parse(JsonTokenUtil.fromBase64ToJsonString(jwtPayloadSegment)).getAsJsonObject();
        WSJsonToken jsonToken = new WSJsonToken(header, payload, SKEW, tokenString);
        return jsonToken;
    }

    public static void fromJsonToken(WSJsonToken token, JWTPayload resultPayload) {
        if (token == null || resultPayload == null) {
            return;
        }
        JsonObject payload = token.getPayload();
        if (payload == null) {
            return;
        }
        Set entries = payload.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            JsonElement jsonElem = (JsonElement)entry.getValue();
            if (jsonElem.isJsonPrimitive()) {
                resultPayload.put(key, JsonTokenUtil.getJsonPrimitive(jsonElem.getAsJsonPrimitive()));
                continue;
            }
            if (jsonElem.isJsonArray()) {
                resultPayload.put(key, JsonTokenUtil.createListFromJsonArray(jsonElem.getAsJsonArray()));
                continue;
            }
            if (jsonElem.isJsonObject()) {
                resultPayload.put(key, JsonTokenUtil.createMapFromJsonObject(jsonElem.getAsJsonObject()));
                continue;
            }
            resultPayload.put(key, jsonElem);
        }
    }

    public static void fromJsonToken(WSJsonToken token, JWSHeader resultHeader) {
        if (token == null || resultHeader == null) {
            return;
        }
        JsonObject header = token.getHeader();
        if (header == null) {
            return;
        }
        Set entries = header.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            JsonElement jsonElem = (JsonElement)entry.getValue();
            if (jsonElem.isJsonPrimitive()) {
                if (jsonElem.getAsJsonPrimitive().isString()) {
                    JsonTokenUtil.addToHeaderFields(resultHeader, key, jsonElem.getAsString());
                }
                resultHeader.put(key, JsonTokenUtil.getJsonPrimitive(jsonElem.getAsJsonPrimitive()));
                continue;
            }
            if (jsonElem.isJsonArray()) {
                JsonArray jsonarray = jsonElem.getAsJsonArray();
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < jsonarray.size(); ++i) {
                    JsonElement arrayElement = jsonarray.get(i);
                    if (!arrayElement.isJsonPrimitive() || !arrayElement.getAsJsonPrimitive().isString()) continue;
                    list.add(arrayElement.getAsString());
                }
                resultHeader.put(key, list);
                JsonTokenUtil.addToHeaderFields(resultHeader, key, list);
                continue;
            }
            if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
        }
    }

    public static void addToHeaderFields(JWSHeader header, String key, String value) {
        HeaderParameter param = HeaderParameter.valueOf(key.toUpperCase());
        switch (param) {
            case TYP: {
                header.setType(value);
                break;
            }
            case CTY: {
                header.setContentType(value);
                break;
            }
            case ALG: {
                header.setAlgorithm(value);
                break;
            }
            case JKU: {
                header.setJwkUrl(value);
                break;
            }
            case JWK: {
                header.setJwk(value);
                break;
            }
            case KID: {
                header.setKeyId(value);
                break;
            }
            case X5U: {
                header.setX509Url(value);
                break;
            }
            case X5T: {
                header.setX509Thumbprint(value);
                break;
            }
            case X5C: {
                header.setX509Certificate(value);
                break;
            }
        }
    }

    public static void addToHeaderFields(JWSHeader header, String key, List<String> value) {
        HeaderParameter param = HeaderParameter.valueOf(key.toUpperCase());
        switch (param) {
            case CRIT: {
                header.setCritical(value);
                break;
            }
        }
    }

    public static JWTPayload getPayload(String tokenString) {
        JWTPayload payload = null;
        String[] jwtParts = JsonTokenUtil.splitTokenString(tokenString);
        if (jwtParts.length >= 2) {
            WSJsonToken token = JsonTokenUtil.deserialize(jwtParts, tokenString);
            payload = new JWTPayload();
            JsonTokenUtil.fromJsonToken(token, payload);
        }
        return payload;
    }

    protected static String getElement(JWTPayload payload, String element) {
        String output = null;
        if (payload != null) {
            Object outObj = payload.get(element);
            if (outObj instanceof String) {
                output = (String)outObj;
            } else if (outObj instanceof List && ((List)outObj).size() == 1) {
                output = (String)((List)outObj).get(0);
            }
        }
        return output;
    }

    public static String getAud(JWTPayload payload) {
        return JsonTokenUtil.getElement(payload, "aud");
    }

    public static String getIss(JWTPayload payload) {
        return JsonTokenUtil.getElement(payload, "iss");
    }

    public static String getSub(JWTPayload payload) {
        return JsonTokenUtil.getElement(payload, "sub");
    }

    private JsonTokenUtil() {
    }

    public static String accessTokenHash(@Sensitive String accessToken) {
        byte[] accessTokenBytes = null;
        accessTokenBytes = Base64Coder.getBytes(accessToken);
        byte[] left_hash = new byte[16];
        String atHash = null;
        String hashAlg = "SHA-256";
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(hashAlg);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive java.lang.String>";
            FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.openidconnect.token.JsonTokenUtil", (String)"316", null, (Object[])objectArray);
        }
        if (digest != null) {
            byte[] hash = null;
            hash = digest.digest(accessTokenBytes);
            if (hash != null) {
                System.arraycopy(hash, 0, left_hash, 0, 16);
                atHash = Base64.encodeBase64URLSafeString((byte[])left_hash);
            }
        }
        return atHash;
    }

    public static void validateTokenString(String tokenString, String alg, @Sensitive Key key, long secondsClockSkew, boolean forSignatureOnly) throws InvalidJwtException {
        AlgorithmConstraints algorithmConstraints = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, new String[]{alg});
        JwtConsumer firstPassJwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setDisableRequireSignature().setSkipSignatureVerification().build();
        JwtContext jwtContext = firstPassJwtConsumer.process(tokenString);
        JwtConsumerBuilder secondBuilder = new JwtConsumerBuilder().setVerificationKey(key).setJwsAlgorithmConstraints(algorithmConstraints).setRelaxVerificationKeyValidation().setSkipDefaultAudienceValidation();
        if (forSignatureOnly) {
            secondBuilder.setSkipAllValidators();
        } else {
            if (secondsClockSkew > Integer.MAX_VALUE) {
                secondsClockSkew = Integer.MAX_VALUE;
            }
            secondBuilder = secondBuilder.setAllowedClockSkewInSeconds((int)secondsClockSkew);
        }
        JwtConsumer secondPassJwtConsumer = secondBuilder.build();
        secondPassJwtConsumer.processContext(jwtContext);
    }

    static Object getJsonPrimitive(JsonPrimitive primitive) {
        if (primitive == null) {
            return primitive;
        }
        if (primitive.isNumber()) {
            return JsonTokenUtil.getJsonPrimitiveNumber(primitive);
        }
        if (primitive.isString()) {
            return primitive.getAsString();
        }
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        return primitive;
    }

    static Number getJsonPrimitiveNumber(JsonPrimitive primitive) {
        double doubleVal;
        long longVal = primitive.getAsLong();
        if ((double)longVal < (doubleVal = primitive.getAsDouble())) {
            return doubleVal;
        }
        return longVal;
    }

    static List<Object> createListFromJsonArray(JsonArray array) {
        if (array == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.size(); ++i) {
            JsonElement arrayElement = array.get(i);
            if (arrayElement.isJsonPrimitive()) {
                list.add(JsonTokenUtil.getJsonPrimitive(arrayElement.getAsJsonPrimitive()));
                continue;
            }
            if (arrayElement.isJsonArray()) {
                list.add(JsonTokenUtil.createListFromJsonArray(arrayElement.getAsJsonArray()));
                continue;
            }
            if (arrayElement.isJsonObject()) {
                list.add(JsonTokenUtil.createMapFromJsonObject(arrayElement.getAsJsonObject()));
                continue;
            }
            list.add(arrayElement);
        }
        return list;
    }

    static Map<String, Object> createMapFromJsonObject(JsonObject object) {
        if (object == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : object.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement subElement = (JsonElement)entry.getValue();
            if (subElement.isJsonPrimitive()) {
                map.put(key, JsonTokenUtil.getJsonPrimitive(subElement.getAsJsonPrimitive()));
                continue;
            }
            if (subElement.isJsonArray()) {
                map.put(key, JsonTokenUtil.createListFromJsonArray(subElement.getAsJsonArray()));
                continue;
            }
            if (subElement.isJsonObject()) {
                map.put(key, JsonTokenUtil.createMapFromJsonObject(subElement.getAsJsonObject()));
                continue;
            }
            map.put(key, subElement);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JsonTokenUtil.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.common.internal.resources.OidcCommonMessages");
        SKEW = Duration.standardMinutes((long)3L);
    }
}

