/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.admin.DestinationAliasDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.admin.MQLinkDefinition;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.admin.VirtualLinkDefinition;
import com.ibm.ws.sib.processor.Administrator;
import com.ibm.ws.sib.processor.SubscriptionDefinition;
import com.ibm.ws.sib.processor.exceptions.SIMPDestinationAlreadyExistsException;
import com.ibm.ws.sib.processor.exceptions.SIMPDestinationCorruptException;
import com.ibm.ws.sib.processor.exceptions.SIMPNullParameterException;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.SubscriptionDefinitionImpl;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPLocalMsgsItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPMessageProcessorControllable;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public final class AdministratorImpl
implements Administrator {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(AdministratorImpl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MessageProcessor messageProcessor;
    private DestinationManager destinationManager;
    private boolean started;

    public AdministratorImpl(MessageProcessor messageProcessor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AdministratorImpl", (Object)messageProcessor);
        }
        this.messageProcessor = messageProcessor;
        this.destinationManager = messageProcessor.getDestinationManager();
        this.started = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AdministratorImpl", (Object)this);
        }
    }

    public void createSubscription(String id, SubscriptionDefinition subDef, SITransaction tran) throws SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIMPDestinationCorruptException, SIDurableSubscriptionAlreadyExistsException, SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIResourceException {
        DestinationHandler dest;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSubscription", (Object)new Object[]{id, subDef, tran});
        }
        this.checkStarted();
        try {
            dest = this.destinationManager.getDestination(subDef.getDestination(), false);
        }
        catch (SITemporaryDestinationNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSubscription", (Object)"SINotPossibleInCurrentConfigurationException");
            }
            throw new SINotPossibleInCurrentConfigurationException(e.getMessage());
        }
        SelectorDomain sDomain = SelectorDomain.getSelectorDomain((int)subDef.getSelectorDomain());
        SelectionCriteria criteria = this.messageProcessor.getSelectionCriteriaFactory().createSelectionCriteria(subDef.getTopic(), subDef.getSelector(), sDomain);
        ConsumerDispatcherState subState = new ConsumerDispatcherState(id, dest.getUuid(), criteria, subDef.isNoLocal(), subDef.getDurableHome(), dest.getName(), dest.getBus());
        subState.setIsCloned(subDef.isSupportsMultipleConsumers());
        subState.setUser(subDef.getUser(), false);
        subState.setTargetDestination(subDef.getTargetDestination());
        if (!dest.isPubSub()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSubscription", (Object)"SIIncorrectCallException");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_USEAGE_ERROR_CWSIP0141", new Object[]{dest.getName(), this.messageProcessor.getMessagingEngineName(), id}, null));
        }
        dest.createDurableSubscription(subState, (TransactionCommon)tran);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSubscription");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSubscription(String subId, boolean force) throws SINotAuthorizedException, SIDurableSubscriptionNotFoundException, SIDestinationLockedException, SIResourceException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        HashMap durableSubs;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteSubscription", (Object)new Object[]{subId, new Boolean(force)});
        }
        this.checkStarted();
        if (subId == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteSubscription", (Object)"SubId is null");
            }
            throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0072", new Object[]{null, this.messageProcessor.getMessagingEngineName()}, null));
        }
        HashMap hashMap = durableSubs = this.destinationManager.getDurableSubscriptionsTable();
        synchronized (hashMap) {
            ConsumerDispatcher cd = (ConsumerDispatcher)durableSubs.get(subId);
            if (cd == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteSubscription", (Object)"SIDurableSubscriptionNotFoundException");
                }
                throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0146", new Object[]{subId, this.messageProcessor.getMessagingEngineName()}, null));
            }
            BaseDestinationHandler destination = cd.getDestination();
            destination.deleteDurableSubscription(subId, this.messageProcessor.getMessagingEngineName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteSubscription");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionDefinition querySubscription(String subId) throws SIDurableSubscriptionNotFoundException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException {
        HashMap durableSubs;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"querySubscription", (Object)subId);
        }
        this.checkStarted();
        if (subId == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"querySubscription", (Object)"Exception SubId null");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0072", new Object[]{null, this.messageProcessor.getMessagingEngineName()}, null));
        }
        ConsumerDispatcherState subState = null;
        HashMap hashMap = durableSubs = this.destinationManager.getDurableSubscriptionsTable();
        synchronized (hashMap) {
            ConsumerDispatcher cd = (ConsumerDispatcher)durableSubs.get(subId);
            if (cd == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"querySubscription", (Object)"Subscription not found");
                }
                throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0072", new Object[]{subId, this.messageProcessor.getMessagingEngineName()}, null));
            }
            subState = cd.getConsumerDispatcherState();
        }
        DestinationHandler dest = null;
        try {
            dest = this.destinationManager.getDestination(subState.getTopicSpaceUuid(), true);
        }
        catch (SITemporaryDestinationNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"querySubscription", (Object)"SINotPossibleInCurrentConfigurationException");
            }
            throw new SINotPossibleInCurrentConfigurationException(e.getMessage());
        }
        SubscriptionDefinitionImpl subDef = new SubscriptionDefinitionImpl(dest.getName(), subState.getSelectionCriteria().getDiscriminator(), subState.getSelectionCriteria().getSelectorString(), subState.getSelectionCriteria().getSelectorDomain().toInt(), subState.getUser(), subState.isNoLocal(), subState.getDurableHome());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"querySubscription", (Object)subDef);
        }
        return subDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSubscriptionList() {
        ArrayList list;
        HashMap durableSubs;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionList");
        }
        HashMap hashMap = durableSubs = this.destinationManager.getDurableSubscriptionsTable();
        synchronized (hashMap) {
            list = new ArrayList(durableSubs.keySet());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptionList", list);
        }
        return list;
    }

    public SubscriptionDefinition createSubscriptionDefinition() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSubscriptionDefinition");
        }
        SubscriptionDefinitionImpl subDef = new SubscriptionDefinitionImpl();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSubscriptionDefinition", (Object)subDef);
        }
        return subDef;
    }

    public void createDestinationLocalization(DestinationDefinition destinationDefinition, LocalizationDefinition destinationLocalizationDefinition) throws SIBExceptionDestinationNotFound, SIBExceptionBase, SIResourceException, SIMPDestinationAlreadyExistsException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDestinationLocalization", (Object)new Object[]{destinationDefinition, destinationLocalizationDefinition});
        }
        this.checkStarted();
        Set destinationLocalizingSet = this.messageProcessor.getSIBDestinationLocalitySet(null, null, true);
        this.destinationManager.createDestinationLocalization(destinationDefinition, destinationLocalizationDefinition, destinationLocalizingSet, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization");
        }
    }

    public void createDestinationLocalization(DestinationDefinition destinationDefinition, LocalizationDefinition destinationLocalizationDefinition, Set destinationLocalizingMEs, boolean isTemporary) throws SIResourceException, SIMPDestinationAlreadyExistsException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDestinationLocalization", (Object)new Object[]{destinationDefinition, destinationLocalizationDefinition, destinationLocalizingMEs, new Boolean(isTemporary)});
        }
        this.destinationManager.createDestinationLocalization(destinationDefinition, destinationLocalizationDefinition, destinationLocalizingMEs, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization");
        }
    }

    public void alterDestinationLocalization(DestinationDefinition destinationDefinition, LocalizationDefinition destinationLocalizationDefinition) throws SIBExceptionDestinationNotFound, SIBExceptionBase, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alterDestinationLocalization", (Object)new Object[]{destinationLocalizationDefinition, destinationDefinition});
        }
        this.checkStarted();
        Set queuePointLocalizingSet = this.messageProcessor.getSIBDestinationLocalitySet(null, destinationDefinition.getUUID().toString(), true);
        this.destinationManager.alterDestinationLocalization(destinationDefinition, destinationLocalizationDefinition, queuePointLocalizingSet);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization");
        }
    }

    public void deleteDestinationLocalization(String destinationUuid, DestinationDefinition destinationDefinition) throws SIBExceptionDestinationNotFound, SIBExceptionBase, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteDestinationLocalization", (Object)new Object[]{destinationUuid});
        }
        this.checkStarted();
        Set queuePointLocalizingSet = null;
        if (destinationDefinition != null) {
            queuePointLocalizingSet = this.messageProcessor.getSIBDestinationLocalitySet(null, destinationDefinition.getUUID().toString(), true);
        }
        this.destinationManager.deleteDestinationLocalization(destinationUuid, destinationDefinition, queuePointLocalizingSet);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteDestinationLocalization");
        }
    }

    public LocalizationDefinition getDestinationLocalizationDefinition(String destinationUuid) throws SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationLocalizationDefinition", (Object)destinationUuid);
        }
        this.checkStarted();
        LocalizationDefinition localizationDefinition = null;
        DestinationHandler destinationHandler = null;
        try {
            destinationHandler = this.destinationManager.getDestination(new SIBUuid12(destinationUuid), false);
        }
        catch (SITemporaryDestinationNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getDestinationLocalizationDefinition", (Object)"SINotPossibleInCurrentConfigurationException");
            }
            throw new SINotPossibleInCurrentConfigurationException(e.getMessage());
        }
        if (destinationHandler.isPubSub()) {
            PubSubMessageItemStream pubSubMessageItemStream = destinationHandler.getPublishPoint();
            if (pubSubMessageItemStream != null) {
                localizationDefinition = pubSubMessageItemStream.getLocalizationDefinition();
            }
        } else {
            PtoPLocalMsgsItemStream ptoPLocalMsgsItemStream = null;
            if (!destinationHandler.isAlias() && !destinationHandler.isForeign() && (ptoPLocalMsgsItemStream = (PtoPLocalMsgsItemStream)destinationHandler.getQueuePoint(this.messageProcessor.getMessagingEngineUuid())) != null) {
                localizationDefinition = ptoPLocalMsgsItemStream.getLocalizationDefinition();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationLocalizationDefinition", (Object)localizationDefinition);
        }
        return localizationDefinition;
    }

    public void initiateCleanUp(String destinationUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initiateCleanUp", (Object)destinationUuid);
        }
        DestinationHandler destinationHandler = null;
        try {
            destinationHandler = this.destinationManager.getDestination(new SIBUuid12(destinationUuid), true);
        }
        catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            // empty catch block
        }
        if (destinationHandler != null) {
            this.destinationManager.markDestinationAsCleanUpPending(destinationHandler);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initiateCleanUp");
        }
    }

    public void createMQLink(VirtualLinkDefinition vld, MQLinkDefinition mqld, LocalizationDefinition ld) throws SIIncorrectCallException, SIMPDestinationAlreadyExistsException, SIResourceException, SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMQLink", (Object)new Object[]{vld, mqld, ld});
        }
        this.checkStarted();
        Set localizingMEs = vld.getLinkLocalitySet();
        this.destinationManager.createMQLinkLocalization(mqld, ld, vld, localizingMEs);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createMQLink");
        }
    }

    public void createGatewayLink(VirtualLinkDefinition vld, String uuid) throws SIResourceException, SIMPDestinationAlreadyExistsException, SIIncorrectCallException, SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createGatewayLink", (Object)new Object[]{vld, uuid});
        }
        this.checkStarted();
        this.destinationManager.createLinkLocalization(vld);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createGatewayLink");
        }
    }

    public boolean destinationExists(String destinationName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destinationExists", (Object)destinationName);
        }
        boolean returnVal = false;
        try {
            returnVal = this.destinationManager.destinationExists(destinationName, this.messageProcessor.getMessagingEngineBus());
        }
        catch (SIMPNullParameterException sIMPNullParameterException) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destinationExists", (Object)new Boolean(returnVal));
        }
        return returnVal;
    }

    public SIMPMessageProcessorControllable getMPRuntimeControl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMPRuntimeControl");
        }
        SIMPMessageProcessorControllable control = (SIMPMessageProcessorControllable)this.messageProcessor.getControlAdapter();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMPRuntimeControl", (Object)control);
        }
        return control;
    }

    public boolean isStarted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isStarted");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isStarted", (Object)this.started);
        }
        return this.started;
    }

    public void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        this.started = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStarted() throws SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkStarted");
        }
        AdministratorImpl administratorImpl = this;
        synchronized (administratorImpl) {
            if (!this.isStarted()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkStarted", (Object)"ME not started");
                }
                throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("MESSAGE_PROCESSOR_NOT_STARTED_ERROR_CWSIP0211", new Object[]{this.messageProcessor.getMessagingEngineName(), this.messageProcessor.getMessagingEngineBus()}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkStarted");
        }
    }

    public void deleteGatewayLink(String linkUuid) throws SINotPossibleInCurrentConfigurationException, SIResourceException, SIConnectionLostException, SIException, SIBExceptionBase {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteGatewayLink", (Object)linkUuid);
        }
        this.destinationManager.deleteLinkLocalization(new SIBUuid12(linkUuid));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteGatewayLink");
        }
    }

    public void deleteMQLink(String mqLinkUuid) throws SINotPossibleInCurrentConfigurationException, SIResourceException, SIConnectionLostException, SIException, SIBExceptionBase {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteMQLink", (Object)mqLinkUuid);
        }
        this.destinationManager.deleteMQLinkLocalization(new SIBUuid8(mqLinkUuid));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteMQLink");
        }
    }

    public void alterMQLink(VirtualLinkDefinition vld, MQLinkDefinition mqld, LocalizationDefinition ld) throws SINotPossibleInCurrentConfigurationException, SIResourceException, SIConnectionLostException, SIException, SIBExceptionBase {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alterMQLink", (Object)new Object[]{vld, mqld, ld});
        }
        this.destinationManager.alterMQLinkLocalization(mqld, ld, vld);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alterMQLink");
        }
    }

    public void alterGatewayLink(VirtualLinkDefinition vld, String linkUuid) throws SINotPossibleInCurrentConfigurationException, SIResourceException, SIConnectionLostException, SIException, SIBExceptionBase {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alterGatewayLink", (Object)new Object[]{vld, linkUuid});
        }
        this.destinationManager.alterLinkLocalization(vld, new SIBUuid12(linkUuid));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alterGatewayLink");
        }
    }

    public void alterDestinationAlias(DestinationAliasDefinition destinationAliasDefinition) throws SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIResourceException, SIConnectionLostException, SIException, SIBExceptionBase {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alterDestinationAlias", (Object)new Object[]{destinationAliasDefinition.getName(), destinationAliasDefinition.getUUID()});
        }
        this.destinationManager.alterDestinationAlias(destinationAliasDefinition);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)("alterDestinationAlias= " + destinationAliasDefinition.getName()));
        }
    }
}

