/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.DecimalMin;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DecimalMinValidatorForNumber
implements ConstraintValidator<DecimalMin, Number> {
    private BigDecimal minValue;
    private int comparator = -1;
    static final long serialVersionUID = 6829491210335865899L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void initialize(DecimalMin annotation) {
        try {
            this.minValue = new BigDecimal(annotation.value());
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"org.apache.bval.constraints.DecimalMinValidatorForNumber", (String)"36", (Object)this, (Object[])new Object[]{annotation});
            throw new IllegalArgumentException(annotation.value() + " does not represent a valid BigDecimal format");
        }
        if (!annotation.inclusive()) {
            this.comparator = 0;
        }
    }

    public boolean isValid(Number value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(this.minValue) > this.comparator;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value).compareTo(this.minValue) > this.comparator;
        }
        return new BigDecimal(value.doubleValue()).compareTo(this.minValue) > this.comparator;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DecimalMinValidatorForNumber.class, null, null);
    }
}

