/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.csiv2.server;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.WSAuthenticationData;
import com.ibm.ws.security.authentication.helper.AuthenticateUserHelper;
import com.ibm.ws.security.csiv2.Authenticator;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuthenticatorImpl
implements Authenticator {
    private final String jaasEntryName = "system.RMI_INBOUND";
    private final AuthenticationService authenticationService;
    static final long serialVersionUID = 5912894823884562761L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AuthenticatorImpl(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public Subject authenticate(String username, @Sensitive String password) throws AuthenticationException {
        AuthenticationData authenticationData = this.createAuthenticationData(username, password);
        return this.authenticationService.authenticate("system.RMI_INBOUND", authenticationData, null);
    }

    public Subject authenticate(@Sensitive X509Certificate[] certificateChain) throws AuthenticationException {
        AuthenticationData authenticationData = this.createAuthenticationData(certificateChain);
        return this.authenticationService.authenticate("system.RMI_INBOUND", authenticationData, null);
    }

    public Subject authenticate(String assertedUser) throws AuthenticationException {
        AuthenticateUserHelper authHelper = new AuthenticateUserHelper();
        return authHelper.authenticateUser(this.authenticationService, assertedUser, "system.RMI_INBOUND");
    }

    public Subject authenticate(@Sensitive byte[] tokenBytes) throws AuthenticationException {
        AuthenticationData authenticationData = this.createAuthenticationData(tokenBytes);
        return this.authenticationService.authenticate("system.RMI_INBOUND", authenticationData, null);
    }

    @Trivial
    protected AuthenticationData createAuthenticationData(String username, @Sensitive String password) {
        WSAuthenticationData authenticationData = new WSAuthenticationData();
        authenticationData.set("USERNAME", (Object)username);
        authenticationData.set("PASSWORD", (Object)password.toCharArray());
        return authenticationData;
    }

    @Trivial
    private AuthenticationData createAuthenticationData(@Sensitive X509Certificate[] certificateChain) {
        WSAuthenticationData authenticationData = new WSAuthenticationData();
        authenticationData.set("CERTCHAIN", (Object)certificateChain);
        return authenticationData;
    }

    @Trivial
    private AuthenticationData createAuthenticationData(@Sensitive byte[] tokenBytes) {
        WSAuthenticationData authenticationData = new WSAuthenticationData();
        authenticationData.set("TOKEN", (Object)tokenBytes);
        return authenticationData;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(AuthenticatorImpl.class, null, null);
    }
}

