/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.helper;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.Constants;
import com.ibm.ws.microprofile.metrics.exceptions.EmptyRegistryException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchMetricException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchRegistryException;
import com.ibm.ws.microprofile.metrics.impl.SharedMetricRegistries;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Util {
    public static SharedMetricRegistries SHARED_METRIC_REGISTRIES;
    static final long serialVersionUID = -3463508502461566531L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static Map<String, Metric> getMetricsAsMap(String registryName, String metricName) throws NoSuchRegistryException, NoSuchMetricException, EmptyRegistryException {
        MetricRegistry registry = Util.getRegistry(registryName);
        Map metricMap = registry.getMetrics();
        HashMap<String, Metric> returnMap = new HashMap<String, Metric>();
        if (metricMap.isEmpty()) {
            throw new EmptyRegistryException();
        }
        if (!metricMap.containsKey(metricName)) {
            throw new NoSuchMetricException();
        }
        returnMap.put(metricName, (Metric)metricMap.get(metricName));
        return returnMap;
    }

    public static Map<String, Metric> getMetricsAsMap(String registryName) throws NoSuchRegistryException, EmptyRegistryException {
        MetricRegistry registry = Util.getRegistry(registryName);
        Map metricMap = registry.getMetrics();
        if (metricMap.isEmpty()) {
            throw new EmptyRegistryException();
        }
        return metricMap;
    }

    public static Map<String, Metadata> getMetricsMetadataAsMap(String registryName) throws NoSuchRegistryException, EmptyRegistryException {
        MetricRegistry registry = Util.getRegistry(registryName);
        Map metricMetadataMap = registry.getMetadata();
        if (metricMetadataMap.isEmpty()) {
            throw new EmptyRegistryException();
        }
        return metricMetadataMap;
    }

    public static Map<String, Metadata> getMetricsMetadataAsMap(String registryName, String metric) throws NoSuchRegistryException, EmptyRegistryException, NoSuchMetricException {
        MetricRegistry registry = Util.getRegistry(registryName);
        Map metricMetadataMap = registry.getMetadata();
        HashMap<String, Metadata> returnMap = new HashMap<String, Metadata>();
        if (metricMetadataMap.isEmpty()) {
            throw new EmptyRegistryException();
        }
        if (!metricMetadataMap.containsKey(metric)) {
            throw new NoSuchMetricException();
        }
        returnMap.put(metric, (Metadata)metricMetadataMap.get(metric));
        return returnMap;
    }

    private static MetricRegistry getRegistry(String registryName) throws NoSuchRegistryException {
        if (!Constants.REGISTRY_NAMES_LIST.contains(registryName)) {
            throw new NoSuchRegistryException();
        }
        return SHARED_METRIC_REGISTRIES.getOrCreate(registryName);
    }

    public static Map<String, Number> getTimerNumbers(Timer timer, double conversionFactor) {
        HashMap<String, Number> results = new HashMap<String, Number>();
        results.put("count", timer.getCount());
        results.put("meanRate", timer.getMeanRate());
        results.put("oneMinRate", timer.getOneMinuteRate());
        results.put("fiveMinRate", timer.getFiveMinuteRate());
        results.put("fifteenMinRate", timer.getFifteenMinuteRate());
        results.put("max", (double)timer.getSnapshot().getMax() / conversionFactor);
        results.put("mean", timer.getSnapshot().getMean() / conversionFactor);
        results.put("min", (double)timer.getSnapshot().getMin() / conversionFactor);
        results.put("stddev", timer.getSnapshot().getStdDev() / conversionFactor);
        results.put("p50", timer.getSnapshot().getMedian() / conversionFactor);
        results.put("p75", timer.getSnapshot().get75thPercentile() / conversionFactor);
        results.put("p95", timer.getSnapshot().get95thPercentile() / conversionFactor);
        results.put("p98", timer.getSnapshot().get98thPercentile() / conversionFactor);
        results.put("p99", timer.getSnapshot().get99thPercentile() / conversionFactor);
        results.put("p999", timer.getSnapshot().get999thPercentile() / conversionFactor);
        return results;
    }

    public static Map<String, Number> getHistogramNumbers(Histogram histogram) {
        HashMap<String, Number> results = new HashMap<String, Number>();
        results.put("count", histogram.getCount());
        results.put("max", histogram.getSnapshot().getMax());
        results.put("mean", histogram.getSnapshot().getMean());
        results.put("min", histogram.getSnapshot().getMin());
        results.put("stddev", histogram.getSnapshot().getStdDev());
        results.put("p50", histogram.getSnapshot().getMedian());
        results.put("p75", histogram.getSnapshot().get75thPercentile());
        results.put("p95", histogram.getSnapshot().get95thPercentile());
        results.put("p98", histogram.getSnapshot().get98thPercentile());
        results.put("p99", histogram.getSnapshot().get99thPercentile());
        results.put("p999", histogram.getSnapshot().get999thPercentile());
        return results;
    }

    public static Map<String, Number> getMeterNumbers(Meter meter) {
        HashMap<String, Number> results = new HashMap<String, Number>();
        results.put("count", meter.getCount());
        results.put("meanRate", meter.getMeanRate());
        results.put("oneMinRate", meter.getOneMinuteRate());
        results.put("fiveMinRate", meter.getFiveMinuteRate());
        results.put("fifteenMinRate", meter.getFifteenMinuteRate());
        return results;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(Util.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    }
}

