/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.bci;

import com.ibm.ws.ras.instrument.internal.bci.AbstractRasClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.AbstractRasMethodAdapter;
import com.ibm.ws.ras.instrument.internal.bci.AbstractTracingRasClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.LibertyTracingClassAdapter;
import com.ibm.ws.ras.instrument.internal.model.TraceOptionsData;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class LibertyTracingMethodAdapter
extends AbstractRasMethodAdapter<AbstractTracingRasClassAdapter> {
    boolean skipTraces = false;
    boolean modifiedMethod = false;

    public LibertyTracingMethodAdapter(AbstractTracingRasClassAdapter classAdapter, MethodVisitor visitor, int access, String methodName, String descriptor, String signature, String[] exceptions) {
        super(classAdapter, true, visitor, access, methodName, descriptor, signature, exceptions);
    }

    public LibertyTracingMethodAdapter(AbstractTracingRasClassAdapter classAdapter, boolean skipTraces, MethodVisitor visitor, int access, String methodName, String descriptor, String signature, String[] exceptions) {
        this(classAdapter, visitor, access, methodName, descriptor, signature, exceptions);
        this.skipTraces = skipTraces;
    }

    private void setModifiedMethod(boolean modified) {
        this.modifiedMethod = modified;
    }

    public boolean isModifiedMethod() {
        return this.modifiedMethod;
    }

    @Override
    public boolean onMethodEntry() {
        if (this.skipTraces || this.isTrivial() || this.isAlreadyTraced()) {
            return false;
        }
        if (this.isStaticInitializer()) {
            return false;
        }
        Label skipTraceLabel = new Label();
        this.visitInvokeTraceGuardMethod("isEntryEnabled", skipTraceLabel);
        if (this.isStatic() || this.isConstructor() || this.isStaticInitializer()) {
            this.visitGetTraceObjectField();
            this.visitLoadMethodName();
            this.createTraceArrayForParameters();
            this.visitMethodInsn(184, LibertyTracingClassAdapter.TR_TYPE.getInternalName(), "entry", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{LibertyTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class), Type.getType(Object[].class)}), false);
        } else {
            this.visitVarInsn(((AbstractTracingRasClassAdapter)this.getClassAdapter()).getClassType().getOpcode(21), 0);
            this.visitGetTraceObjectField();
            this.visitLoadMethodName();
            this.createTraceArrayForParameters();
            this.visitMethodInsn(184, LibertyTracingClassAdapter.TR_TYPE.getInternalName(), "entry", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class), LibertyTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class), Type.getType(Object[].class)}), false);
        }
        this.visitLabel(skipTraceLabel);
        this.setModifiedMethod(true);
        return true;
    }

    @Override
    public boolean onMethodReturn() {
        if (this.skipTraces || this.isTrivial() || this.isAlreadyTraced()) {
            return false;
        }
        if (this.isStaticInitializer()) {
            return false;
        }
        Label skipTraceLabel = new Label();
        this.visitInvokeTraceGuardMethod("isEntryEnabled", skipTraceLabel);
        boolean traceValueOnStack = this.setupReturnObjectValueForExitTrace();
        if (traceValueOnStack) {
            if (this.isStatic()) {
                this.visitGetTraceObjectField();
                this.visitInsn(95);
                this.visitLoadMethodName();
                this.visitInsn(95);
                this.visitMethodInsn(184, LibertyTracingClassAdapter.TR_TYPE.getInternalName(), "exit", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{LibertyTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class), Type.getType(Object.class)}), false);
            } else {
                this.visitVarInsn(((AbstractTracingRasClassAdapter)this.getClassAdapter()).getClassType().getOpcode(21), 0);
                this.visitInsn(95);
                this.visitGetTraceObjectField();
                this.visitInsn(95);
                this.visitLoadMethodName();
                this.visitInsn(95);
                this.visitMethodInsn(184, LibertyTracingClassAdapter.TR_TYPE.getInternalName(), "exit", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class), LibertyTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class), Type.getType(Object.class)}), false);
            }
        } else if (this.isStatic()) {
            this.visitGetTraceObjectField();
            this.visitLoadMethodName();
            this.visitMethodInsn(184, LibertyTracingClassAdapter.TR_TYPE.getInternalName(), "exit", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{LibertyTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class)}), false);
        } else {
            this.visitVarInsn(((AbstractTracingRasClassAdapter)this.getClassAdapter()).getClassType().getOpcode(21), 0);
            this.visitGetTraceObjectField();
            this.visitLoadMethodName();
            this.visitMethodInsn(184, LibertyTracingClassAdapter.TR_TYPE.getInternalName(), "exit", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class), LibertyTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class)}), false);
        }
        this.visitLabel(skipTraceLabel);
        this.setModifiedMethod(true);
        return true;
    }

    @Override
    public boolean onThrowInstruction() {
        if (this.skipTraces || !((AbstractTracingRasClassAdapter)this.getClassAdapter()).isTraceExceptionOnThrow() || this.isAlreadyTraced()) {
            return false;
        }
        Label skipTraceLabel = new Label();
        this.visitInvokeTraceGuardMethod("isDebugEnabled", skipTraceLabel);
        this.visitInsn(89);
        this.visitGetTraceObjectField();
        this.visitInsn(95);
        this.visitLdcInsn(this.getMethodName() + " is rasing exception");
        this.visitInsn(95);
        this.visitLdcInsn(4);
        this.visitTypeInsn(189, "java/lang/Object");
        this.visitInsn(90);
        this.visitInsn(95);
        this.visitInsn(3);
        this.visitInsn(95);
        this.visitInsn(83);
        this.visitMethodInsn(184, LibertyTracingClassAdapter.TR_TYPE.getInternalName(), "debug", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{LibertyTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class), Type.getType(Object[].class)}), false);
        this.visitLabel(skipTraceLabel);
        this.setModifiedMethod(true);
        return true;
    }

    @Override
    public boolean onExceptionHandlerEntry(Type exception, int var) {
        if (this.skipTraces || !((AbstractTracingRasClassAdapter)this.getClassAdapter()).isTraceExceptionOnHandling() || this.isAlreadyTraced()) {
            return false;
        }
        Label skipTraceLabel = new Label();
        this.visitInvokeTraceGuardMethod("isDebugEnabled", skipTraceLabel);
        if (var == -1) {
            this.visitInsn(89);
        } else {
            this.visitVarInsn(25, var);
        }
        this.visitGetTraceObjectField();
        this.visitInsn(95);
        this.visitLdcInsn(this.getMethodName() + " is handling exception");
        this.visitInsn(95);
        this.visitMethodInsn(184, LibertyTracingClassAdapter.TR_TYPE.getInternalName(), "debug", "(Lcom/ibm/websphere/ras/TraceComponent;Ljava/lang/String;Ljava/lang/Object;)V", false);
        this.visitLabel(skipTraceLabel);
        this.setModifiedMethod(true);
        return true;
    }

    @Override
    public void initializeTraceObjectField() {
        if (!((AbstractTracingRasClassAdapter)this.getClassAdapter()).isTraceObjectFieldInitializationRequired() || this.isAlreadyTraced()) {
            return;
        }
        ((AbstractTracingRasClassAdapter)this.getClassAdapter()).visitAnnotation(AbstractRasClassAdapter.TRACE_OPTIONS_TYPE.getDescriptor(), true);
        TraceOptionsData traceOptionsData = ((AbstractTracingRasClassAdapter)this.getClassAdapter()).getTraceOptionsData();
        if (traceOptionsData.getTraceGroups().size() > 1) {
            this.visitGetClassForType(Type.getObjectType((String)((AbstractTracingRasClassAdapter)this.getClassAdapter()).getClassInternalName()));
            String[] traceGroups = traceOptionsData.getTraceGroups().toArray(new String[traceOptionsData.getTraceGroups().size()]);
            this.visitInsn(3 + traceGroups.length);
            this.visitTypeInsn(189, "java/lang/String");
            for (int i = 0; i < traceGroups.length; ++i) {
                this.visitInsn(89);
                this.visitInsn(3 + i);
                this.visitLdcInsn(traceGroups[i]);
                this.visitInsn(83);
            }
            String messageBundle = traceOptionsData.getMessageBundle();
            if (messageBundle != null) {
                this.visitLdcInsn(messageBundle);
            } else {
                this.visitInsn(1);
            }
            String traceOptionName = ((AbstractTracingRasClassAdapter)this.getClassAdapter()).getClassName();
            if (traceOptionName != null) {
                this.visitLdcInsn(traceOptionName);
            } else {
                this.visitInsn(1);
            }
            this.visitMethodInsn(184, LibertyTracingClassAdapter.TR_TYPE.getInternalName(), "register", Type.getMethodDescriptor((Type)LibertyTracingClassAdapter.TRACE_COMPONENT_TYPE, (Type[])new Type[]{Type.getType(Class.class), Type.getType((String)"[Ljava/lang/String;"), Type.getType(String.class), Type.getType(String.class)}), false);
        } else {
            String traceGroupName;
            this.visitGetClassForType(Type.getObjectType((String)((AbstractTracingRasClassAdapter)this.getClassAdapter()).getClassInternalName()));
            List<String> traceGroups = traceOptionsData.getTraceGroups();
            String string = traceGroupName = traceGroups.isEmpty() ? null : traceGroups.get(0);
            if (traceGroupName != null) {
                this.visitLdcInsn(traceGroupName);
            } else {
                this.visitInsn(1);
            }
            String messageBundle = traceOptionsData.getMessageBundle();
            if (messageBundle != null) {
                this.visitLdcInsn(messageBundle);
            } else {
                this.visitInsn(1);
            }
            this.visitMethodInsn(184, LibertyTracingClassAdapter.TR_TYPE.getInternalName(), "register", Type.getMethodDescriptor((Type)LibertyTracingClassAdapter.TRACE_COMPONENT_TYPE, (Type[])new Type[]{Type.getType(Class.class), Type.getType(String.class), Type.getType(String.class)}), false);
        }
        this.visitSetTraceObjectField();
        this.setModifiedMethod(true);
    }

    private void visitInvokeTraceGuardMethod(String guardMethodName, Label skipTraceLabel) {
        this.visitMethodInsn(184, LibertyTracingClassAdapter.TRACE_COMPONENT_TYPE.getInternalName(), "isAnyTracingEnabled", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]), false);
        this.visitJumpInsn(153, skipTraceLabel);
        this.visitGetTraceObjectField();
        this.visitJumpInsn(198, skipTraceLabel);
        this.visitGetTraceObjectField();
        this.visitMethodInsn(182, LibertyTracingClassAdapter.TRACE_COMPONENT_TYPE.getInternalName(), guardMethodName, Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]), false);
        this.visitJumpInsn(153, skipTraceLabel);
    }

    @Override
    protected void boxSensitive(Type type) {
        if (type.getSort() == 9 || type.getSort() == 10) {
            this.visitMethodInsn(184, "com/ibm/websphere/ras/DataFormatHelper", "sensitiveToString", "(Ljava/lang/Object;)Ljava/lang/String;", false);
        } else {
            super.boxSensitive(type);
        }
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (name.equals("register") && desc.equals("(Ljava/lang/Class;)Lcom/ibm/websphere/ras/TraceComponent;")) {
            ((AbstractTracingRasClassAdapter)this.getClassAdapter()).visitAnnotation(AbstractRasClassAdapter.TRACE_OPTIONS_TYPE.getDescriptor(), true);
            TraceOptionsData traceOptionsData = ((AbstractTracingRasClassAdapter)this.getClassAdapter()).getTraceOptionsData();
            if (traceOptionsData.getTraceGroups().size() > 1) {
                String[] traceGroups = traceOptionsData.getTraceGroups().toArray(new String[traceOptionsData.getTraceGroups().size()]);
                this.visitInsn(3 + traceGroups.length);
                this.visitTypeInsn(189, "java/lang/String");
                for (int i = 0; i < traceGroups.length; ++i) {
                    this.visitInsn(89);
                    this.visitInsn(3 + i);
                    this.visitLdcInsn(traceGroups[i]);
                    this.visitInsn(83);
                }
                String messageBundle = traceOptionsData.getMessageBundle();
                if (messageBundle != null) {
                    this.visitLdcInsn(messageBundle);
                } else {
                    this.visitInsn(1);
                }
                String traceOptionName = ((AbstractTracingRasClassAdapter)this.getClassAdapter()).getClassName();
                if (traceOptionName != null) {
                    this.visitLdcInsn(traceOptionName);
                } else {
                    this.visitInsn(1);
                }
                this.visitMethodInsn(184, LibertyTracingClassAdapter.TR_TYPE.getInternalName(), "register", Type.getMethodDescriptor((Type)LibertyTracingClassAdapter.TRACE_COMPONENT_TYPE, (Type[])new Type[]{Type.getType(Class.class), Type.getType((String)"[Ljava/lang/String;"), Type.getType(String.class), Type.getType(String.class)}), false);
            } else {
                String traceGroupName;
                List<String> traceGroups = traceOptionsData.getTraceGroups();
                String string = traceGroupName = traceGroups.isEmpty() ? null : traceGroups.get(0);
                if (traceGroupName != null) {
                    this.visitLdcInsn(traceGroupName);
                } else {
                    this.visitInsn(1);
                }
                String messageBundle = traceOptionsData.getMessageBundle();
                if (messageBundle != null) {
                    this.visitLdcInsn(messageBundle);
                } else {
                    this.visitInsn(1);
                }
                this.visitMethodInsn(184, LibertyTracingClassAdapter.TR_TYPE.getInternalName(), "register", Type.getMethodDescriptor((Type)LibertyTracingClassAdapter.TRACE_COMPONENT_TYPE, (Type[])new Type[]{Type.getType(Class.class), Type.getType(String.class), Type.getType(String.class)}), false);
            }
            this.setModifiedMethod(true);
        } else {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }
}

