/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.parsers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.parsers.Parser;
import com.ibm.ws.repository.parsers.ParserBase;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveException;
import com.ibm.ws.repository.resources.writeable.ConfigSnippetResourceWritable;
import com.ibm.ws.repository.resources.writeable.RepositoryResourceWritable;
import com.ibm.ws.repository.resources.writeable.WritableResourceFactory;
import java.io.File;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConfigSnippetsParser
extends ParserBase
implements Parser<ConfigSnippetResourceWritable> {
    static final long serialVersionUID = 8223993107028582751L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public ConfigSnippetResourceWritable parseFileToResource(File assetFile, File metadataFile, String contentUrl) throws RepositoryException {
        ParserBase.ArtifactMetadata artifactMetadata = this.explodeArtifact(assetFile, metadataFile);
        if (artifactMetadata == null) {
            throw new RepositoryArchiveException("Unable to find sibling metadata zip for " + assetFile.getName() + " so do not have the required information", assetFile);
        }
        ConfigSnippetResourceWritable resource = WritableResourceFactory.createConfigSnippet(null);
        this.setCommonFieldsFromSideZip(artifactMetadata, (RepositoryResourceWritable)resource);
        this.checkPropertySet("applies.to.editions", artifactMetadata);
        this.checkPropertySet("applies.to.minimum.version", artifactMetadata);
        this.checkPropertySet("provider", artifactMetadata);
        this.checkPropertySet("requires.feature", artifactMetadata);
        resource.setAppliesTo(this.getAppliesTo(artifactMetadata));
        resource.setRequireFeature(this.getRequiresFeature(artifactMetadata));
        resource.setProviderName(this.getProviderName(artifactMetadata));
        this.addContent((RepositoryResourceWritable)resource, assetFile, assetFile.getName(), artifactMetadata, contentUrl);
        return resource;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ConfigSnippetsParser.class, null, null);
    }
}

