/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.parsers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.parsers.Parser;
import com.ibm.ws.repository.parsers.ParserBase;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveException;
import com.ibm.ws.repository.resources.writeable.ApplicableToProductWritable;
import com.ibm.ws.repository.resources.writeable.ProductRelatedResourceWritable;
import com.ibm.ws.repository.resources.writeable.RepositoryResourceWritable;
import com.ibm.ws.repository.resources.writeable.WritableResourceFactory;
import java.io.File;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class GenericParser
extends ParserBase
implements Parser<RepositoryResourceWritable> {
    public static String ASSET_TYPE_PROPERTY_KEY;
    public static String APPLIES_TO_PROPERTY_KEY;
    static final long serialVersionUID = -671625940187992059L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public RepositoryResourceWritable parseFileToResource(File assetFile, File metadataFile, String contentUrl) throws RepositoryException {
        String appliesTo;
        File artifactFile = null;
        ParserBase.ArtifactMetadata metadata = null;
        if (assetFile.getName().endsWith("metadata.zip")) {
            metadata = this.explodeZip(assetFile);
        } else {
            metadata = this.explodeArtifact(assetFile, metadataFile);
            artifactFile = assetFile;
        }
        if (metadata == null) {
            throw new RepositoryArchiveException("Unable to find sibling metadata zip for " + assetFile.getName() + " so do not have the required information", assetFile);
        }
        this.checkPropertySet(ASSET_TYPE_PROPERTY_KEY, metadata);
        ResourceType type = ResourceType.valueOf((String)metadata.getProperty(ASSET_TYPE_PROPERTY_KEY));
        RepositoryResourceWritable resource = WritableResourceFactory.createResource(null, (ResourceType)type);
        this.setCommonFieldsFromSideZip(metadata, resource);
        resource.setProviderName("IBM");
        resource.setProviderUrl("http://www.ibm.com");
        this.attachLicenseData(metadata, resource);
        if (resource instanceof ProductRelatedResourceWritable) {
            GenericParser.setProductDetails((ProductRelatedResourceWritable)resource, metadata);
        }
        if ((appliesTo = metadata.getProperty(APPLIES_TO_PROPERTY_KEY)) != null && resource instanceof ApplicableToProductWritable) {
            ((ApplicableToProductWritable)resource).setAppliesTo(appliesTo);
        }
        this.addContent(resource, artifactFile, assetFile.getName(), metadata, contentUrl);
        this.processIcons(metadata, resource);
        return resource;
    }

    private static void setProductDetails(ProductRelatedResourceWritable resource, ParserBase.ArtifactMetadata metadata) throws RepositoryException {
        String version = metadata.getProperty("productVersion");
        String id = metadata.getProperty("productId");
        String editionString = metadata.getProperty("productEdition");
        if (id == null && version == null && editionString == null) {
            return;
        }
        if (id == null || version == null || editionString == null) {
            throw new RepositoryException("If one of id, version and edition are set in the metadata, then all 3 must be setid was: " + id + ", version was: " + version + ", edition was: " + editionString);
        }
        String upperCaseEditionString = editionString.toUpperCase();
        try {
            ParserBase.Edition.valueOf(upperCaseEditionString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.repository.parsers.GenericParser", (String)"91", null, (Object[])new Object[]{resource, metadata});
            throw new RepositoryException("The edition specified in the metadata (" + editionString + ")was not known");
        }
        resource.setProductId(id);
        resource.setProductVersion(version);
        resource.setProductEdition(upperCaseEditionString);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(GenericParser.class, null, null);
        ASSET_TYPE_PROPERTY_KEY = "assetType";
        APPLIES_TO_PROPERTY_KEY = "appliesTo";
    }
}

