/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.parsers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.parsers.ParserBase;
import com.ibm.ws.repository.parsers.ProductRelatedParser;
import com.ibm.ws.repository.resources.writeable.ProductRelatedResourceWritable;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class ProductRelatedJarParser<T extends ProductRelatedResourceWritable>
extends ProductRelatedParser<T> {
    static final long serialVersionUID = -7502820570461169784L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public abstract ResourceType getType(String var1, File var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ProductRelatedParser.AssetInformation extractInformationFromAsset(final File archive, ParserBase.ArtifactMetadata metadata) throws PrivilegedActionException, ProductInfoParseException, IOException {
        ProductRelatedParser.AssetInformation assetInformation = new ProductRelatedParser.AssetInformation();
        try (ZipFile jarFile = null;){
            ResourceType type;
            jarFile = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){
                static final long serialVersionUID = 5634058927948707352L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JarFile run() throws IOException {
                    return new JarFile(archive);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, null, null);
                }
            });
            Manifest manifest = ((JarFile)jarFile).getManifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            String archiveRoot = mainAttributes.getValue("Archive-Root");
            archiveRoot = archiveRoot != null ? archiveRoot : "";
            assetInformation.addProductInfos(jarFile, archiveRoot, archive);
            String contentType = mainAttributes.getValue("Archive-Content-Type");
            assetInformation.type = type = this.getType(contentType, archive);
            assetInformation.provideFeature = mainAttributes.getValue("Provide-Feature");
            if (type.equals((Object)ResourceType.ADDON)) {
                assetInformation.requireFeature = mainAttributes.getValue("Require-Feature");
                assetInformation.appliesTo = mainAttributes.getValue("Applies-To");
            }
            assetInformation.laLocation = mainAttributes.getValue("License-Agreement");
            assetInformation.liLocation = mainAttributes.getValue("License-Information");
            assetInformation.fileWithLicensesIn = archive;
        }
        return assetInformation;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ProductRelatedJarParser.class, null, null);
    }
}

