/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.event.internal.TopicData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.staticvalue.StaticValue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class Topic {
    private static final Pattern topicPattern;
    final String name;
    final StaticValue<AtomicReference<AtomicReference<TopicData>>> topicDataReference = StaticValue.createStaticValue((Callable)new Callable<AtomicReference<AtomicReference<TopicData>>>(){
        static final long serialVersionUID = -1782443240738230951L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public AtomicReference<AtomicReference<TopicData>> call() throws Exception {
            return new AtomicReference<AtomicReference<TopicData>>(new AtomicReference());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class, (String)"EventEngine", null);
        }
    });
    static final long serialVersionUID = 4478873415341955185L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Topic(String name) {
        this.validateTopic(name);
        this.name = name;
    }

    void validateTopic(String name) {
        if (name == null) {
            throw new NullPointerException("Topic name must not be null");
        }
        if (!topicPattern.matcher(name).matches()) {
            throw new IllegalArgumentException("\"" + name + "\" is not a valid topic name");
        }
    }

    public String getName() {
        return this.name;
    }

    public TopicData getTopicData() {
        return (TopicData)((AtomicReference)((AtomicReference)this.topicDataReference.get()).get()).get();
    }

    public void setTopicDataReference(AtomicReference<TopicData> topicDataReference) {
        ((AtomicReference)this.topicDataReference.get()).set(topicDataReference);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Topic) {
            Topic that = (Topic)o;
            return this.name.equals(that.name);
        }
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(Topic.class, (String)"EventEngine", null);
        topicPattern = Pattern.compile("[\\w\\-]+(/[\\w\\-]+)*");
    }
}

