/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.event.internal;

import com.ibm.websphere.event.Event;
import com.ibm.websphere.event.EventEngine;
import com.ibm.websphere.event.ScheduledEventService;
import com.ibm.websphere.event.Topic;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.event.internal.CurrentEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ScheduledEventServiceImpl
implements ScheduledEventService {
    private ScheduledExecutorService execSvc = null;
    private EventEngine eventSvc = null;
    static final long serialVersionUID = -1031676940963440257L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public ScheduledFuture<?> schedule(Topic topic, long delay, TimeUnit unit) {
        return this.schedule(topic, null, delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Topic topic, Map<?, ?> context, long delay, TimeUnit unit) {
        EventEngine engine = this.eventSvc;
        ScheduledExecutorService scheduler = this.execSvc;
        if (null == scheduler || null == engine) {
            throw new IllegalStateException("Service is not running");
        }
        if (null == topic) {
            throw new IllegalArgumentException("Missing topic");
        }
        Task task = new Task(topic, context, engine, CurrentEvent.get());
        return scheduler.schedule(task, delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Topic topic, long initialDelay, long period, TimeUnit unit) {
        return this.schedule(topic, null, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Topic topic, Map<?, ?> context, long initialDelay, long period, TimeUnit unit) {
        EventEngine engine = this.eventSvc;
        ScheduledExecutorService scheduler = this.execSvc;
        if (null == scheduler || null == engine) {
            throw new IllegalStateException("Service is not running");
        }
        if (null == topic) {
            throw new IllegalArgumentException("Missing topic");
        }
        Task task = new Task(topic, context, engine, CurrentEvent.get());
        return scheduler.scheduleAtFixedRate(task, initialDelay, period, unit);
    }

    @Reference
    protected void setScheduledExecutor(ScheduledExecutorService ref) {
        this.execSvc = ref;
    }

    protected void unsetScheduledExecutor(ScheduledExecutorService ref) {
        if (ref == this.execSvc) {
            this.execSvc = null;
        }
    }

    @Reference
    protected void setEventEngine(EventEngine ref) {
        this.eventSvc = ref;
    }

    protected void unsetEventEngine(EventEngine ref) {
        if (ref == this.eventSvc) {
            this.eventSvc = null;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ScheduledEventServiceImpl.class, (String)"EventEngine", null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class Task
    implements Runnable {
        private Topic myTopic = null;
        private Map<?, ?> myContext = null;
        private EventEngine myEngine = null;
        private final Event myParent;
        static final long serialVersionUID = 8197925033939165907L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected Task(Topic topic, Map<?, ?> context, EventEngine engine, Event parent) {
            this.myTopic = topic;
            this.myContext = context;
            this.myEngine = engine;
            this.myParent = parent;
        }

        @Override
        public void run() {
            try {
                this.myEngine.postEvent(this.myTopic, this.myContext, this.myParent);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.event.internal.ScheduledEventServiceImpl$Task", (String)"176", (Object)this, (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Task.class, (String)"EventEngine", null);
        }
    }
}

