/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.classloader;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class ClassLoaderUtils {
    private static final boolean SKIP_SM;
    static final long serialVersionUID = -1332516244223100159L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private ClassLoaderUtils() {
    }

    public static ClassLoaderHolder setThreadContextClassloader(final ClassLoader newLoader) {
        if (SKIP_SM) {
            Thread thread = Thread.currentThread();
            ClassLoader l = thread.getContextClassLoader();
            thread.setContextClassLoader(newLoader);
            return new ClassLoaderHolder(l, thread);
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoaderHolder>(){
            static final long serialVersionUID = 1131708953744529474L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoaderHolder run() {
                Thread thread = Thread.currentThread();
                ClassLoader l = thread.getContextClassLoader();
                thread.setContextClassLoader(newLoader);
                return new ClassLoaderHolder(l, thread);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, null, null);
            }
        });
    }

    public static ClassLoader getURLClassLoader(final URL[] urls, final ClassLoader parent) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = -3879061468120054581L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return new URLClassLoader(urls, parent);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class, null, null);
            }
        });
    }

    public static ClassLoader getURLClassLoader(List<URL> urlList, ClassLoader parent) {
        return ClassLoaderUtils.getURLClassLoader(urlList.toArray(new URL[0]), parent);
    }

    public static URL getResource(String resourceName, Class<?> callingClass) {
        ClassLoader cl;
        ClassLoader cluClassloader;
        URL url = ClassLoaderUtils.getContextClassLoader().getResource(resourceName);
        if (url == null && resourceName.startsWith("/")) {
            url = ClassLoaderUtils.getContextClassLoader().getResource(resourceName.substring(1));
        }
        if ((cluClassloader = ClassLoaderUtils.class.getClassLoader()) == null) {
            cluClassloader = ClassLoader.getSystemClassLoader();
        }
        if (url == null) {
            url = cluClassloader.getResource(resourceName);
        }
        if (url == null && resourceName.startsWith("/")) {
            url = cluClassloader.getResource(resourceName.substring(1));
        }
        if (url == null && callingClass != null && (cl = callingClass.getClassLoader()) != null) {
            url = cl.getResource(resourceName);
        }
        if (url == null && callingClass != null) {
            url = callingClass.getResource(resourceName);
        }
        if (url == null && resourceName != null && resourceName.charAt(0) != '/') {
            return ClassLoaderUtils.getResource('/' + resourceName, callingClass);
        }
        return url;
    }

    @FFDCIgnore(value={IOException.class, IOException.class, IOException.class, IOException.class, IOException.class})
    public static List<URL> getResources(String resourceName, Class<?> callingClass) {
        URL url;
        ClassLoader cl;
        ClassLoader cluClassloader;
        ArrayList<URL> ret = new ArrayList<URL>();
        Enumeration<URL> urls = new Enumeration<URL>(){
            static final long serialVersionUID = 2137033995758748153L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public URL nextElement() {
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class, null, null);
            }
        };
        try {
            urls = ClassLoaderUtils.getContextClassLoader().getResources(resourceName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!urls.hasMoreElements() && resourceName.startsWith("/")) {
            try {
                urls = ClassLoaderUtils.getContextClassLoader().getResources(resourceName.substring(1));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((cluClassloader = ClassLoaderUtils.class.getClassLoader()) == null) {
            cluClassloader = ClassLoader.getSystemClassLoader();
        }
        if (!urls.hasMoreElements()) {
            try {
                urls = cluClassloader.getResources(resourceName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!urls.hasMoreElements() && resourceName.startsWith("/")) {
            try {
                urls = cluClassloader.getResources(resourceName.substring(1));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!urls.hasMoreElements() && (cl = callingClass.getClassLoader()) != null) {
            try {
                urls = cl.getResources(resourceName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!urls.hasMoreElements() && (url = callingClass.getResource(resourceName)) != null) {
            ret.add(url);
        }
        while (urls.hasMoreElements()) {
            ret.add(urls.nextElement());
        }
        if (ret.isEmpty() && resourceName != null && resourceName.charAt(0) != '/') {
            return ClassLoaderUtils.getResources('/' + resourceName, callingClass);
        }
        return ret;
    }

    @FFDCIgnore(value={IOException.class})
    public static InputStream getResourceAsStream(String resourceName, Class<?> callingClass) {
        URL url = ClassLoaderUtils.getResource(resourceName, callingClass);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    public static Class<?> loadClass(String className, Class<?> callingClass) throws ClassNotFoundException {
        try {
            ClassLoader cl = ClassLoaderUtils.getContextClassLoader();
            if (cl != null) {
                return cl.loadClass(className);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return ClassLoaderUtils.loadClass2(className, callingClass);
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    public static <T> Class<? extends T> loadClass(String className, Class<?> callingClass, Class<T> type) throws ClassNotFoundException {
        try {
            ClassLoader cl = ClassLoaderUtils.getContextClassLoader();
            if (cl != null) {
                return cl.loadClass(className).asSubclass(type);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return ClassLoaderUtils.loadClass2(className, callingClass).asSubclass(type);
    }

    public static String getClassLoaderName(Class<?> type) {
        ClassLoader loader = ClassLoaderUtils.getClassLoader(type);
        return loader == null ? "null" : loader.toString();
    }

    public static Class<?> loadClassFromContextLoader(String className) throws ClassNotFoundException {
        return ClassLoaderUtils.getContextClassLoader().loadClass(className);
    }

    @FFDCIgnore(value={ClassNotFoundException.class, ClassNotFoundException.class})
    private static Class<?> loadClass2(String className, Class<?> callingClass) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            block5: {
                try {
                    ClassLoader loader = ClassLoaderUtils.getClassLoader(ClassLoaderUtils.class);
                    if (loader != null) {
                        return loader.loadClass(className);
                    }
                }
                catch (ClassNotFoundException exc) {
                    ClassLoader callingClassLoader;
                    if (callingClass == null || (callingClassLoader = ClassLoaderUtils.getClassLoader(callingClass)) == null) break block5;
                    return callingClassLoader.loadClass(className);
                }
            }
            throw ex;
        }
    }

    static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                static final long serialVersionUID = -2374302211680330524L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ClassLoader run() {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    return loader != null ? loader : ClassLoader.getSystemClassLoader();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(4.class, null, null);
                }
            });
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader != null ? loader : ClassLoader.getSystemClassLoader();
    }

    private static ClassLoader getClassLoader(final Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                static final long serialVersionUID = 775916858466402270L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ClassLoader run() {
                    return clazz.getClassLoader();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(5.class, null, null);
                }
            });
        }
        return clazz.getClassLoader();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ClassLoaderUtils.class, null, null);
        SKIP_SM = System.getSecurityManager() == null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ClassLoaderHolder {
        ClassLoader loader;
        Thread thread;
        static final long serialVersionUID = 7297029662737996028L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ClassLoaderHolder(ClassLoader c, Thread thread) {
            this.loader = c;
            this.thread = thread;
        }

        public void reset() {
            if (SKIP_SM) {
                this.thread.setContextClassLoader(this.loader);
            } else {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){
                    static final long serialVersionUID = 8414545087853459103L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Void run() {
                        thread.setContextClassLoader(loader);
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class, null, null);
                    }
                });
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ClassLoaderHolder.class, null, null);
        }
    }
}

