/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.RLSController;
import com.ibm.ws.recoverylog.spi.RLSInvalidSuspendTokenException;
import com.ibm.ws.recoverylog.spi.RLSSuspendToken;
import com.ibm.ws.recoverylog.spi.RLSSuspendTokenManager;
import com.ibm.ws.recoverylog.spi.RLSTimeoutRangeException;
import com.ibm.ws.recoverylog.spi.RLSUtils;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RLSControllerImpl
implements RLSController {
    private static final com.ibm.tx.util.logging.TraceComponent tc;
    static Object SUSPEND_LOCK;
    private static RLSSuspendTokenManager _tokenManager;
    private static boolean _isSuspended;
    static final long serialVersionUID = 7605675306773699983L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    RLSControllerImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"RLSControllerImpl");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"RLSControllerImpl", (Object)this);
        }
    }

    @Override
    public void resume(RLSSuspendToken token) throws RLSInvalidSuspendTokenException {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"resume", (Object)token);
        }
        if (Configuration.isZOS()) {
            if (tc.isEventEnabled()) {
                Tr.event((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Operation not supported on ZOS - throwing UnsupportedOperationException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"resume", (Object)"java.lang.UnsupportedOperationException");
            }
            throw new UnsupportedOperationException();
        }
        RLSControllerImpl.resumeRLS(token);
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"resume");
        }
    }

    @Override
    public void resume(byte[] tokenBytes) throws RLSInvalidSuspendTokenException {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"resume", (Object)RLSUtils.toHexString(tokenBytes));
        }
        if (Configuration.isZOS()) {
            if (tc.isEventEnabled()) {
                Tr.event((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Operation not supported on ZOS - throwing UnsupportedOperationException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"resume", (Object)"java.lang.UnsupportedOperationException");
            }
            throw new UnsupportedOperationException();
        }
        RLSSuspendToken token = Configuration.getRecoveryLogComponent().createRLSSuspendToken(tokenBytes);
        RLSControllerImpl.resumeRLS(token);
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"resume");
        }
    }

    @Override
    public RLSSuspendToken suspend(int timeout) throws RLSTimeoutRangeException {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"suspend", (Object)new Integer(timeout));
        }
        if (Configuration.isZOS()) {
            if (tc.isEventEnabled()) {
                Tr.event((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Operation not supported on ZOS - throwing UnsupportedOperationException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"resume", (Object)"java.lang.UnsupportedOperationException");
            }
            throw new UnsupportedOperationException();
        }
        RLSSuspendToken token = RLSControllerImpl.suspendRLS(timeout);
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"suspend");
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RLSSuspendToken suspendRLS(int timeout) throws RLSTimeoutRangeException {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"suspendRLS", (Object)new Integer(timeout));
        }
        if (timeout < 0 || timeout > 1000000000) {
            if (tc.isEventEnabled()) {
                Tr.event((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Timeout value is out of range - throwing RLSTimeoutRangeException", (Object)new Integer(timeout));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"suspend", (Object)"RLSTimeoutRangeException");
            }
            throw new RLSTimeoutRangeException();
        }
        RLSSuspendToken token = null;
        Object object = SUSPEND_LOCK;
        synchronized (object) {
            if (!Configuration._isSnapshotSafe) {
                Tr.warning((com.ibm.tx.util.logging.TraceComponent)tc, (String)"CWRLS0020_SNAPSHOT_SAFE");
            }
            token = _tokenManager.registerSuspend(timeout);
            Tr.info((com.ibm.tx.util.logging.TraceComponent)tc, (String)"CWRLS0001_SUSPEND_RLS", (Object)token);
            _isSuspended = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"suspendRLS", (Object)token);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void resumeRLS(RLSSuspendToken token) throws RLSInvalidSuspendTokenException {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"resumeRLS", (Object)token);
        }
        Object object = SUSPEND_LOCK;
        synchronized (object) {
            try {
                _tokenManager.registerResume(token);
            }
            catch (RLSInvalidSuspendTokenException rLSInvalidSuspendTokenException) {
                void exc;
                com.ibm.ws.ffdc.FFDCFilter.processException((Throwable)rLSInvalidSuspendTokenException, (String)"com.ibm.ws.recoverylog.spi.RLSControllerImpl", (String)"199", null, (Object[])new Object[]{token});
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogService.resume", (String)"120");
                if (tc.isEventEnabled()) {
                    Tr.event((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Rethrow RLSInvalidSuspendTokenException - attempt to resume an invalid token", (Object)token);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"resumeRLS", (Object)exc);
                }
                throw exc;
            }
            if (_tokenManager.isResumable()) {
                if (tc.isEventEnabled()) {
                    Tr.event((com.ibm.tx.util.logging.TraceComponent)tc, (String)"There are no outstanding suspends - resuming recovery log service");
                }
                Tr.info((com.ibm.tx.util.logging.TraceComponent)tc, (String)"CWRLS0002_RESUME_RLS", (Object)token);
                _isSuspended = false;
                SUSPEND_LOCK.notifyAll();
            } else {
                Tr.info((com.ibm.tx.util.logging.TraceComponent)tc, (String)"CWRLS0021_RESUME_ATTEMPT_RLS", (Object)token);
                if (tc.isEventEnabled()) {
                    Tr.event((com.ibm.tx.util.logging.TraceComponent)tc, (String)"There are still outstanding suspensions - recovery log service remains suspended");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"resumeRLS");
        }
    }

    static boolean isSuspended() {
        return _isSuspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"notifyTimeout");
        }
        Object object = SUSPEND_LOCK;
        synchronized (object) {
            if (_tokenManager.isResumable()) {
                if (tc.isEventEnabled()) {
                    Tr.event((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Resuming recovery log service following a suspension timeout");
                }
                _isSuspended = false;
                Tr.info((com.ibm.tx.util.logging.TraceComponent)tc, (String)"CWRLS0023_RESUME_RLS");
                SUSPEND_LOCK.notifyAll();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"notifyTimeout");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(RLSControllerImpl.class, null, null);
        tc = Tr.register(RLSControllerImpl.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
        SUSPEND_LOCK = new Object();
        _tokenManager = RLSSuspendTokenManager.getInstance();
    }
}

