/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.alarm.Alarm;
import com.ibm.tx.util.alarm.AlarmListener;
import com.ibm.tx.util.logging.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.RLSControllerImpl;
import com.ibm.ws.recoverylog.spi.RLSInvalidSuspendTokenException;
import com.ibm.ws.recoverylog.spi.RLSSuspendToken;
import java.util.HashMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class RLSSuspendTokenManager
implements AlarmListener {
    private static final com.ibm.tx.util.logging.TraceComponent tc;
    private static RLSSuspendTokenManager _instance;
    private HashMap _tokenMap;
    static final long serialVersionUID = 8813401346655209311L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private RLSSuspendTokenManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"RLSSuspendTokenManager");
        }
        this._tokenMap = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"RLSSuspendTokenManager", (Object)this);
        }
    }

    static RLSSuspendTokenManager getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getInstance");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getInstance", (Object)_instance);
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RLSSuspendToken registerSuspend(int timeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"registerSuspend", (Object)new Integer(timeout));
        }
        RLSSuspendToken token = Configuration.getRecoveryLogComponent().createRLSSuspendToken(null);
        Alarm alarm = null;
        if (timeout > 0) {
            alarm = Configuration.getAlarmManager().scheduleAlarm((long)timeout * 1000L, (AlarmListener)this, (Object)token);
            if (tc.isEventEnabled()) {
                Tr.event((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Alarm has been created for this suspend call", (Object)alarm);
            }
        }
        HashMap hashMap = this._tokenMap;
        synchronized (hashMap) {
            this._tokenMap.put(token, alarm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"registerSuspend", (Object)token);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"alarm", (Object)object);
        }
        HashMap hashMap = this._tokenMap;
        synchronized (hashMap) {
            if (this._tokenMap.containsKey(object)) {
                this._tokenMap.remove(object);
                Tr.info((com.ibm.tx.util.logging.TraceComponent)tc, (String)"CWRLS0022_RLS_SUSPEND_TIMEOUT", (Object)object);
            }
        }
        RLSControllerImpl.notifyTimeout();
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"alarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerResume(RLSSuspendToken token) throws RLSInvalidSuspendTokenException {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"registerResume", (Object)token);
        }
        if (token != null && this._tokenMap.containsKey(token)) {
            HashMap hashMap = this._tokenMap;
            synchronized (hashMap) {
                Alarm alarm = (Alarm)this._tokenMap.remove(token);
                if (alarm != null) {
                    alarm.cancel();
                }
            }
        } else {
            if (tc.isEventEnabled()) {
                Tr.event((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Throw RLSInvalidSuspendTokenException - suspend token is not recognised");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"registerResume", (Object)"RLSInvalidSuspendTokenException");
            }
            throw new RLSInvalidSuspendTokenException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"registerResume");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isResumable() {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"isResumable");
        }
        boolean isResumable = true;
        HashMap hashMap = this._tokenMap;
        synchronized (hashMap) {
            if (!this._tokenMap.isEmpty()) {
                isResumable = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"isResumable", (Object)new Boolean(isResumable));
        }
        return isResumable;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(RLSSuspendTokenManager.class, null, null);
        tc = Tr.register(RLSSuspendTokenManager.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
        _instance = new RLSSuspendTokenManager();
    }
}

