/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.ejb;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.javaee.dd.ejb.EnterpriseBean;
import com.ibm.ws.javaee.dd.ejb.Session;
import com.ibm.ws.javaee.dd.ejb.StatefulTimeout;
import java.lang.reflect.Method;
import javax.ejb.Asynchronous;

final class AppConfigChecker {
    private AppConfigChecker() {
    }

    static void validateAsyncOnInterfaces(Class<?>[] ifaces, TraceComponent tc) {
        if (ifaces != null) {
            block0: for (Class<?> iface : ifaces) {
                if (!iface.isInterface()) continue;
                if (iface.getAnnotation(Asynchronous.class) != null) {
                    Tr.warning((TraceComponent)tc, (String)"ASYNC_ON_INTERFACE_CNTR0305W", (Object[])new Object[]{iface.getName()});
                    continue;
                }
                for (Method m : iface.getMethods()) {
                    if (m.getAnnotation(Asynchronous.class) == null) continue;
                    Tr.warning((TraceComponent)tc, (String)"ASYNC_ON_INTERFACE_CNTR0305W", (Object[])new Object[]{iface.getName()});
                    continue block0;
                }
            }
        }
    }

    static void validateStatefulTimeoutOnInterfaces(Class<?>[] ifaces, TraceComponent tc) {
        if (ifaces != null) {
            for (Class<?> iface : ifaces) {
                if (!iface.isInterface() || iface.getAnnotation(javax.ejb.StatefulTimeout.class) == null) continue;
                Tr.warning((TraceComponent)tc, (String)"STATEFUL_TIMEOUT_ON_INTERFACE_CNTR0306W", (Object[])new Object[]{iface.getName()});
            }
        }
    }

    static void validateStatefulTimeoutOnSFSB(BeanMetaData bmd, TraceComponent tc) {
        Session session;
        StatefulTimeout statefulTimeoutXML;
        EnterpriseBean eb;
        javax.ejb.StatefulTimeout statefulTimeout = bmd.enterpriseBeanClass.getAnnotation(javax.ejb.StatefulTimeout.class);
        if (statefulTimeout != null && bmd.type != 4) {
            Tr.warning((TraceComponent)tc, (String)"STATEFUL_TIMEOUT_ON_NON_SFSB_CNTR0304W", (Object[])new Object[]{bmd.getName(), bmd.getModuleMetaData().getName(), bmd.getModuleMetaData().getApplicationMetaData().getName()});
        }
        if ((eb = bmd.wccm.enterpriseBean) instanceof Session && (statefulTimeoutXML = (session = (Session)eb).getStatefulTimeout()) != null && bmd.type != 4) {
            Object[] parms = new Object[]{bmd.getName(), bmd.getModuleMetaData().getName(), bmd.getModuleMetaData().getApplicationMetaData().getName()};
            Tr.warning((TraceComponent)tc, (String)"STATEFUL_TIMEOUT_ON_NON_SFSB_CNTR0310W", (Object[])parms);
        }
    }
}

