/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.registry.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.security.wim.registry.util.BridgeUtils;
import com.ibm.ws.security.wim.registry.util.TypeMappings;
import com.ibm.wsspi.security.wim.exception.EntityNotFoundException;
import com.ibm.wsspi.security.wim.exception.EntityNotInRealmScopeException;
import com.ibm.wsspi.security.wim.exception.InvalidIdentifierException;
import com.ibm.wsspi.security.wim.exception.InvalidUniqueNameException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Context;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.ExternalNameControl;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.LoginAccount;
import com.ibm.wsspi.security.wim.model.Root;
import com.ibm.wsspi.security.wim.model.SearchControl;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SecurityNameBridge {
    private static final TraceComponent tc = Tr.register(SecurityNameBridge.class, (String)"registyUtil", (String)"com.ibm.ws.security.wim.registry.util.resources.RegistryUtilMessages");
    private TypeMappings propertyMap = null;
    private BridgeUtils mappingUtils = null;
    static final long serialVersionUID = 6696437810486401160L;

    public SecurityNameBridge(BridgeUtils mappingUtil) {
        this.mappingUtils = mappingUtil;
        this.propertyMap = new TypeMappings(mappingUtil);
    }

    @FFDCIgnore(value={WIMException.class})
    public String getUserSecurityName(String inputUniqueUserId) throws EntryNotFoundException, RegistryException {
        String methodName = "getUserSecurityName";
        String returnValue = "";
        try {
            String msg;
            List contexts;
            boolean allowDNAsPrincipalName;
            this.mappingUtils.validateId(inputUniqueUserId);
            IDAndRealm idAndRealm = this.mappingUtils.separateIDAndRealm(inputUniqueUserId);
            Root root = this.mappingUtils.getWimService().createRootObject();
            if (idAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
                List contexts2 = root.getContexts();
                if (contexts2 != null) {
                    Context ctx = new Context();
                    ctx.setKey("allowOperationIfReposDown");
                    ctx.setValue((Object)this.mappingUtils.getCoreConfiguration().isAllowOpIfRepoDown(idAndRealm.getRealm()));
                    contexts2.add(ctx);
                }
            }
            if ((allowDNAsPrincipalName = this.mappingUtils.allowDNAsPrincipalName) && (contexts = root.getContexts()) != null) {
                Context ctx = new Context();
                ctx.setKey("allowDNPrincipalNameAsLiteral");
                ctx.setValue((Object)allowDNAsPrincipalName);
                contexts.add(ctx);
            }
            String inputAttrName = this.propertyMap.getInputUniqueUserId(idAndRealm.getRealm());
            String outputAttrName = this.propertyMap.getOutputUserSecurityName(idAndRealm.getRealm());
            if (!this.mappingUtils.isIdentifierTypeProperty(inputAttrName) || allowDNAsPrincipalName) {
                List controls = root.getControls();
                SearchControl searchControl = new SearchControl();
                if (controls != null) {
                    controls.add(searchControl);
                }
                if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName)) {
                    searchControl.getProperties().add(outputAttrName);
                }
                String quote = "'";
                String id = idAndRealm.getId();
                if (id.indexOf("'") != -1) {
                    quote = "\"";
                }
                String inputName = null;
                inputName = allowDNAsPrincipalName ? "principalName" : inputAttrName;
                searchControl.setExpression("//entities[@xsi:type='LoginAccount' and " + inputName + "=" + quote + id + quote + "]");
                Context context = new Context();
                context.set("key", (Object)"useUserFilterForSearch");
                context.set("value", (Object)id);
                root.getContexts().add(context);
                root = this.mappingUtils.getWimService().search(root);
            }
            List returnList = root.getEntities();
            if (this.mappingUtils.isIdentifierTypeProperty(inputAttrName) && (returnList == null || returnList.size() == 0)) {
                List extCtrls;
                if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName)) {
                    this.mappingUtils.createPropertyControlDataObject(root, outputAttrName);
                }
                List entities = root.getEntities();
                LoginAccount loginAccount = new LoginAccount();
                if (entities != null) {
                    entities.add(loginAccount);
                }
                IdentifierType idfType = new IdentifierType();
                idfType.set(inputAttrName, (Object)idAndRealm.getId());
                loginAccount.setIdentifier(idfType);
                if (inputAttrName.equals("externalName") && (extCtrls = root.getControls()) != null) {
                    extCtrls.add(new ExternalNameControl());
                }
                root = this.mappingUtils.getWimService().get(root);
            }
            if ((returnList = root.getEntities()).isEmpty()) {
                msg = Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUniqueUserId));
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", msg);
            }
            if (returnList.size() != 1) {
                msg = Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUniqueUserId));
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", msg);
            }
            Entity entity = (Entity)returnList.get(0);
            if (entity != null) {
                Object value;
                returnValue = !this.mappingUtils.isIdentifierTypeProperty(outputAttrName) ? ((value = entity.get(outputAttrName)) instanceof List ? String.valueOf(((List)value).get(0)) : String.valueOf(value)) : (String)entity.getIdentifier().get(outputAttrName);
            }
        }
        catch (WIMException toCatch) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " " + toCatch.getMessage()), (Object[])new Object[]{toCatch});
            }
            if (toCatch instanceof EntityNotFoundException || toCatch instanceof EntityNotInRealmScopeException || toCatch instanceof InvalidUniqueNameException || toCatch instanceof InvalidIdentifierException) {
                throw new EntryNotFoundException(toCatch.getMessage(), (Throwable)toCatch);
            }
            throw new RegistryException(toCatch.getMessage(), (Throwable)toCatch);
        }
        return returnValue;
    }

    @FFDCIgnore(value={WIMException.class})
    public String getGroupSecurityName(String inputUniqueGroupId) throws EntryNotFoundException, RegistryException {
        String methodName = "getGroupSecurityName";
        String returnValue = "";
        try {
            Object value;
            String msg;
            Group group;
            this.mappingUtils.validateId(inputUniqueGroupId);
            IDAndRealm idAndRealm = this.mappingUtils.separateIDAndRealm(inputUniqueGroupId);
            Root root = this.mappingUtils.getWimService().createRootObject();
            if (idAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
            }
            String inputAttrName = this.propertyMap.getInputUniqueGroupId(idAndRealm.getRealm());
            String outputAttrName = this.propertyMap.getOutputGroupSecurityName(idAndRealm.getRealm());
            if (this.mappingUtils.isIdentifierTypeProperty(inputAttrName)) {
                List extCtrls;
                if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName)) {
                    this.mappingUtils.createPropertyControlDataObject(root, outputAttrName);
                }
                List entities = root.getEntities();
                group = null;
                if (entities != null) {
                    group = new Group();
                    entities.add(group);
                }
                IdentifierType grpIdfType = new IdentifierType();
                grpIdfType.set(inputAttrName, (Object)idAndRealm.getId());
                if (group != null) {
                    group.setIdentifier(grpIdfType);
                }
                if (inputAttrName.equals("externalName") && (extCtrls = root.getControls()) != null) {
                    extCtrls.add(new ExternalNameControl());
                }
                root = this.mappingUtils.getWimService().get(root);
            } else {
                List controls = root.getControls();
                SearchControl searchControl = new SearchControl();
                if (controls != null) {
                    controls.add(searchControl);
                }
                if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName)) {
                    searchControl.getProperties().add(outputAttrName);
                }
                String quote = "'";
                String id = idAndRealm.getId();
                if (id.indexOf("'") != -1) {
                    quote = "\"";
                }
                searchControl.setExpression("//entities[@xsi:type='Group' and " + inputAttrName + "=" + quote + id + quote + "]");
                Context context = new Context();
                context.set("key", (Object)"useGroupFilterForSearch");
                context.set("value", (Object)id);
                root.getContexts().add(context);
                root = this.mappingUtils.getWimService().search(root);
            }
            List returnList = root.getEntities();
            if (returnList.isEmpty()) {
                msg = Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUniqueGroupId));
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", msg);
            }
            if (returnList.size() != 1) {
                msg = Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUniqueGroupId));
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", msg);
            }
            group = (Entity)returnList.get(0);
            returnValue = !this.mappingUtils.isIdentifierTypeProperty(outputAttrName) ? ((value = group.get(outputAttrName)) instanceof List ? String.valueOf(((List)value).get(0)) : String.valueOf(value)) : (String)group.getIdentifier().get(outputAttrName);
        }
        catch (WIMException toCatch) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " " + toCatch.getMessage()), (Object[])new Object[]{toCatch});
            }
            if (toCatch instanceof EntityNotFoundException || toCatch instanceof EntityNotInRealmScopeException || toCatch instanceof InvalidUniqueNameException || toCatch instanceof InvalidIdentifierException) {
                throw new EntryNotFoundException(toCatch.getMessage(), (Throwable)toCatch);
            }
            throw new RegistryException(toCatch.getMessage(), (Throwable)toCatch);
        }
        return returnValue;
    }
}

