/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.classsource.specification.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.anno.classsource.specification.ClassSource_Specification_Direct;
import com.ibm.ws.anno.classsource.specification.internal.ClassSourceImpl_Specification;
import com.ibm.ws.anno.util.internal.UtilImpl_FileUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_Exception;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class ClassSourceImpl_Specification_Direct
extends ClassSourceImpl_Specification
implements ClassSource_Specification_Direct {
    protected String immediatePath;
    protected String applicationLibraryPath;
    protected List<String> applicationLibraryJarPaths;
    protected List<String> manifestJarPaths;
    static final long serialVersionUID = 4132094737750383140L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected ClassSourceImpl_Specification_Direct(ClassSourceImpl_Factory factory) {
        super(factory);
    }

    @Override
    public String getImmediatePath() {
        return this.immediatePath;
    }

    @Override
    public void setImmediatePath(String immediatePath) {
        this.immediatePath = immediatePath;
    }

    @Override
    public String getApplicationLibraryPath() {
        return this.applicationLibraryPath;
    }

    @Override
    public void setApplicationLibraryPath(String applicationLibraryPath) {
        this.applicationLibraryPath = applicationLibraryPath;
    }

    @Override
    public List<String> getApplicationLibraryJarPaths() {
        return this.applicationLibraryJarPaths;
    }

    @Override
    public void addApplicationLibraryJarPath(String applicationLibraryJarPath) {
        if (this.applicationLibraryJarPaths == null) {
            this.applicationLibraryJarPaths = new ArrayList<String>();
        }
        this.applicationLibraryJarPaths.add(applicationLibraryJarPath);
    }

    @Override
    public void addApplicationLibraryJarPaths(List<String> applicationLibraryJarPaths) {
        if (this.applicationLibraryJarPaths == null) {
            this.applicationLibraryJarPaths = new ArrayList<String>();
        }
        this.applicationLibraryJarPaths.addAll(applicationLibraryJarPaths);
    }

    @Override
    public List<String> getManifestJarPaths() {
        return this.manifestJarPaths;
    }

    @Override
    public void addManifestJarPath(String manifestJarPath) {
        if (this.manifestJarPaths == null) {
            this.manifestJarPaths = new ArrayList<String>();
        }
        this.manifestJarPaths.add(manifestJarPath);
    }

    @Override
    public void addManifestJarPaths(List<String> manifestJarPaths) {
        if (this.manifestJarPaths == null) {
            this.manifestJarPaths = new ArrayList<String>();
        }
        this.manifestJarPaths.addAll(manifestJarPaths);
    }

    @Override
    public abstract ClassSource_Aggregate createClassSource(String var1, ClassLoader var2) throws ClassSource_Exception;

    protected void addStandardClassSources(String moduleUri, ClassLoader rootClassLoader, ClassSource_Aggregate classSource) throws ClassSource_Exception {
        List<String> manifestJarPaths;
        String useApplicationLibPath = this.getApplicationLibraryPath();
        List<String> applicationLibJarPaths = useApplicationLibPath != null ? this.selectJars(useApplicationLibPath) : this.getApplicationLibraryJarPaths();
        if (applicationLibJarPaths != null) {
            for (String nextJarPath : applicationLibJarPaths) {
                this.getFactory().addJarClassSource(classSource, nextJarPath, nextJarPath, ClassSource_Aggregate.ScanPolicy.EXTERNAL);
            }
        }
        if ((manifestJarPaths = this.getManifestJarPaths()) != null) {
            for (String nextManifestJarPath : manifestJarPaths) {
                this.getFactory().addJarClassSource(classSource, nextManifestJarPath, nextManifestJarPath, ClassSource_Aggregate.ScanPolicy.EXTERNAL);
            }
        }
        if (rootClassLoader != null) {
            this.getFactory().addClassLoaderClassSource(classSource, "classloader", rootClassLoader);
        }
    }

    public List<String> selectJars(String targetPath) {
        ArrayList<String> jarPaths = new ArrayList<String>();
        if (targetPath == null) {
            return jarPaths;
        }
        File targetDir = new File(targetPath);
        if (!UtilImpl_FileUtils.exists(targetDir)) {
            return jarPaths;
        }
        File[] targetFiles = UtilImpl_FileUtils.listFiles(targetDir);
        if (targetFiles != null) {
            for (File nextTargetFile : targetFiles) {
                String nextTargetName = nextTargetFile.getName();
                if (!nextTargetName.toUpperCase().endsWith(".JAR")) continue;
                String nextTargetPath = targetPath + "/" + nextTargetName;
                jarPaths.add(nextTargetPath);
            }
        }
        return jarPaths;
    }

    @Override
    public abstract void log(TraceComponent var1);

    protected void logCommon(TraceComponent logger) {
        List<String> useManifestJarPaths;
        Tr.debug((TraceComponent)logger, (String)("  Immediate path [ " + this.getImmediatePath() + " ]"), (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)("  Application library path [ " + this.getApplicationLibraryPath() + " ]"), (Object[])new Object[0]);
        List<String> useLibraryJarPaths = this.getApplicationLibraryJarPaths();
        if (useLibraryJarPaths != null) {
            for (String nextJarPath : useLibraryJarPaths) {
                Tr.debug((TraceComponent)logger, (String)("  Application library jar [ " + nextJarPath + " ]"), (Object[])new Object[0]);
            }
        }
        if ((useManifestJarPaths = this.getManifestJarPaths()) != null) {
            for (String nextJarPath : useManifestJarPaths) {
                Tr.debug((TraceComponent)logger, (String)("  Manifest jar [ " + nextJarPath + " ]"), (Object[])new Object[0]);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ClassSourceImpl_Specification_Direct.class, null, null);
    }
}

