/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.info.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.anno.info.internal.AnnotationInfoImpl;
import com.ibm.ws.anno.info.internal.AnnotationValueImpl;
import com.ibm.ws.anno.info.internal.ClassInfoImpl;
import com.ibm.ws.anno.info.internal.InfoImpl;
import com.ibm.ws.anno.info.internal.InfoStoreImpl;
import com.ibm.ws.anno.info.internal.NonDelayedClassInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.info.AnnotationInfo;
import com.ibm.wsspi.anno.info.MethodInfo;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MethodInfoImpl
extends InfoImpl
implements MethodInfo {
    public static final TraceComponent tc = Tr.register(MethodInfoImpl.class, (String)"com.ibm.ws.anno", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    public static final String CLASS_NAME = MethodInfoImpl.class.getName();
    protected ClassInfoImpl declaringClass;
    private final String desc;
    private final List<String> exceptionClassNames;
    private List<ClassInfoImpl> exceptionClassInfos;
    private List<String> parameterTypeNames;
    private List<ClassInfoImpl> parameterClassInfos;
    private List<List<? extends AnnotationInfo>> parameterAnnotations;
    private ClassInfoImpl returnClassInfo;
    protected Type returnTypeAsType;
    protected String returnTypeName;
    protected AnnotationValueImpl annotationDefaultValue;
    static final long serialVersionUID = 8481405803330640508L;

    @Override
    protected String computeHashText() {
        return this.getClass().getName() + "@" + Integer.toString(new Object().hashCode()) + " ( " + this.getQualifiedName() + this.getDescription() + " )";
    }

    public MethodInfoImpl(String name, String desc, String[] exceptions, int modifiers, NonDelayedClassInfo declaringClass) {
        super(name, modifiers, declaringClass.getInfoStore());
        InfoStoreImpl useInfoStore = this.getInfoStore();
        this.desc = useInfoStore.internDescription(desc);
        this.declaringClass = declaringClass;
        if (exceptions != null) {
            for (int exceptionNo = 0; exceptionNo < exceptions.length; ++exceptionNo) {
                String nextException = exceptions[exceptionNo];
                nextException = nextException.replace('/', '.');
                exceptions[exceptionNo] = useInfoStore.internClassName(nextException);
            }
        }
        this.exceptionClassNames = exceptions == null ? Collections.emptyList() : Arrays.asList(exceptions);
        this.exceptionClassInfos = null;
        this.parameterClassInfos = null;
        this.parameterAnnotations = Collections.emptyList();
        if (tc.isDumpEnabled()) {
            Tr.dump((TraceComponent)tc, (String)"<init> [ {0} ] Created on [ {1} ] [ {2} ]", (Object[])new Object[]{this.getHashText(), this.getDeclaringClass().getHashText(), this.getDescription()});
        }
    }

    @Override
    public ClassInfoImpl getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    protected String internName(String name) {
        return this.getInfoStore().internMethodName(name);
    }

    @Override
    public String getQualifiedName() {
        return this.getDeclaringClass().getName() + '.' + this.getName();
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public List<String> getExceptionTypeNames() {
        return this.exceptionClassNames;
    }

    public List<ClassInfoImpl> getExceptionTypes() {
        if (this.exceptionClassInfos == null) {
            if (this.exceptionClassNames.isEmpty()) {
                this.exceptionClassInfos = Collections.emptyList();
            } else {
                ClassInfoImpl[] exceptionInfos = new ClassInfoImpl[this.exceptionClassNames.size()];
                int i = 0;
                for (String exceptionClassName : this.exceptionClassNames) {
                    exceptionInfos[i++] = this.getDelayableClassInfo(exceptionClassName);
                }
                this.exceptionClassInfos = Arrays.asList(exceptionInfos);
            }
        }
        return this.exceptionClassInfos;
    }

    @Override
    public List<String> getParameterTypeNames() {
        if (this.parameterTypeNames == null) {
            Type[] argumentTypes = Type.getArgumentTypes((String)this.getDescription());
            if (argumentTypes.length == 0) {
                this.parameterTypeNames = Collections.emptyList();
            } else {
                String[] parameterNames = new String[argumentTypes.length];
                int i = 0;
                for (Type nextType : argumentTypes) {
                    String nextTypeName = nextType.getClassName();
                    nextTypeName = this.getInfoStore().internClassName(nextTypeName);
                    parameterNames[i++] = nextTypeName;
                }
                this.parameterTypeNames = Arrays.asList(parameterNames);
            }
        }
        return this.parameterTypeNames;
    }

    public List<ClassInfoImpl> getParameterTypes() {
        if (this.parameterClassInfos == null) {
            Type[] argumentTypes = Type.getArgumentTypes((String)this.getDescription());
            if (argumentTypes.length == 0) {
                this.parameterClassInfos = Collections.emptyList();
            } else {
                ClassInfoImpl[] parameterInfos = new ClassInfoImpl[argumentTypes.length];
                int i = 0;
                for (Type nextType : argumentTypes) {
                    parameterInfos[i++] = this.getDelayableClassInfo(nextType);
                }
                this.parameterClassInfos = Arrays.asList(parameterInfos);
            }
        }
        return this.parameterClassInfos;
    }

    @Override
    public List<List<? extends AnnotationInfo>> getParameterAnnotations() {
        return this.parameterAnnotations;
    }

    public void setParameterAnnotations(List<AnnotationInfoImpl>[] parmAnnos) {
        if (parmAnnos == null) {
            this.parameterAnnotations = Collections.emptyList();
        } else {
            List[] parmInfos = new List[parmAnnos.length];
            for (int i = 0; i < parmAnnos.length; ++i) {
                parmInfos[i] = parmAnnos[i];
            }
            this.parameterAnnotations = Arrays.asList(parmInfos);
        }
    }

    public Type getReturnTypeAsType() {
        if (this.returnTypeAsType == null) {
            this.returnTypeAsType = Type.getReturnType((String)this.getDescription());
        }
        return this.returnTypeAsType;
    }

    @Override
    public String getReturnTypeName() {
        if (this.returnTypeName == null) {
            this.returnTypeName = this.getReturnTypeAsType().getClassName();
        }
        return this.returnTypeName;
    }

    @Override
    public ClassInfoImpl getReturnType() {
        if (this.returnClassInfo == null) {
            this.returnClassInfo = this.getInfoStore().getDelayableClassInfo(this.getReturnTypeAsType());
        }
        return this.returnClassInfo;
    }

    public void setAnnotationDefaultValue(AnnotationValueImpl annotationDefaultValue) {
        AnnotationValueImpl priorDefaultValue = this.annotationDefaultValue;
        this.annotationDefaultValue = annotationDefaultValue;
        if (tc.isDumpEnabled()) {
            Tr.dump((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] of [ {1} ] Updated from [ {2} ] to [ {3} ]", this.getHashText(), this.getDeclaringClass().getHashText(), priorDefaultValue, this.annotationDefaultValue), (Object[])new Object[0]);
        }
    }

    @Override
    public AnnotationValueImpl getAnnotationDefaultValue() {
        return this.annotationDefaultValue;
    }

    @Override
    public String getSignature() {
        return this.getQualifiedName() + '(' + this.getParametersText() + ')';
    }

    protected String getParametersText() {
        List<ClassInfoImpl> useParmTypes = this.getParameterTypes();
        if (useParmTypes.isEmpty()) {
            return "";
        }
        StringBuffer parmsBuf = new StringBuffer();
        boolean isFirst = true;
        for (ClassInfoImpl classInfo : useParmTypes) {
            if (!isFirst) {
                parmsBuf.append(",");
                isFirst = false;
            }
            parmsBuf.append(classInfo.getName());
        }
        return parmsBuf.toString();
    }

    @Override
    public void log(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("Method [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Name [ {0} ]", this.getName()), (Object[])new Object[0]);
        for (ClassInfoImpl nextParameterType : this.getParameterTypes()) {
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Parameter Type [ {0} ]", nextParameterType.getHashText()), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Return Type [ {0} ]", this.getReturnType().getHashText()), (Object[])new Object[0]);
        for (ClassInfoImpl nextExceptionType : this.getExceptionTypes()) {
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Exception Type [ {0} ]", nextExceptionType.getHashText()), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Declaring Class [ {0} ]", this.getDeclaringClass().getHashText()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Default Value [ {0} ]", this.getAnnotationDefaultValue()), (Object[])new Object[0]);
    }
}

