/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.jandex.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Jandex_Utils {
    static final long serialVersionUID = 4751851316841215936L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static Indexer createIndexer() {
        return new Indexer();
    }

    public static void updateIndexer(Indexer indexer, String classPath, InputStream classStream) throws IOException {
        indexer.index(classStream);
    }

    public static Index completeIndexer(Indexer indexer) {
        return indexer.complete();
    }

    public static Index readIndex(String jarPath) {
        try {
            return Jandex_Utils.basicReadIndex(jarPath);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.anno.jandex.internal.Jandex_Utils", (String)"37", null, (Object[])new Object[]{jarPath});
            throw new RuntimeException("Failed to read index [ " + jarPath + " ]");
        }
    }

    public static Index basicReadIndex(String jarPath) throws Exception {
        try (FileInputStream inputStream = new FileInputStream(jarPath);){
            Index index = Jandex_Utils.basicReadIndex(inputStream);
            return index;
        }
    }

    public static Index basicReadIndex(InputStream inputStream) throws IOException {
        IndexReader indexReader = new IndexReader(inputStream);
        return indexReader.read();
    }

    public static void writeIndex(String jarPath, Index index) {
        try {
            Jandex_Utils.basicWriteIndex(jarPath, index);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.anno.jandex.internal.Jandex_Utils", (String)"61", null, (Object[])new Object[]{jarPath, index});
            throw new RuntimeException("Failed to write index [ " + jarPath + " ]");
        }
    }

    public static void basicWriteIndex(String jarPath, Index index) throws Exception {
        try (FileOutputStream outputStream = new FileOutputStream(jarPath);){
            Jandex_Utils.basicWriteIndex(outputStream, index, "Write [ " + jarPath + " ]");
        }
    }

    public static void basicWriteIndex(OutputStream outputStream, Index index, String writeCase) throws IOException {
        IndexWriter indexWriter = new IndexWriter(outputStream);
        indexWriter.write(index);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Index createIndex(String path) {
        FileInputStream pathInputStream;
        File pathFile = new File(path);
        if (!pathFile.exists()) {
            throw new IllegalArgumentException("Target [ " + path + " ] does not exist");
        }
        if (pathFile.isDirectory()) {
            throw new IllegalArgumentException("Target [ " + path + " ] is a directory");
        }
        Indexer indexer = Jandex_Utils.createIndexer();
        try {
            pathInputStream = new FileInputStream(path);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.anno.jandex.internal.Jandex_Utils", (String)"101", null, (Object[])new Object[]{path});
            throw new RuntimeException("Failed to open [ " + path + " ]", (Throwable)e);
        }
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream2332 = new ZipInputStream(pathInputStream);
            while ((zipEntry = zipInputStream2332.getNextEntry()) != null) {
                String zipEntryName;
                if (zipEntry.isDirectory() || !(zipEntryName = zipEntry.getName()).endsWith(".class")) continue;
                Jandex_Utils.updateIndexer(indexer, zipEntry.getName(), zipInputStream2332);
            }
        }
        catch (Exception e) {
            try {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.anno.jandex.internal.Jandex_Utils", (String)"122", null, (Object[])new Object[]{path});
                throw new RuntimeException("Failed to process [ " + path + " ]", e);
            }
            catch (Throwable throwable) {
                try {
                    pathInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    void e2;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.anno.jandex.internal.Jandex_Utils", (String)"128", null, (Object[])new Object[]{path});
                    throw new RuntimeException("Failed to open [ " + path + " ]", (Throwable)e2);
                }
            }
        }
        try {
            pathInputStream.close();
            return Jandex_Utils.completeIndexer(indexer);
        }
        catch (IOException zipInputStream2332) {
            FFDCFilter.processException((Throwable)zipInputStream2332, (String)"com.ibm.ws.anno.jandex.internal.Jandex_Utils", (String)"128", null, (Object[])new Object[]{path});
            throw new RuntimeException("Failed to open [ " + path + " ]", (Throwable)e);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(Jandex_Utils.class, (String)"com.ibm.ws.anno", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    }
}

