/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.targets.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.service.internal.AnnotationServiceImpl_Logging;
import com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_Factory;
import com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_Streamer;
import com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_Targets;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_Exception;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Exception;
import java.text.MessageFormat;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AnnotationTargetsImpl_Scanner {
    private static final TraceComponent tc = Tr.register(AnnotationTargetsImpl_Scanner.class, (String)"com.ibm.ws.anno", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    public static final String CLASS_NAME = AnnotationTargetsImpl_Scanner.class.getName();
    protected final String hashText;
    protected final AnnotationTargetsImpl_Factory factory;
    protected final ClassSource_Aggregate classSource;
    protected final AnnotationTargetsImpl_Targets annotationTargets;
    protected final AnnotationTargetsImpl_Streamer streamer;
    long timeSpentInDeclaredScan = 0L;
    long timeSpentInReferenceScan = 0L;
    static final long serialVersionUID = 5563159421940803944L;

    public String getHashText() {
        return this.hashText;
    }

    protected AnnotationTargetsImpl_Scanner(AnnotationTargetsImpl_Factory factory, ClassSource_Aggregate classSource, AnnotationTargetsImpl_Targets annotationTargets) throws AnnotationTargets_Exception {
        String methodName = "init";
        this.hashText = AnnotationServiceImpl_Logging.getBaseHash(this);
        this.factory = factory;
        this.classSource = classSource;
        this.annotationTargets = annotationTargets;
        this.streamer = new AnnotationTargetsImpl_Streamer(this);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ]", this.hashText), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("  Class Source [ {0} ]", this.classSource.getHashText()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("  Targets [ {0} ]", this.annotationTargets.getHashText()), (Object[])new Object[0]);
        }
    }

    @Trivial
    public AnnotationTargetsImpl_Factory getFactory() {
        return this.factory;
    }

    @Trivial
    public ClassSource_Aggregate getClassSource() {
        return this.classSource;
    }

    /*
     * WARNING - void declaration
     */
    protected void openClassSource() throws AnnotationTargets_Exception {
        String methodName = "openClassSource";
        try {
            this.getClassSource().open();
        }
        catch (ClassSource_Exception classSource_Exception) {
            void e;
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_Scanner", (String)"90", (Object)this, (Object[])new Object[0]);
            Tr.warning((TraceComponent)tc, (String)"ANNO_TARGETS_SCAN_EXCEPTION", (Object[])new Object[]{e});
            throw this.getFactory().wrapIntoAnnotationTargetsException(tc, CLASS_NAME, methodName, "Failed to open class source", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void closeClassSource() throws AnnotationTargets_Exception {
        String methodName = "closeClassSource";
        try {
            this.getClassSource().close();
        }
        catch (ClassSource_Exception classSource_Exception) {
            void e;
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_Scanner", (String)"107", (Object)this, (Object[])new Object[0]);
            Tr.warning((TraceComponent)tc, (String)"ANNO_TARGETS_SCAN_EXCEPTION", (Object[])new Object[]{e});
            throw this.getFactory().wrapIntoAnnotationTargetsException(tc, CLASS_NAME, methodName, "Failed to close class source", (Throwable)e);
        }
    }

    @Trivial
    public AnnotationTargetsImpl_Targets getAnnotationTargets() {
        return this.annotationTargets;
    }

    @Trivial
    protected AnnotationTargetsImpl_Streamer getStreamer() {
        return this.streamer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    public void scanReferenced() throws AnnotationTargets_Exception {
        String methodName = "scanReferenced";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{this.getHashText()});
        }
        long startTime = System.currentTimeMillis();
        try {
            this.openClassSource();
            this.scanReferencedClasses();
        }
        finally {
            this.closeClassSource();
        }
        long stopTime = System.currentTimeMillis();
        this.logState();
        this.timeSpentInReferenceScan += stopTime - startTime;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.getHashText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    public void scanDirect() throws AnnotationTargets_Exception {
        String methodName = "scanDirect";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{this.getHashText()});
        }
        long startTime = System.currentTimeMillis();
        try {
            this.openClassSource();
            this.scanClasses();
        }
        finally {
            this.closeClassSource();
        }
        long stopTime = System.currentTimeMillis();
        this.logState();
        this.timeSpentInDeclaredScan += stopTime - startTime;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.getHashText());
        }
    }

    public void scan(Set<String> specificClassNames) throws AnnotationTargets_Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER [ {1} ] specific classes", this.getHashText(), specificClassNames.size()), (Object[])new Object[0]);
        }
        try {
            this.openClassSource();
            this.scanSpecificClasses(specificClassNames);
            this.scanReferencedClasses();
        }
        finally {
            this.closeClassSource();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN", this.getHashText()), (Object[])new Object[0]);
        }
    }

    protected void scanClasses() {
        this.getClassSource().scanClasses(this.getStreamer());
    }

    /*
     * WARNING - void declaration
     */
    protected void scanSpecificClasses(Set<String> specificClassNames) {
        ClassSource_Aggregate useClassSource = this.getClassSource();
        AnnotationTargetsImpl_Streamer useStreamer = this.getStreamer();
        for (String className : specificClassNames) {
            try {
                useClassSource.scanSpecificSeedClass(className, useStreamer);
            }
            catch (ClassSource_Exception classSource_Exception) {
                void e;
                FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_Scanner", (String)"267", (Object)this, (Object[])new Object[]{specificClassNames});
                Tr.warning((TraceComponent)tc, (String)"ANNO_TARGETS_SCAN_EXCEPTION", (Object[])new Object[]{e});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void scanReferencedClasses() {
        Set<String> referencedClassNames;
        AnnotationTargetsImpl_Targets annotationTargets = this.getAnnotationTargets();
        Set<String> scannedClassNames = annotationTargets.getScannedClassNames();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Initial scan found [ {1} ] classes", this.getHashText(), scannedClassNames.size()), (Object[])new Object[0]);
        }
        AnnotationTargetsImpl_Streamer useStreamer = this.getStreamer();
        ClassSource_Aggregate useClassSource = this.getClassSource();
        int referencePassNo = 0;
        while (!(referencedClassNames = this.getAnnotationTargets().getReferencedClassNames()).isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Scanning referenced classes [ {1} ] -- pass [ {2} ]", this.getHashText(), referencedClassNames.size(), referencePassNo), (Object[])new Object[0]);
            }
            for (String referencedClassName : referencedClassNames) {
                boolean didScan;
                try {
                    didScan = useClassSource.scanReferencedClass(referencedClassName, useStreamer);
                }
                catch (ClassSource_Exception classSource_Exception) {
                    void e;
                    FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_Scanner", (String)"306", (Object)this, (Object[])new Object[0]);
                    didScan = false;
                    Tr.warning((TraceComponent)tc, (String)"ANNO_TARGETS_SCAN_EXCEPTION", (Object[])new Object[]{e});
                }
                if (didScan) continue;
                annotationTargets.recordUnresolvedClass(referencedClassName);
            }
            scannedClassNames = annotationTargets.getScannedClassNames();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Reference pass [ {1} ] scan found [ {2} ] classes", this.getHashText(), scannedClassNames.size()), (Object[])new Object[0]);
            }
            ++referencePassNo;
        }
    }

    public long getTotalLookups() {
        return this.getClassSource().getTotalLookups();
    }

    public long getRepeatLookups() {
        return this.getClassSource().getRepeatLookups();
    }

    public void logState() {
        TraceComponent stateLogger = AnnotationServiceImpl_Logging.stateLogger;
        if (stateLogger.isDebugEnabled()) {
            this.log(stateLogger);
        }
    }

    public void log(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("BEGIN STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        this.getClassSource().log(logger);
        this.getAnnotationTargets().log(logger);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("END STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
    }
}

