/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc.cdi.weld;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInjectionClassListCollaborator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebSocketInjectionClassListCollaborator
implements WebAppInjectionClassListCollaborator {
    private static final TraceComponent tc = Tr.register(WebSocketInjectionClassListCollaborator.class, (String)"websockets", null);
    private final String[] injectionSubClasses = new String[]{"javax.websocket.Endpoint"};
    static final long serialVersionUID = 3925516627088052001L;

    @FFDCIgnore(value={UnableToAdaptException.class})
    public List<String> getInjectionClasses(Container moduleContainer) {
        ArrayList<String> classList;
        block6: {
            classList = new ArrayList<String>();
            try {
                WebAnnotations webAnnotations = (WebAnnotations)moduleContainer.adapt(WebAnnotations.class);
                AnnotationTargets_Targets annotationTargets = webAnnotations.getAnnotationTargets();
                Set annotatedPojoClassNames = annotationTargets.getAnnotatedClasses("javax.websocket.server.ServerEndpoint");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getInjectionClasses", (Object[])new Object[]{"Found and added annotated server endpoint classes of: " + annotatedPojoClassNames});
                }
                classList.addAll(annotatedPojoClassNames);
                for (String injectionSubClass : this.injectionSubClasses) {
                    Set injectionClassNames = annotationTargets.getSubclassNames(injectionSubClass);
                    for (String element : injectionClassNames) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"getInjectionClasses", (Object[])new Object[]{"Found extender of " + injectionSubClass + " : " + element});
                        }
                        if (classList.contains(element)) continue;
                        classList.add(element);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"getInjectionClasses", (Object[])new Object[]{"Add sub class :" + element});
                    }
                }
            }
            catch (UnableToAdaptException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"failed to adapt to for class annotations", (Object[])new Object[]{e});
            }
        }
        return classList;
    }
}

