/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.openapi.ConfigProcessor;
import com.ibm.ws.microprofile.openapi.impl.CustomCSSWABUpdater;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.location.MalformedLocationException;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={CustomCSSProcessor.class, ServerQuiesceListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public final class CustomCSSProcessor
implements FileMonitor,
ServerQuiesceListener {
    private static final TraceComponent tc = Tr.register(CustomCSSProcessor.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    private static final String KEY_EXECUTOR_SERVICE_REF = "executorService";
    private final AtomicServiceReference<ScheduledExecutorService> executorServiceRef = new AtomicServiceReference("executorService");
    private volatile WsLocationAdmin locationAdminProvider;
    private final String DEFAULT_LOCATION_CSS = "${server.config.dir}/mpopenapi/customization.css";
    private static final String CUSTOM_CSS_SECTION_START = ".swagger-ui .headerbar ";
    private static final String CUSTOM_CSS_SECTION_END = "}";
    private ServiceRegistration<FileMonitor> fileMonitor;
    private final List<String> filesToMonitor = new ArrayList<String>();
    private final CustomCSSWABUpdater updater;
    private final Object cssUpdaterLock = new Object();
    private final ConcurrentLinkedQueue<CSSUpdate> cssUpdates = new ConcurrentLinkedQueue();
    static final long serialVersionUID = 1697180188879936818L;

    public CustomCSSProcessor() {
        this.updater = new CustomCSSWABUpdater();
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        this.executorServiceRef.activate(cc);
        this.normalizeDefaultCSSLocationPath();
        this.activateFileMonitor(cc);
        this.process(this.locationAdminProvider, (ScheduledExecutorService)this.executorServiceRef.getService());
    }

    @Deactivate
    protected void deactivate(ComponentContext cc, int reason) {
        this.deactivateFileMonitor();
        this.executorServiceRef.deactivate(cc);
    }

    private File normalizePath(String path) {
        String normalizedPath = PathUtils.normalize((String)path);
        WsResource resource = this.locationAdminProvider.resolveResource(normalizedPath);
        File customizationFile = resource.asFile();
        return customizationFile;
    }

    private void normalizeDefaultCSSLocationPath() {
        this.filesToMonitor.add(this.normalizePath("${server.config.dir}/mpopenapi/customization.css").getAbsolutePath());
    }

    private synchronized void activateFileMonitor(ComponentContext cc) {
        int pollingInterval = new ConfigProcessor(CustomCSSProcessor.class.getClassLoader()).getFilePollingInterval();
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("mp.openapi.extensions.liberty.file.polling.interval=" + pollingInterval), (Object[])new Object[0]);
        }
        if (pollingInterval > 0) {
            BundleContext bundleContext = cc.getBundleContext();
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("service.vendor", "IBM");
            ((Dictionary)props).put("monitor.interval", String.valueOf(pollingInterval) + "s");
            ((Dictionary)props).put("monitor.files", this.filesToMonitor);
            if (this.fileMonitor == null) {
                this.fileMonitor = bundleContext.registerService(FileMonitor.class, (Object)this, props);
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Registered FileMonitor service : fileLocations=" + this.filesToMonitor.stream().map(f -> f.toString()).collect(Collectors.joining(", ", "{", CUSTOM_CSS_SECTION_END))), (Object[])new Object[0]);
                }
            } else {
                this.fileMonitor.setProperties(props);
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Updated FileMonitor service : fileLocations=" + this.filesToMonitor.stream().map(f -> f.toString()).collect(Collectors.joining(", ", "{", CUSTOM_CSS_SECTION_END))), (Object[])new Object[0]);
                }
            }
        } else {
            this.deactivateFileMonitor();
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("FileMonitor service has been disabled : fileLocations=" + this.filesToMonitor.stream().map(f -> f.toString()).collect(Collectors.joining(", ", "{", CUSTOM_CSS_SECTION_END))), (Object[])new Object[0]);
            }
        }
    }

    private synchronized void deactivateFileMonitor() {
        if (this.fileMonitor != null) {
            this.fileMonitor.unregister();
            this.fileMonitor = null;
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Deactivated FileMonitor service.", (Object[])new Object[0]);
            }
        }
    }

    @FFDCIgnore(value={IOException.class, SecurityException.class, MalformedLocationException.class, IllegalArgumentException.class})
    public void process(WsLocationAdmin locationAdminProvider, ScheduledExecutorService executor) {
        boolean cssProcessed;
        block12: {
            if (locationAdminProvider == null || executor == null) {
                return;
            }
            cssProcessed = false;
            try {
                WsResource resource = locationAdminProvider.resolveResource("${server.config.dir}/mpopenapi/customization.css");
                if (resource.exists()) {
                    String uri = resource.toExternalURI().toString();
                    try {
                        InputStream is = resource.get();
                        String content = this.getCSSSections(is);
                        if (content != null) {
                            HashMap<String, Object> cssData = new HashMap<String, Object>();
                            cssData.put("header-css-url", uri);
                            cssData.put("header-css-content", content);
                            CSSUpdate update = new CSSUpdate();
                            update.updateData = cssData;
                            this.cssUpdates.add(update);
                            cssProcessed = true;
                            break block12;
                        }
                        Tr.warning((TraceComponent)tc, (String)"CSS_SECTION_NOT_FOUND", (Object[])new Object[]{uri});
                    }
                    catch (IOException ioe) {
                        Tr.warning((TraceComponent)tc, (String)"CSS_NOT_PROCESSED", (Object[])new Object[]{uri, ioe.getClass().getName(), ioe.getMessage()});
                    }
                    catch (SecurityException se) {
                        Tr.warning((TraceComponent)tc, (String)"CSS_NOT_PROCESSED", (Object[])new Object[]{uri, se.getClass().getName(), se.getMessage()});
                    }
                    break block12;
                }
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"Restore to default CSS", (Object[])new Object[0]);
                }
                this.cssUpdates.add(new CSSUpdate());
                cssProcessed = true;
            }
            catch (MalformedLocationException mle) {
                Tr.warning((TraceComponent)tc, (String)"CSS_NOT_PROCESSED", (Object[])new Object[]{"${server.config.dir}/mpopenapi/customization.css", ((Object)((Object)mle)).getClass().getName(), mle.getMessage()});
            }
            catch (IllegalArgumentException iae) {
                Tr.warning((TraceComponent)tc, (String)"CSS_NOT_PROCESSED", (Object[])new Object[]{"${server.config.dir}/mpopenapi/customization.css", iae.getClass().getName(), iae.getMessage()});
            }
        }
        if (!cssProcessed) {
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"CSS was not processed - error occurred. So restore to default.", (Object[])new Object[0]);
            }
            this.cssUpdates.add(new CSSUpdate());
        }
        this.processCSSUpdates(executor);
    }

    private void processCSSUpdates(ScheduledExecutorService executor) {
        if (this.cssUpdates.size() > 0) {
            final Object cssUpdator = this.cssUpdaterLock;
            Runnable bundleUpdater = new Runnable(){
                static final long serialVersionUID = 3871368274427510507L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = cssUpdator;
                    synchronized (object) {
                        Iterator it = CustomCSSProcessor.this.cssUpdates.iterator();
                        while (it.hasNext()) {
                            CSSUpdate update = (CSSUpdate)it.next();
                            if (update.updateData != null) {
                                CustomCSSProcessor.this.updater.update(update.updateData);
                            } else {
                                CustomCSSProcessor.this.updater.restoreDefaults();
                            }
                            it.remove();
                        }
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
                }
            };
            executor.execute(bundleUpdater);
        }
    }

    private String getCSSSections(InputStream is) throws IOException {
        int endIndex;
        String content = this.getContent(is);
        StringBuilder cssSections = new StringBuilder();
        boolean foundCSSSection = false;
        int startIndex = content.indexOf(CUSTOM_CSS_SECTION_START, 0);
        while (startIndex != -1 && (endIndex = content.indexOf(CUSTOM_CSS_SECTION_END, startIndex)) != -1) {
            cssSections.append(content.substring(startIndex, endIndex + 1));
            foundCSSSection = true;
            startIndex = content.indexOf(CUSTOM_CSS_SECTION_START, endIndex + 1);
        }
        return foundCSSSection ? cssSections.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContent(InputStream is) throws IOException {
        try (Reader reader = null;){
            int c;
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuilder builder = new StringBuilder();
            while ((c = reader.read()) != -1) {
                builder.append((char)c);
            }
            String string = builder.toString();
            return string;
        }
    }

    @Reference(name="executorService", service=ScheduledExecutorService.class)
    protected void setExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorServiceRef.setReference(ref);
    }

    protected void unsetExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorServiceRef.unsetReference(ref);
    }

    @Reference(service=WsLocationAdmin.class)
    protected void setLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = provider;
    }

    protected void unsetLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = null;
    }

    @Reference(service=ConfigProviderResolver.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setConfigProvider(ConfigProviderResolver configResolver) {
    }

    public void onBaseline(Collection<File> baseline) {
    }

    public void onChange(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
        this.process(this.locationAdminProvider, (ScheduledExecutorService)this.executorServiceRef.getService());
    }

    public void serverStopping() {
        this.updater.serverStopping();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class CSSUpdate {
        Map<String, Object> updateData;
        static final long serialVersionUID = -4725222350897655076L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CSSUpdate.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
        }
    }
}

