/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.core.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.core.converter.ModelConverter;
import com.ibm.ws.microprofile.openapi.impl.core.converter.ModelConverterContext;
import com.ibm.ws.microprofile.openapi.impl.core.jackson.SwaggerAnnotationIntrospector;
import com.ibm.ws.microprofile.openapi.impl.core.jackson.TypeNameResolver;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.microprofile.openapi.models.media.Schema;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractModelConverter
implements ModelConverter {
    protected final ObjectMapper _mapper;
    protected final AnnotationIntrospector _intr;
    protected final TypeNameResolver _typeNameResolver = TypeNameResolver.std;
    protected Map<JavaType, String> _resolvedTypeNames = Collections.synchronizedMap(new WeakHashMap());
    private static final TraceComponent tc = Tr.register(AbstractModelConverter.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    static final long serialVersionUID = 6912426635751747698L;

    protected AbstractModelConverter(ObjectMapper mapper) {
        mapper.registerModule((Module)new SimpleModule("swagger", Version.unknownVersion()){
            static final long serialVersionUID = 7275021503382203685L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public void setupModule(Module.SetupContext context) {
                context.insertAnnotationIntrospector((AnnotationIntrospector)new SwaggerAnnotationIntrospector());
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
            }
        });
        this._mapper = mapper;
        this._intr = mapper.getSerializationConfig().getAnnotationIntrospector();
    }

    @Override
    public Schema resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        if (chain.hasNext()) {
            return chain.next().resolve(type, context, chain);
        }
        return null;
    }

    @Override
    public Schema resolveAnnotatedType(Type type, Annotated member, String elementName, ModelConverterContext context, Iterator<ModelConverter> chain) {
        if (chain.hasNext()) {
            return chain.next().resolveAnnotatedType(type, member, elementName, context, chain);
        }
        return null;
    }

    @Override
    public Schema resolve(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> chain) {
        if (chain.hasNext()) {
            return chain.next().resolve(type, context, annotations, chain);
        }
        return null;
    }

    protected String _typeName(JavaType type) {
        return this._typeName(type, null);
    }

    protected String _typeName(JavaType type, BeanDescription beanDesc) {
        String name = this._resolvedTypeNames.get(type);
        if (name != null) {
            return name;
        }
        name = this._findTypeName(type, beanDesc);
        this._resolvedTypeNames.put(type, name);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)String.format("_resolvedTypeNames.put(%s,%s), size=%d", type, name, this._resolvedTypeNames.keySet().size()), (Object[])new Object[0]);
        }
        return name;
    }

    protected String _findTypeName(JavaType type, BeanDescription beanDesc) {
        PropertyName rootName;
        if (type.isArrayType()) {
            return "Array";
        }
        if (beanDesc == null) {
            beanDesc = this._mapper.getSerializationConfig().introspectClassAnnotations(type);
        }
        if ((rootName = this._intr.findRootName(beanDesc.getClassInfo())) != null && rootName.hasSimpleName()) {
            return rootName.getSimpleName();
        }
        return this._typeNameResolver.nameForType(type, new TypeNameResolver.Options[0]);
    }

    protected String _typeQName(JavaType type) {
        return type.getRawClass().getName();
    }

    protected String _subTypeName(NamedType type) {
        return type.getType().getName();
    }

    protected boolean _isSetType(Class<?> cls) {
        if (cls != null) {
            if (Set.class.equals(cls)) {
                return true;
            }
            for (Class<?> a : cls.getInterfaces()) {
                if (!Set.class.equals(a) && !"interface scala.collection.Set".equals(a.toString())) continue;
                return true;
            }
        }
        return false;
    }
}

