/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.core.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.openapi.impl.core.converter.ModelConverters;
import com.ibm.ws.microprofile.openapi.impl.core.converter.ResolvedSchema;
import com.ibm.ws.microprofile.openapi.impl.core.util.AnnotationsUtils;
import com.ibm.ws.microprofile.openapi.impl.core.util.Json;
import com.ibm.ws.microprofile.openapi.impl.model.media.SchemaImpl;
import com.ibm.ws.microprofile.openapi.impl.model.parameters.ParameterImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.annotations.enums.Explode;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ParameterProcessor {
    public static final String MEDIA_TYPE = "*/*";
    static final long serialVersionUID = 3243372056748225007L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @FFDCIgnore(value={IOException.class})
    public static Parameter applyAnnotations(Parameter parameter, Type type, List<Annotation> annotations, Components components, String[] classTypes, String[] methodTypes) {
        AnnotationsHelper helper = new AnnotationsHelper(annotations, type);
        if (helper.isContext()) {
            return null;
        }
        if (parameter == null) {
            parameter = new ParameterImpl();
        }
        ArrayList<Annotation> reworkedAnnotations = new ArrayList<Annotation>(annotations);
        Annotation paramSchemaOrArrayAnnotation = ParameterProcessor.getParamSchemaAnnotation(annotations);
        org.eclipse.microprofile.openapi.models.media.Schema schemaFromAnn = null;
        if (paramSchemaOrArrayAnnotation != null) {
            reworkedAnnotations.add(paramSchemaOrArrayAnnotation);
            if (paramSchemaOrArrayAnnotation instanceof Schema) {
                Schema schemaAnn = (Schema)paramSchemaOrArrayAnnotation;
                schemaFromAnn = AnnotationsUtils.getSchema(schemaAnn, components).orElse(null);
            }
        }
        ResolvedSchema resolvedSchema = ModelConverters.getInstance().resolveAnnotatedType(type, reworkedAnnotations, "");
        if (resolvedSchema.schema != null) {
            if (schemaFromAnn != null) {
                if (schemaFromAnn.getAllOf() != null) {
                    resolvedSchema.schema.setAllOf(schemaFromAnn.getAllOf());
                    resolvedSchema.schema.setType(null);
                }
                if (schemaFromAnn.getAnyOf() != null) {
                    resolvedSchema.schema.setAnyOf(schemaFromAnn.getAnyOf());
                    resolvedSchema.schema.setType(null);
                }
                if (schemaFromAnn.getOneOf() != null) {
                    resolvedSchema.schema.setOneOf(schemaFromAnn.getOneOf());
                    resolvedSchema.schema.setType(null);
                }
                if (schemaFromAnn.getNot() != null) {
                    resolvedSchema.schema.setNot(schemaFromAnn.getNot());
                    resolvedSchema.schema.setType(null);
                }
            }
            parameter.setSchema(resolvedSchema.schema);
        }
        resolvedSchema.referencedSchemas.forEach((key, schema) -> components.addSchema(key, schema));
        for (Annotation annotation : annotations) {
            if (annotation instanceof org.eclipse.microprofile.openapi.annotations.parameters.Parameter) {
                Optional<Content> content;
                org.eclipse.microprofile.openapi.annotations.parameters.Parameter p = (org.eclipse.microprofile.openapi.annotations.parameters.Parameter)annotation;
                if (p.hidden()) {
                    return null;
                }
                if (StringUtils.isNotBlank((CharSequence)p.ref())) {
                    parameter.setRef(p.ref());
                }
                if (StringUtils.isNotBlank((CharSequence)p.description())) {
                    parameter.setDescription(p.description());
                }
                if (StringUtils.isNotBlank((CharSequence)p.name())) {
                    parameter.setName(p.name());
                }
                if (StringUtils.isNotBlank((CharSequence)p.in().toString())) {
                    ((ParameterImpl)parameter).setIn(Parameter.In.valueOf((String)p.in().toString().toUpperCase()));
                }
                if (StringUtils.isNotBlank((CharSequence)p.example())) {
                    try {
                        parameter.setExample((Object)Json.mapper().readTree(p.example()));
                    }
                    catch (IOException e) {
                        parameter.setExample((Object)p.example());
                    }
                }
                if (p.deprecated()) {
                    parameter.setDeprecated(Boolean.valueOf(p.deprecated()));
                }
                if (p.required()) {
                    parameter.setRequired(Boolean.valueOf(p.required()));
                }
                if (p.allowEmptyValue()) {
                    parameter.setAllowEmptyValue(Boolean.valueOf(p.allowEmptyValue()));
                }
                if (p.allowReserved()) {
                    parameter.setAllowReserved(Boolean.valueOf(p.allowReserved()));
                }
                HashMap exampleMap = new HashMap();
                for (ExampleObject exampleObject : p.examples()) {
                    AnnotationsUtils.getExample(exampleObject).ifPresent(example -> exampleMap.put(AnnotationsUtils.getNameOfReferenceableItem(exampleObject), example));
                }
                if (exampleMap.size() > 0) {
                    parameter.setExamples(exampleMap);
                }
                if ((content = AnnotationsUtils.getContent(p.content(), classTypes, methodTypes, parameter.getSchema())).isPresent()) {
                    parameter.setContent(content.get());
                    parameter.setSchema(null);
                }
                ParameterProcessor.setParameterStyle(parameter, p);
                ParameterProcessor.setParameterExplode(parameter, p);
                continue;
            }
            if (annotation.annotationType().getName().equals("javax.ws.rs.PathParam")) {
                try {
                    String name = (String)annotation.annotationType().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                    if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                    parameter.setName(name);
                }
                catch (Exception name) {
                    FFDCFilter.processException((Throwable)name, (String)"com.ibm.ws.microprofile.openapi.impl.core.util.ParameterProcessor", (String)"151", null, (Object[])new Object[]{parameter, type, annotations, components, classTypes, methodTypes});
                }
                continue;
            }
            if (!annotation.annotationType().getName().equals("javax.validation.constraints.Size")) continue;
            try {
                Integer max;
                if (parameter.getSchema() == null) {
                    parameter.setSchema(new SchemaImpl().type(Schema.SchemaType.ARRAY));
                }
                if (parameter.getSchema().getType() != Schema.SchemaType.ARRAY) continue;
                Integer min = (Integer)annotation.annotationType().getMethod("min", new Class[0]).invoke((Object)annotation, new Object[0]);
                if (min != null) {
                    parameter.getSchema().setMinItems(min);
                }
                if ((max = (Integer)annotation.annotationType().getMethod("max", new Class[0]).invoke((Object)annotation, new Object[0])) == null) continue;
                parameter.getSchema().setMaxItems(max);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.openapi.impl.core.util.ParameterProcessor", (String)"169", null, (Object[])new Object[]{parameter, type, annotations, components, classTypes, methodTypes});
            }
        }
        String defaultValue = helper.getDefaultValue();
        org.eclipse.microprofile.openapi.models.media.Schema paramSchema = parameter.getSchema();
        if (paramSchema == null && parameter.getContent() != null && parameter.getContent().values().size() > 0) {
            paramSchema = ((MediaType)parameter.getContent().values().iterator().next()).getSchema();
        }
        if (paramSchema != null) {
            if (paramSchema.getType() == Schema.SchemaType.ARRAY) {
                if (defaultValue != null) {
                    paramSchema.getItems().setDefaultValue((Object)defaultValue);
                }
            } else if (defaultValue != null) {
                paramSchema.setDefaultValue((Object)defaultValue);
            }
        }
        return parameter;
    }

    public static void setParameterExplode(Parameter parameter, org.eclipse.microprofile.openapi.annotations.parameters.Parameter p) {
        if (Explode.TRUE.equals((Object)p.explode())) {
            parameter.setExplode(Boolean.TRUE);
        } else if (Explode.FALSE.equals((Object)p.explode())) {
            parameter.setExplode(Boolean.FALSE);
        }
    }

    private static boolean isExplodable(org.eclipse.microprofile.openapi.annotations.parameters.Parameter p) {
        Class implementation;
        Schema schema = p.schema();
        boolean explode = true;
        if (schema != null && (implementation = schema.implementation()) == Void.class && !schema.type().equals((Object)"object") && !schema.type().equals((Object)"array")) {
            explode = false;
        }
        return explode;
    }

    public static void setParameterStyle(Parameter parameter, org.eclipse.microprofile.openapi.annotations.parameters.Parameter p) {
        if (StringUtils.isNotBlank((CharSequence)p.style().toString())) {
            parameter.setStyle(Parameter.Style.valueOf((String)p.style().toString().toUpperCase()));
        }
    }

    public static Annotation getParamSchemaAnnotation(List<Annotation> annotations) {
        if (annotations == null) {
            return null;
        }
        Schema rootSchema = null;
        Schema contentSchema = null;
        Schema paramSchema = null;
        for (Annotation annotation : annotations) {
            if (annotation instanceof Schema) {
                rootSchema = (Schema)annotation;
                continue;
            }
            if (!(annotation instanceof org.eclipse.microprofile.openapi.annotations.parameters.Parameter)) continue;
            org.eclipse.microprofile.openapi.annotations.parameters.Parameter paramAnnotation = (org.eclipse.microprofile.openapi.annotations.parameters.Parameter)annotation;
            if (paramAnnotation.content().length > 0 && AnnotationsUtils.hasSchemaAnnotation(paramAnnotation.content()[0].schema())) {
                contentSchema = paramAnnotation.content()[0].schema();
            }
            if (!AnnotationsUtils.hasSchemaAnnotation(paramAnnotation.schema())) continue;
            paramSchema = paramAnnotation.schema();
        }
        if (rootSchema != null) {
            return null;
        }
        if (contentSchema != null) {
            return contentSchema;
        }
        if (paramSchema != null) {
            return paramSchema;
        }
        return null;
    }

    public static Type getParameterType(org.eclipse.microprofile.openapi.annotations.parameters.Parameter paramAnnotation) {
        if (paramAnnotation == null) {
            return null;
        }
        Schema contentSchema = null;
        Schema paramSchema = null;
        if (paramAnnotation.content().length > 0 && AnnotationsUtils.hasSchemaAnnotation(paramAnnotation.content()[0].schema())) {
            contentSchema = paramAnnotation.content()[0].schema();
        }
        if (AnnotationsUtils.hasSchemaAnnotation(paramAnnotation.schema())) {
            paramSchema = paramAnnotation.schema();
        }
        if (contentSchema != null) {
            return AnnotationsUtils.getSchemaType(contentSchema);
        }
        if (paramSchema != null) {
            return AnnotationsUtils.getSchemaType(paramSchema);
        }
        return String.class;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ParameterProcessor.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class AnnotationsHelper {
        private boolean context;
        private final String defaultValue;
        static final long serialVersionUID = 6192525833764460555L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public AnnotationsHelper(List<Annotation> annotations, Type _type) {
            String rsDefault = null;
            if (annotations != null) {
                for (Annotation item : annotations) {
                    if ("javax.ws.rs.core.Context".equals(item.annotationType().getName())) {
                        this.context = true;
                        continue;
                    }
                    if (!"javax.ws.rs.DefaultValue".equals(item.annotationType().getName())) continue;
                    try {
                        rsDefault = (String)item.annotationType().getMethod("value", new Class[0]).invoke((Object)item, new Object[0]);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.openapi.impl.core.util.ParameterProcessor$AnnotationsHelper", (String)"315", (Object)this, (Object[])new Object[]{annotations, _type});
                    }
                }
            }
            this.defaultValue = rsDefault;
        }

        public boolean isContext() {
            return this.context;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AnnotationsHelper.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
        }
    }
}

