/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.parser.processors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.parser.ResolverCache;
import com.ibm.ws.microprofile.openapi.impl.parser.models.RefFormat;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.ExternalRefProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.SchemaProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.util.RefUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RequestBodyProcessor {
    private final SchemaProcessor schemaProcessor;
    private final ExternalRefProcessor externalRefProcessor;
    private final ResolverCache cache;
    private final OpenAPI openAPI;
    static final long serialVersionUID = -5506073143211644061L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public RequestBodyProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.schemaProcessor = new SchemaProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
        this.cache = cache;
        this.openAPI = openAPI;
    }

    public void processRequestBody(RequestBody requestBody) {
        if (requestBody.getRef() != null) {
            this.processReferenceRequestBody(requestBody);
        }
        Schema schema = null;
        if (requestBody.getContent() != null) {
            Content content = requestBody.getContent();
            for (String mediaName : content.keySet()) {
                MediaType mediaType = (MediaType)content.get(mediaName);
                if (mediaType.getSchema() == null || (schema = mediaType.getSchema()) == null) continue;
                this.schemaProcessor.processSchema(schema);
            }
        }
    }

    public void processReferenceRequestBody(RequestBody requestBody) {
        String newRef;
        RefFormat refFormat = RefUtils.computeRefFormat(requestBody.getRef());
        String $ref = requestBody.getRef();
        if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalRequestBody($ref, refFormat)) != null) {
            requestBody.setRef(newRef);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(RequestBodyProcessor.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    }
}

