/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.ws.sib.mfp.jmf.JMFMessageCorruptionException;
import com.ibm.ws.sib.mfp.jmf.JMFMessageData;
import com.ibm.ws.sib.mfp.jmf.JMFModelNotImplementedException;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFUninitializedAccessException;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.utils.RuntimeInfo;

public interface JSCoder {
    public static final int OBJECT_OVERHEAD = RuntimeInfo.is64bit() ? 24 : 12;
    public static final JSCoder BOOLEAN = new BooleanJSCoder();
    public static final JSCoder BYTE = new ByteJSCoder();
    public static final JSCoder SHORT = new ShortJSCoder();
    public static final JSCoder CHAR = new CharJSCoder();
    public static final JSCoder INT = new IntJSCoder();
    public static final JSCoder LONG = new LongJSCoder();
    public static final JSCoder FLOAT = new FloatJSCoder();
    public static final JSCoder DOUBLE = new DoubleJSCoder();

    public int getEncodedLength(Object var1, int var2, JMFMessageData var3) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException;

    public int encode(byte[] var1, int var2, Object var3, int var4, JMFMessageData var5) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException;

    public Object decode(byte[] var1, int var2, int var3, JMFMessageData var4) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException;

    public Object validate(Object var1, int var2) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException;

    public Object copy(Object var1, int var2) throws JMFSchemaViolationException;

    public int estimateUnassembledSize(Object var1);

    public int estimateUnassembledSize(byte[] var1, int var2);

    public static class DoubleJSCoder
    implements JSCoder {
        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) {
            return 8;
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException {
            if (val instanceof Double) {
                return val;
            }
            if (val == null) {
                throw new JMFSchemaViolationException("double==null");
            }
            throw new JMFSchemaViolationException(val.getClass().getName());
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) {
            if (val == null) {
                throw new NullPointerException();
            }
            ArrayUtil.writeLong(frame, offset, Double.doubleToLongBits(((Number)val).doubleValue()));
            return offset + 8;
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) {
            return new Double(Double.longBitsToDouble(ArrayUtil.readLong(frame, offset)));
        }

        @Override
        public Object copy(Object val, int indirect) {
            return val;
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            return OBJECT_OVERHEAD + 8;
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            return OBJECT_OVERHEAD + 8;
        }
    }

    public static class FloatJSCoder
    implements JSCoder {
        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) {
            return 4;
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException {
            if (val instanceof Float) {
                return val;
            }
            if (val == null) {
                throw new JMFSchemaViolationException("float==null");
            }
            throw new JMFSchemaViolationException(val.getClass().getName());
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) {
            if (val == null) {
                throw new NullPointerException();
            }
            ArrayUtil.writeInt(frame, offset, Float.floatToIntBits(((Number)val).floatValue()));
            return offset + 4;
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) {
            return new Float(Float.intBitsToFloat(ArrayUtil.readInt(frame, offset)));
        }

        @Override
        public Object copy(Object val, int indirect) {
            return val;
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            return OBJECT_OVERHEAD + 4;
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            return OBJECT_OVERHEAD + 4;
        }
    }

    public static class LongJSCoder
    implements JSCoder {
        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) {
            return 8;
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException {
            if (val instanceof Long) {
                return val;
            }
            if (val == null) {
                throw new JMFSchemaViolationException("long==null");
            }
            throw new JMFSchemaViolationException(val.getClass().getName());
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) {
            if (val == null) {
                throw new NullPointerException();
            }
            ArrayUtil.writeLong(frame, offset, ((Number)val).longValue());
            return offset + 8;
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) {
            return ArrayUtil.readLong(frame, offset);
        }

        @Override
        public Object copy(Object val, int indirect) {
            return val;
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            return OBJECT_OVERHEAD + 8;
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            return OBJECT_OVERHEAD + 8;
        }
    }

    public static class IntJSCoder
    implements JSCoder {
        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) {
            return 4;
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException {
            if (val instanceof Integer) {
                return val;
            }
            if (val == null) {
                throw new JMFSchemaViolationException("int==null");
            }
            throw new JMFSchemaViolationException(val.getClass().getName());
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) {
            if (val == null) {
                throw new NullPointerException();
            }
            ArrayUtil.writeInt(frame, offset, ((Number)val).intValue());
            return offset + 4;
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) {
            return ArrayUtil.readInt(frame, offset);
        }

        @Override
        public Object copy(Object val, int indirect) {
            return val;
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            return OBJECT_OVERHEAD + 4;
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            return OBJECT_OVERHEAD + 4;
        }
    }

    public static class CharJSCoder
    implements JSCoder {
        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) {
            return 2;
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException {
            if (val instanceof Character) {
                return val;
            }
            if (val == null) {
                throw new JMFSchemaViolationException("char==null");
            }
            throw new JMFSchemaViolationException(val.getClass().getName());
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) {
            if (val == null) {
                throw new NullPointerException();
            }
            ArrayUtil.writeShort(frame, offset, (short)((Character)val).charValue());
            return offset + 2;
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) {
            return Character.valueOf((char)ArrayUtil.readShort(frame, offset));
        }

        @Override
        public Object copy(Object val, int indirect) {
            return val;
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            return OBJECT_OVERHEAD + 2;
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            return OBJECT_OVERHEAD + 2;
        }
    }

    public static class ShortJSCoder
    implements JSCoder {
        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) {
            return 2;
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException {
            if (val instanceof Short) {
                return val;
            }
            if (val == null) {
                throw new JMFSchemaViolationException("short==null");
            }
            throw new JMFSchemaViolationException(val.getClass().getName());
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) {
            if (val == null) {
                throw new NullPointerException();
            }
            ArrayUtil.writeShort(frame, offset, ((Number)val).shortValue());
            return offset + 2;
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) {
            return ArrayUtil.readShort(frame, offset);
        }

        @Override
        public Object copy(Object val, int indirect) {
            return val;
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            return OBJECT_OVERHEAD + 2;
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            return OBJECT_OVERHEAD + 2;
        }
    }

    public static class ByteJSCoder
    implements JSCoder {
        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) {
            return 1;
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException {
            if (val instanceof Byte) {
                return val;
            }
            if (val == null) {
                throw new JMFSchemaViolationException("byte==null");
            }
            throw new JMFSchemaViolationException(val.getClass().getName());
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) {
            if (val == null) {
                throw new NullPointerException();
            }
            frame[offset] = ((Number)val).byteValue();
            return offset + 1;
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) {
            return frame[offset];
        }

        @Override
        public Object copy(Object val, int indirect) {
            return val;
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            return 0;
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            return 0;
        }
    }

    public static class BooleanJSCoder
    implements JSCoder {
        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) {
            return 1;
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException {
            if (val instanceof Boolean) {
                return val;
            }
            if (val == null) {
                throw new JMFSchemaViolationException("boolean==null");
            }
            throw new JMFSchemaViolationException(val.getClass().getName());
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) {
            if (val == null) {
                throw new NullPointerException();
            }
            frame[offset] = (byte)((Boolean)val != false ? 1 : 0);
            return offset + 1;
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) {
            return frame[offset] != 0;
        }

        @Override
        public Object copy(Object val, int indirect) {
            return val;
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            return 0;
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            return 0;
        }
    }
}

