/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.navigator;

import com.ibm.jbatch.container.jsl.impl.GlobPatternMatcherImpl;
import com.ibm.jbatch.container.jsl.impl.TransitionImpl;
import com.ibm.jbatch.container.navigator.IllegalTransitionException;
import com.ibm.jbatch.container.navigator.ModelNavigator;
import com.ibm.jbatch.container.status.ExecutionStatus;
import com.ibm.jbatch.container.status.ExtendedBatchStatus;
import com.ibm.jbatch.jsl.model.Decision;
import com.ibm.jbatch.jsl.model.End;
import com.ibm.jbatch.jsl.model.Fail;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.jbatch.jsl.model.Next;
import com.ibm.jbatch.jsl.model.Split;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.jbatch.jsl.model.Stop;
import com.ibm.jbatch.jsl.model.helper.ExecutionElement;
import com.ibm.jbatch.jsl.model.helper.Transition;
import com.ibm.jbatch.jsl.model.helper.TransitionElement;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public abstract class AbstractNavigatorImpl<T>
implements ModelNavigator<T> {
    private static final Logger logger = Logger.getLogger(AbstractNavigatorImpl.class.getName());
    private static final boolean disallowDecisionLoopback = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
        static final long serialVersionUID = -1486091436416081516L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public Boolean run() {
            return Boolean.getBoolean("disallow.decision.loopback");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class, (String)"wsbatch", null);
        }
    });
    private final Map<String, ExecutionElement> alreadyExecutedElements;
    static final long serialVersionUID = 5633709424956941670L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AbstractNavigatorImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "<init>", new Object[0]);
        }
        this.alreadyExecutedElements = new HashMap<String, ExecutionElement>();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExecutionElement getFirstExecutionElement(List<ExecutionElement> peerExecutionElements, String restartOn) throws IllegalTransitionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "getFirstExecutionElement", new Object[]{peerExecutionElements, restartOn});
        }
        String method = "getFirstExecutionElement";
        logger.fine("getFirstExecutionElement , restartOn = " + restartOn);
        ExecutionElement startElement = null;
        if (restartOn != null) {
            startElement = this.getExecutionElementFromId(peerExecutionElements, restartOn);
            if (startElement == null) {
                throw new IllegalStateException("Didn't find an execution element maching restart-on designated element: " + restartOn);
            }
        } else if (peerExecutionElements.size() > 0) {
            startElement = peerExecutionElements.get(0);
        } else {
            logger.fine("getFirstExecutionElement , Container appears to contain no execution elements.  Returning.");
            ExecutionElement executionElement = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                executionElement = executionElement;
                logger.exiting("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "getFirstExecutionElement", executionElement);
            }
            return executionElement;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getFirstExecutionElement , Found start element: " + startElement);
        }
        if (!disallowDecisionLoopback) {
            if (!(startElement instanceof Decision)) {
                this.alreadyExecutedElements.put(startElement.getId(), startElement);
            }
        } else {
            this.alreadyExecutedElements.put(startElement.getId(), startElement);
        }
        this.validateElementType(startElement);
        ExecutionElement executionElement = startElement;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            executionElement = executionElement;
            logger.exiting("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "getFirstExecutionElement", executionElement);
        }
        return executionElement;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Transition getNextTransition(ExecutionElement currentElem, List<ExecutionElement> peerExecutionElements, ExecutionStatus currentStatus) throws IllegalTransitionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "getNextTransition", new Object[]{currentElem, peerExecutionElements, currentStatus});
        }
        String method = "getNextTransition";
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getNextTransition ,currentStatus=" + currentStatus);
        }
        TransitionImpl returnTransition = new TransitionImpl();
        ExecutionElement nextExecutionElement = null;
        List<TransitionElement> transitionElements = currentElem.getTransitionElements();
        if (!transitionElements.isEmpty()) {
            if (currentElem instanceof Flow) {
                throw new IllegalStateException("Flow-level transition elements such as <next>, <stop>, <end>, <fail>, are not allowed, since the behavior is undefined by the specification.  Failing job.");
            }
            for (TransitionElement t : transitionElements) {
                logger.fine("getNextTransition Trying to match next transition element: " + t);
                boolean isMatched = this.matchExitStatusAgainstOnAttribute(currentStatus.getExitStatus(), t);
                if (!isMatched) continue;
                if (t instanceof Next) {
                    Next next = (Next)t;
                    nextExecutionElement = this.getExecutionElementFromId(peerExecutionElements, next.getTo());
                    returnTransition.setNextExecutionElement(nextExecutionElement);
                    break;
                }
                returnTransition.setTransitionElement(t);
                TransitionImpl transitionImpl = returnTransition;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    transitionImpl = transitionImpl;
                    logger.exiting("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "getNextTransition", transitionImpl);
                }
                return transitionImpl;
            }
        }
        if (nextExecutionElement == null) {
            if (currentStatus.getExtendedBatchStatus().equals((Object)ExtendedBatchStatus.EXCEPTION_THROWN)) {
                logger.fine("Didn't match transition element, after exception thrown.  Need to fail job");
                returnTransition.setNoTransitionElementMatchAfterException();
                TransitionImpl transitionImpl = returnTransition;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    transitionImpl = transitionImpl;
                    logger.exiting("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "getNextTransition", transitionImpl);
                }
                return transitionImpl;
            }
            logger.fine("Didn't match transition element, check @next attribute now.");
            nextExecutionElement = this.getNextExecutionElemFromAttribute(peerExecutionElements, currentElem);
            returnTransition.setNextExecutionElement(nextExecutionElement);
        }
        if (nextExecutionElement != null) {
            if (this.alreadyExecutedElements.containsKey(nextExecutionElement.getId())) {
                String errorMsg = "Execution loop detected !!!  Trying to re-execute execution element: " + nextExecutionElement.getId();
                throw new IllegalTransitionException(errorMsg);
            }
            if (!disallowDecisionLoopback) {
                if (!(nextExecutionElement instanceof Decision)) {
                    this.alreadyExecutedElements.put(nextExecutionElement.getId(), nextExecutionElement);
                }
            } else {
                this.alreadyExecutedElements.put(nextExecutionElement.getId(), nextExecutionElement);
            }
            logger.fine("getNextTransition Transitioning to next element id = " + nextExecutionElement.getId());
        } else {
            logger.fine("getNextTransition There is no next execution element. Mark transition to show we're finished.");
            returnTransition.setFinishedTransitioning();
        }
        TransitionImpl transitionImpl = returnTransition;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            transitionImpl = transitionImpl;
            logger.exiting("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "getNextTransition", transitionImpl);
        }
        return transitionImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ExecutionElement getExecutionElementFromId(List<ExecutionElement> executionElements, String id) throws IllegalTransitionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "getExecutionElementFromId", new Object[]{executionElements, id});
        }
        if (id != null) {
            logger.finer("attribute value is " + id);
            for (ExecutionElement elem : executionElements) {
                if (!elem.getId().equals(id)) continue;
                this.validateElementType(elem);
                ExecutionElement executionElement = elem;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    executionElement = executionElement;
                    logger.exiting("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "getExecutionElementFromId", executionElement);
                }
                return executionElement;
            }
            throw new IllegalTransitionException("No execution element found with id = " + id);
        }
        logger.finer("attribute value is <null>, so simply exiting...");
        ExecutionElement executionElement = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            executionElement = executionElement;
            logger.exiting("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "getExecutionElementFromId", executionElement);
        }
        return executionElement;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean matchSpecifiedExitStatus(String currentStepExitStatus, String exitStatusPattern) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "matchSpecifiedExitStatus", new Object[]{currentStepExitStatus, exitStatusPattern});
        }
        logger.finer("matchSpecifiedExitStatus, matching current exitStatus  " + currentStepExitStatus + " against pattern: " + exitStatusPattern);
        GlobPatternMatcherImpl matcher = new GlobPatternMatcherImpl();
        boolean match = matcher.matchWithoutBackslashEscape(currentStepExitStatus, exitStatusPattern);
        if (match) {
            logger.finer("matchSpecifiedExitStatus, match=YES");
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "matchSpecifiedExitStatus", bl);
            }
            return bl;
        }
        logger.finer("matchSpecifiedExitStatus, match=NO");
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "matchSpecifiedExitStatus", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean matchExitStatusAgainstOnAttribute(String exitStatus, TransitionElement elem) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "matchExitStatusAgainstOnAttribute", new Object[]{exitStatus, elem});
        }
        logger.fine("Trying to match exitStatus = " + exitStatus + " , against transition element: " + elem);
        String exitStatusToMatch = null;
        if (elem instanceof End) {
            exitStatusToMatch = ((End)elem).getOn();
        } else {
            if (elem instanceof Fail) {
                exitStatusToMatch = ((Fail)elem).getOn();
                boolean bl = AbstractNavigatorImpl.matchSpecifiedExitStatus(exitStatus, exitStatusToMatch);
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "matchExitStatusAgainstOnAttribute", bl);
                }
                return bl;
            }
            if (elem instanceof Stop) {
                exitStatusToMatch = ((Stop)elem).getOn();
            } else if (elem instanceof Next) {
                exitStatusToMatch = ((Next)elem).getOn();
            } else {
                throw new IllegalStateException("Shouldn't be possible to get here. Unknown transition element,  " + elem.toString());
            }
        }
        boolean match = AbstractNavigatorImpl.matchSpecifiedExitStatus(exitStatus, exitStatusToMatch);
        String logMsg = match ? "Matched" : "Didn't match";
        logger.fine(logMsg);
        boolean bl = match;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "matchExitStatusAgainstOnAttribute", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ExecutionElement getNextExecutionElemFromAttribute(List<ExecutionElement> peerExecutionElements, ExecutionElement currentElem) throws IllegalTransitionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "getNextExecutionElemFromAttribute", new Object[]{peerExecutionElements, currentElem});
        }
        ExecutionElement nextExecutionElement = null;
        String nextAttrId = null;
        if (currentElem instanceof Step) {
            nextAttrId = ((Step)currentElem).getNextFromAttribute();
            nextExecutionElement = this.getExecutionElementFromId(peerExecutionElements, nextAttrId);
        } else if (currentElem instanceof Split) {
            nextAttrId = ((Split)currentElem).getNextFromAttribute();
            nextExecutionElement = this.getExecutionElementFromId(peerExecutionElements, nextAttrId);
        } else if (currentElem instanceof Flow) {
            nextAttrId = ((Flow)currentElem).getNextFromAttribute();
            nextExecutionElement = this.getExecutionElementFromId(peerExecutionElements, nextAttrId);
        } else if (currentElem instanceof Decision) {
            // empty if block
        }
        this.validateElementType(nextExecutionElement);
        logger.fine("From currentElem = " + currentElem + " , return @next attribute execution element: " + nextExecutionElement);
        ExecutionElement executionElement = nextExecutionElement;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            executionElement = executionElement;
            logger.exiting("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "getNextExecutionElemFromAttribute", executionElement);
        }
        return executionElement;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExecutionElement getFirstExecutionElement() throws IllegalTransitionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "getFirstExecutionElement", new Object[0]);
        }
        ExecutionElement executionElement = this.getFirstExecutionElement(null);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            executionElement = executionElement;
            logger.exiting("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "getFirstExecutionElement", executionElement);
        }
        return executionElement;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void validateElementType(ExecutionElement elem) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "validateElementType", new Object[]{elem});
        }
        if (!(elem == null || elem instanceof Decision || elem instanceof Flow || elem instanceof Split || elem instanceof Step)) {
            throw new IllegalArgumentException("Unknown execution element found, elem = " + elem + ", found with type: " + elem.getClass().getCanonicalName() + " , which is not an instance of Decision, Flow, Split, or Step.");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.navigator.AbstractNavigatorImpl", "validateElementType");
        }
    }
}

