/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.persistence.jpa;

import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionEntity;
import com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntity;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Serializable;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RemotablePartitionKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long jobExec;
    private String stepName;
    private int partitionNumber;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public RemotablePartitionKey(long jobExecutionId, String stepName, Integer partitionNumber) {
        this.jobExec = jobExecutionId;
        this.stepName = stepName;
        this.partitionNumber = partitionNumber;
    }

    public RemotablePartitionKey(StepThreadExecutionEntity stepExecution) {
        this.jobExec = stepExecution.getJobExecution().getExecutionId();
        this.stepName = stepExecution.getStepName();
        this.partitionNumber = stepExecution.getPartitionNumber();
    }

    public RemotablePartitionKey(RemotablePartitionEntity partition) {
        this.jobExec = partition.getJobExecution().getExecutionId();
        this.stepName = partition.getStepName();
        this.partitionNumber = partition.getPartitionNumber();
    }

    public int hashCode() {
        return (new Long(this.jobExec).intValue() + this.partitionNumber + this.stepName.hashCode()) / 37;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RemotablePartitionKey)) {
            return false;
        }
        RemotablePartitionKey pk = (RemotablePartitionKey)obj;
        return pk.stepName.equals(this.stepName) && pk.partitionNumber == this.partitionNumber && pk.jobExec == this.jobExec;
    }

    public String getStepName() {
        return this.stepName;
    }

    public int getPartitionNumber() {
        return this.partitionNumber;
    }

    public long getJobExec() {
        return this.jobExec;
    }

    public String toString() {
        return "RemotablePartitionKey [job execution id=" + this.jobExec + ", step name=" + this.stepName + ", partition number=" + this.partitionNumber + "]";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(RemotablePartitionKey.class, (String)"wsbatch", null);
    }
}

