/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.RASConstants;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.services.IJobXMLSource;
import com.ibm.jbatch.container.services.impl.JobXMLSource;
import com.ibm.jbatch.container.ws.BatchSubmitInvalidParametersException;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.jbatch.spi.services.IJobXMLLoaderService;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.stream.StreamSource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class DelegatingJobXMLLoaderServiceImpl
implements IJobXMLLoaderService,
RASConstants {
    private static final String CLASSNAME = DelegatingJobXMLLoaderServiceImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME, "com.ibm.jbatch.container.internal.resources.JBatchMessages");
    protected IJobXMLLoaderService preferredJobXmlLoader;
    public static final String PREFIX = "META-INF/batch-jobs/";
    static final long serialVersionUID = -8916264604307304456L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DelegatingJobXMLLoaderServiceImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.DelegatingJobXMLLoaderServiceImpl", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.DelegatingJobXMLLoaderServiceImpl", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IJobXMLSource loadJSL(String id) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.DelegatingJobXMLLoaderServiceImpl", "loadJSL", new Object[]{id});
        }
        IJobXMLSource jobXML = null;
        if (this.preferredJobXmlLoader != null && !this.preferredJobXmlLoader.getClass().equals(this.getClass())) {
            jobXML = this.preferredJobXmlLoader.loadJSL(id);
        } else if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "No preferred job xml loader is detected in configuration");
        }
        if (jobXML != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Preferred job xml loader loaded job with id " + id + ".");
            }
            IJobXMLSource iJobXMLSource = jobXML;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                iJobXMLSource = iJobXMLSource;
                logger.exiting("com.ibm.jbatch.container.services.impl.DelegatingJobXMLLoaderServiceImpl", "loadJSL", iJobXMLSource);
            }
            return iJobXMLSource;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Preferred job xml loader failed to load " + id + ". Defaulting to " + PREFIX);
        }
        jobXML = this.loadJobFromMetaInfBatchJobs(id);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Loaded job xml with " + id + " from " + PREFIX);
        }
        IJobXMLSource iJobXMLSource = jobXML;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iJobXMLSource = iJobXMLSource;
            logger.exiting("com.ibm.jbatch.container.services.impl.DelegatingJobXMLLoaderServiceImpl", "loadJSL", iJobXMLSource);
        }
        return iJobXMLSource;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private IJobXMLSource loadJobFromMetaInfBatchJobs(String id) {
        JobXMLSource jslSource;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.DelegatingJobXMLLoaderServiceImpl", "loadJobFromMetaInfBatchJobs", new Object[]{id});
        }
        ClassLoader tccl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = -2446052152223617722L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"wsbatch", null);
            }
        });
        String relativePath = PREFIX + id + ".xml";
        StreamSource strSource = null;
        logger.fine("looking up batch job xml at " + relativePath);
        URL url = tccl.getResource(relativePath);
        if (url == null && id.endsWith(".xml")) {
            String path = PREFIX + id;
            logger.fine("looking up batch job xml at " + path);
            url = tccl.getResource(path);
        }
        if (url != null) {
            try {
                strSource = new StreamSource(url.openStream());
            }
            catch (IOException path) {
                void e;
                FFDCFilter.processException((Throwable)path, (String)"com.ibm.jbatch.container.services.impl.DelegatingJobXMLLoaderServiceImpl", (String)"114", (Object)this, (Object[])new Object[]{id});
                String excMessage = "IOException on URL at relativePath: " + relativePath + ",  on openStream(), message: " + e.getMessage();
                logger.fine(excMessage);
                throw new BatchSubmitInvalidParametersException(excMessage, (Throwable)e);
            }
        } else {
            String excMessage = "Resource not found at relativePath: " + relativePath;
            logger.log(Level.SEVERE, "jsl.not.found.batch-jobs", new Object[]{id, relativePath});
            throw new BatchSubmitInvalidParametersException(excMessage);
        }
        strSource.setSystemId(url.toExternalForm());
        JobXMLSource jobXMLSource = jslSource = new JobXMLSource(url, strSource);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobXMLSource = jobXMLSource;
            logger.exiting("com.ibm.jbatch.container.services.impl.DelegatingJobXMLLoaderServiceImpl", "loadJobFromMetaInfBatchJobs", jobXMLSource);
        }
        return jobXMLSource;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.DelegatingJobXMLLoaderServiceImpl", "init", new Object[]{batchConfig});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.DelegatingJobXMLLoaderServiceImpl", "init");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void shutdown() throws BatchContainerServiceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.DelegatingJobXMLLoaderServiceImpl", "shutdown", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.DelegatingJobXMLLoaderServiceImpl", "shutdown");
        }
    }
}

