/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.util;

import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.IllegalBatchPropertyException;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.BatchProperty;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class DependencyInjectionUtility {
    private static final String sourceClass = DependencyInjectionUtility.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    static final long serialVersionUID = -7948364001981197652L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DependencyInjectionUtility() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.util.DependencyInjectionUtility", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.util.DependencyInjectionUtility", "<init>", this);
        }
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void injectReferences(Object artifact, InjectionReferences injectionRefs) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Injecting references into: " + artifact);
            logger.fine("InjectionReferences = " + injectionRefs);
        }
        Map<String, Field> propertyMap = DependencyInjectionUtility.findPropertyFields(artifact);
        if (injectionRefs.getProps() != null) {
            DependencyInjectionUtility.injectProperties(artifact, injectionRefs.getProps(), propertyMap);
        }
        DependencyInjectionUtility.injectBatchContextFields(artifact, injectionRefs.getJobContext(), injectionRefs.getStepContext());
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(sourceClass, "injectReferences");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void injectProperties(Object artifact, List<Property> props, Map<String, Field> propertyFieldMap) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.util.DependencyInjectionUtility", "injectProperties", new Object[]{artifact, props, propertyFieldMap});
        }
        if (props == null || propertyFieldMap == null) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.jbatch.container.util.DependencyInjectionUtility", "injectProperties");
            }
            return;
        }
        for (Map.Entry<String, Field> batchProperty : propertyFieldMap.entrySet()) {
            String propValue = DependencyInjectionUtility.getPropertyValue(props, batchProperty.getKey().split("::")[1]);
            try {
                if (propValue == null) continue;
                batchProperty.getValue().set(artifact, propValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                void e;
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.jbatch.container.util.DependencyInjectionUtility", (String)"99", null, (Object[])new Object[]{artifact, props, propertyFieldMap});
                throw new IllegalBatchPropertyException("The given property value is not an instance of the declared field.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.util.DependencyInjectionUtility", (String)"101", null, (Object[])new Object[]{artifact, props, propertyFieldMap});
                throw new BatchContainerRuntimeException(e);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.util.DependencyInjectionUtility", "injectProperties");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getPropertyValue(List<Property> props, String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.util.DependencyInjectionUtility", "getPropertyValue", new Object[]{props, name});
        }
        if (props == null) {
            String string = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.jbatch.container.util.DependencyInjectionUtility", "getPropertyValue", string);
            }
            return string;
        }
        for (Property prop : props) {
            if (!name.equals(prop.getName())) continue;
            String propValue = prop.getValue();
            if ("".equals(propValue)) {
                String string = null;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string = string;
                    logger.exiting("com.ibm.jbatch.container.util.DependencyInjectionUtility", "getPropertyValue", string);
                }
                return string;
            }
            String string = propValue;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.jbatch.container.util.DependencyInjectionUtility", "getPropertyValue", string);
            }
            return string;
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.util.DependencyInjectionUtility", "getPropertyValue", string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void injectBatchContextFields(Object artifact, JobContext jobCtx, StepContext stepCtx) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.util.DependencyInjectionUtility", "injectBatchContextFields", new Object[]{artifact, jobCtx, stepCtx});
        }
        for (final Field field : DependencyInjectionUtility.getAllFields(artifact)) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){
                static final long serialVersionUID = -6894027280465346243L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() {
                    field.setAccessible(true);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, null, null);
                }
            });
            Inject injectAnnotation = field.getAnnotation(Inject.class);
            logger.log(Level.FINER, "@Inject annotation on (Object, field) ", new Object[]{artifact, field.getName(), injectAnnotation});
            if (injectAnnotation == null) continue;
            try {
                if (JobContext.class.isAssignableFrom(field.getType())) {
                    field.set(artifact, jobCtx);
                    continue;
                }
                if (!StepContext.class.isAssignableFrom(field.getType())) continue;
                field.set(artifact, stepCtx);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                void e;
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.jbatch.container.util.DependencyInjectionUtility", (String)"165", null, (Object[])new Object[]{artifact, jobCtx, stepCtx});
                throw new BatchContainerRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.util.DependencyInjectionUtility", (String)"167", null, (Object[])new Object[]{artifact, jobCtx, stepCtx});
                throw new BatchContainerRuntimeException(e);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.util.DependencyInjectionUtility", "injectBatchContextFields");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Map<String, Field> findPropertyFields(Object delegate) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.util.DependencyInjectionUtility", "findPropertyFields", new Object[]{delegate});
        }
        HashMap<String, Field> propertyMap = null;
        for (final Field field : DependencyInjectionUtility.getAllFields(delegate)) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){
                static final long serialVersionUID = -2592535613647504510L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() {
                    field.setAccessible(true);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class, null, null);
                }
            });
            BatchProperty batchPropertyAnnotation = field.getAnnotation(BatchProperty.class);
            if (batchPropertyAnnotation == null) continue;
            if (propertyMap == null) {
                propertyMap = new HashMap<String, Field>();
            }
            String batchPropName = null;
            batchPropName = batchPropertyAnnotation.name().equals("") ? field.getDeclaringClass().getName() + "::" + field.getName() : field.getDeclaringClass().getName() + "::" + batchPropertyAnnotation.name();
            if (propertyMap.containsKey(batchPropName)) {
                throw new IllegalBatchPropertyException("There is already a batch property with this name: " + batchPropName);
            }
            propertyMap.put(batchPropName, field);
        }
        HashMap<String, Field> hashMap = propertyMap;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            hashMap = hashMap;
            logger.exiting("com.ibm.jbatch.container.util.DependencyInjectionUtility", "findPropertyFields", hashMap);
        }
        return hashMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Field[] getAllFields(Object delegate) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.util.DependencyInjectionUtility", "getAllFields", new Object[]{delegate});
        }
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(delegate.getClass().getDeclaredFields()));
        for (Class<?> superClass = delegate.getClass().getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            Field[] parentFields;
            if (superClass == null || (parentFields = superClass.getDeclaredFields()).length == 0) continue;
            fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
        }
        Field[] fieldArray = fields.toArray(new Field[fields.size()]);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            fieldArray = fieldArray;
            logger.exiting("com.ibm.jbatch.container.util.DependencyInjectionUtility", "getAllFields", fieldArray);
        }
        return fieldArray;
    }
}

