/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.Constants;
import com.ibm.ws.security.social.error.SocialLoginException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SocialUtil {
    private static final TraceComponent tc = Tr.register(SocialUtil.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    static final char[] chars = Constants.CHARS;
    static final String[] numberFiller = new String[]{"00000000", "0000000", "000000", "00000", "0000", "000", "00", "0", ""};
    static final String JCEPROVIDER_IBM = "IBMJCE";
    static final String SECRANDOM_IBM = "IBMSecureRandom";
    static final String SECRANDOM_SHA1PRNG = "SHA1PRNG";
    static final long serialVersionUID = -4696892494356182972L;

    @Trivial
    public static String hash(String stringToEncrypt) {
        int hashCode = stringToEncrypt.hashCode();
        if (hashCode < 0) {
            return "n" + (hashCode *= -1);
        }
        return "p" + hashCode;
    }

    @Trivial
    public static String generateRandomID() {
        return "_" + SocialUtil.generateRandom(32);
    }

    @Trivial
    public static String generateRandom() {
        return SocialUtil.generateRandom(32);
    }

    @Trivial
    public static String generateRandom(int iCharCnt) {
        StringBuffer sb = new StringBuffer();
        Random r = SocialUtil.getRandom();
        for (int i = 0; i < iCharCnt; ++i) {
            sb.append(chars[r.nextInt(chars.length)]);
        }
        return sb.toString();
    }

    @Trivial
    public static String generateRandomNumber() {
        Random r = SocialUtil.getRandom();
        int iNum = r.nextInt(100000000);
        String tmp = "" + iNum;
        return numberFiller[tmp.length()] + tmp;
    }

    @Trivial
    static Random getRandom() {
        Random result = null;
        try {
            result = Security.getProvider(JCEPROVIDER_IBM) != null ? SecureRandom.getInstance(SECRANDOM_IBM) : SecureRandom.getInstance(SECRANDOM_SHA1PRNG);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.internal.utils.SocialUtil", (String)"122", null, (Object[])new Object[0]);
            result = new Random();
        }
        return result;
    }

    public static QName cloneQName(QName qName) {
        if (qName == null) {
            return null;
        }
        return new QName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix());
    }

    public static WSCredential getWSCredential(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<WSCredential> credentials = subject.getPublicCredentials(WSCredential.class);
        return credentials.iterator().next();
    }

    public static boolean sameUser(String realmName, String userId, String cRealmName, String cUserId) {
        if (realmName == null ? cRealmName != null : !realmName.equals(cRealmName)) {
            return false;
        }
        if (userId == null) {
            return false;
        }
        return userId.equals(cUserId);
    }

    public static boolean sameUser(String userName, String accessId) {
        if (userName == null) {
            return false;
        }
        return userName.equals(accessId);
    }

    public static boolean validateQueryString(String query) {
        if (query == null) {
            return true;
        }
        return Pattern.matches("[a-zA-Z0-9._~%!$&'()*+,;=:@/?-]*", query);
    }

    public static void validateEndpointFormat(String endpointUrl) throws SocialLoginException {
        SocialUtil.validateEndpointFormat(endpointUrl, true);
    }

    /*
     * WARNING - void declaration
     */
    public static void validateEndpointFormat(final String endpointUrl, boolean isHttp) throws SocialLoginException {
        String httpPrefix;
        if (endpointUrl == null || endpointUrl.isEmpty()) {
            throw new SocialLoginException("NULL_OR_EMPTY_REQUEST_URL", null, new Object[0]);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<URI>(){
                static final long serialVersionUID = -8247929799894419786L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public URI run() throws URISyntaxException {
                    return new URI(endpointUrl);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, null, null);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.social.internal.utils.SocialUtil", (String)"207", null, (Object[])new Object[]{endpointUrl, isHttp});
            throw new SocialLoginException("EXCEPTION_INITIALIZING_URL", null, new Object[]{endpointUrl, e.getException().getLocalizedMessage()});
        }
        String prefix = httpPrefix = "https?://";
        if (isHttp) {
            if (!Pattern.matches(prefix + ".*", endpointUrl)) {
                throw new SocialLoginException("HTTP_URI_DOES_NOT_START_WITH_HTTP", null, new Object[]{endpointUrl});
            }
        } else {
            prefix = "(?:" + httpPrefix + ")?";
        }
        if (!Pattern.matches(prefix + "[a-zA-Z0-9._~%!$&'()*+,;=:@/-]" + "+", endpointUrl)) {
            throw new SocialLoginException("URI_CONTAINS_INVALID_CHARS", null, new Object[]{endpointUrl});
        }
    }

    public static void validateEndpointWithQuery(String endpointUrl) throws SocialLoginException {
        if (endpointUrl == null || !endpointUrl.contains("?")) {
            SocialUtil.validateEndpointFormat(endpointUrl);
            return;
        }
        String mainUrl = endpointUrl.substring(0, endpointUrl.indexOf("?"));
        SocialUtil.validateEndpointFormat(mainUrl);
        String query = endpointUrl.substring(endpointUrl.indexOf("?") + 1);
        if (!SocialUtil.validateQueryString(query)) {
            throw new SocialLoginException("EXCEPTION_INITIALIZING_URL", null, new Object[]{endpointUrl, ""});
        }
    }
}

