/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.internal.literals;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jndi.internal.literals.Patterns;
import com.ibm.ws.jndi.internal.literals.StringParser;
import java.math.BigInteger;
import java.util.regex.Pattern;

enum LiteralType {
    BOOLEAN_TRUE("true"){

        @Override
        Object parse(String s) {
            return true;
        }
    }
    ,
    BOOLEAN_FALSE("false"){

        @Override
        Object parse(String s) {
            return false;
        }
    }
    ,
    CHARACTER("'.*"){

        @Override
        Object parse(String s) {
            return StringParser.parseChar(s);
        }
    }
    ,
    DOUBLE(Patterns.DOUBLE){

        @Override
        Object parse(String s) {
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse double", (Object[])new Object[]{s});
                }
                return s;
            }
        }
    }
    ,
    FLOAT(Patterns.FLOAT){

        @Override
        Object parse(String s) {
            try {
                return Float.valueOf(s);
            }
            catch (NumberFormatException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse float", (Object[])new Object[]{s});
                }
                return s;
            }
        }
    }
    ,
    INTEGER_BINARY("0[Bb][01](?:_*[01]){0,31}"){

        @Override
        Object parse(String s) {
            s = s.replaceAll("_*", "").substring(2);
            try {
                return LiteralType.parseUnsigned(s, 2, 6.MAX_UNSIGNED_INTEGER).intValue();
            }
            catch (NumberFormatException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse binary int", (Object[])new Object[]{s});
                }
                return s;
            }
        }
    }
    ,
    INTEGER_OCTAL("0(?:_*[0-7]){1,11}"){

        @Override
        Object parse(String s) {
            s = s.replaceAll("_*", "");
            try {
                return LiteralType.parseUnsigned(s, 8, 7.MAX_UNSIGNED_INTEGER).intValue();
            }
            catch (NumberFormatException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse octal int", (Object[])new Object[]{s});
                }
                return s;
            }
        }
    }
    ,
    INTEGER_DENARY("[+-]?(0|[1-9](?:_*[0-9]){0,9})"){

        @Override
        Object parse(String s) {
            s = s.replaceAll("_*", "");
            try {
                return Integer.valueOf(s);
            }
            catch (NumberFormatException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse int", (Object[])new Object[]{s});
                }
                return s;
            }
        }
    }
    ,
    INTEGER_HEX("0[Xx][0-9A-Fa-f](?:_*[0-9A-Fa-f]){0,7}"){

        @Override
        Object parse(String s) {
            s = s.replaceAll("_*", "").substring(2);
            try {
                return LiteralType.parseUnsigned(s, 16, 9.MAX_UNSIGNED_INTEGER).intValue();
            }
            catch (NumberFormatException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse hex int", (Object[])new Object[]{s});
                }
                return s;
            }
        }
    }
    ,
    LONG_BINARY("0[Bb][01](?:_*[01]){0,63}[Ll]"){

        @Override
        Object parse(String s) {
            s = s.replaceAll("_*", "").replaceAll("[Ll]$", "").substring(2);
            try {
                return LiteralType.parseUnsigned(s, 2, 10.MAX_UNSIGNED_LONG).longValue();
            }
            catch (NumberFormatException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse binary long", (Object[])new Object[]{s});
                }
                return s;
            }
        }
    }
    ,
    LONG_OCTAL("0(?:_*[0-7]){1,23}[Ll]"){

        @Override
        Object parse(String s) {
            s = s.replaceAll("_*", "").replaceAll("[Ll]$", "");
            try {
                return LiteralType.parseUnsigned(s, 8, 11.MAX_UNSIGNED_LONG).longValue();
            }
            catch (NumberFormatException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse octal long", (Object[])new Object[]{s});
                }
                return s;
            }
        }
    }
    ,
    LONG_DENARY("[+-]?(0|[1-9](?:_*[0-9]){0,18})[Ll]"){

        @Override
        Object parse(String s) {
            s = s.replaceAll("_*", "").replaceAll("[Ll]$", "");
            try {
                return Long.valueOf(s);
            }
            catch (NumberFormatException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse long", (Object[])new Object[]{s});
                }
                return s;
            }
        }
    }
    ,
    LONG_HEX("0[Xx][0-9A-Fa-f](?:_*[0-9A-Fa-f]){0,15}[Ll]"){

        @Override
        Object parse(String s) {
            s = s.replaceAll("_*", "").replaceAll("[Ll]$", "").substring(2);
            try {
                return LiteralType.parseUnsigned(s, 16, 13.MAX_UNSIGNED_LONG).longValue();
            }
            catch (NumberFormatException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse hex long", (Object[])new Object[]{s});
                }
                return s;
            }
        }
    }
    ,
    STRING("\".*"){

        @Override
        Object parse(String s) {
            return StringParser.parse(s);
        }
    };

    static final TraceComponent tc;
    static final BigInteger MAX_UNSIGNED_INTEGER;
    static final BigInteger MAX_UNSIGNED_LONG;
    final Pattern pattern;

    private LiteralType(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    boolean matches(String s) {
        return this.pattern.matcher(s).matches();
    }

    abstract Object parse(String var1);

    private static BigInteger parseUnsigned(String s, int radix, BigInteger maxValue) {
        BigInteger i = new BigInteger(s, radix);
        if (i.compareTo(BigInteger.ZERO) < 0 || i.compareTo(maxValue) > 0) {
            throw new NumberFormatException();
        }
        return i;
    }

    static {
        tc = Tr.register(LiteralType.class);
        MAX_UNSIGNED_INTEGER = new BigInteger("2").pow(32).subtract(BigInteger.ONE);
        MAX_UNSIGNED_LONG = new BigInteger("2").pow(64).subtract(BigInteger.ONE);
    }
}

