/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.metrics.cdi.producer.MetricRegistryFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.astefanutti.metrics.cdi.MetricResolver;
import io.astefanutti.metrics.cdi.MetricsBinding;
import io.astefanutti.metrics.cdi.MetricsExtension;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Timed;

@Interceptor
@MetricsBinding
@Priority(value=1000)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class MetricsInterceptor {
    private static final TraceComponent tc = Tr.register(MetricsInterceptor.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.cdi.resources.MetricsCDI");
    private final MetricRegistry registry;
    private final MetricResolver resolver;
    private final MetricsExtension extension;
    static final long serialVersionUID = -2511638721322993980L;

    @Inject
    private MetricsInterceptor(MetricRegistry registry, MetricResolver resolver, MetricsExtension extension) {
        this.registry = registry;
        this.resolver = resolver;
        this.extension = extension;
    }

    @AroundConstruct
    private Object metrics(InvocationContext context) throws Exception {
        Class bean = context.getConstructor().getDeclaringClass();
        if (!this.extension.getBeansVisited().contains(bean)) {
            this.extension.getBeansVisited().add(bean);
            this.registerMetrics(bean, context.getConstructor());
            Class type = bean;
            do {
                for (Method method : MetricsInterceptor.getDeclaredMethods(type)) {
                    if (method.isSynthetic() || Modifier.isPrivate(method.getModifiers())) continue;
                    this.registerMetrics(bean, method);
                }
            } while (!Object.class.equals(type = type.getSuperclass()));
        }
        Object target = context.proceed();
        Class type = bean;
        do {
            for (Method method : MetricsInterceptor.getDeclaredMethods(type)) {
                MetricResolver.Of<org.eclipse.microprofile.metrics.annotation.Gauge> gauge = this.resolver.gauge(bean, method);
                if (!gauge.isPresent()) continue;
                this.registry.register(gauge.metricName(), (Metric)new ForwardingGauge(method, context.getTarget()), gauge.metadata());
                this.extension.addMetricName(gauge.metricName());
            }
        } while (!Object.class.equals(type = type.getSuperclass()));
        return target;
    }

    private <E extends Member & AnnotatedElement> void registerMetrics(Class<?> bean, E element) {
        MetricResolver.Of<Timed> timed;
        MetricResolver.Of<Metered> metered;
        MetricResolver.Of<Counted> counted = this.resolver.counted(bean, element);
        if (counted.isPresent()) {
            this.registry.counter(counted.metadata());
            this.extension.addMetricName(element, (Annotation)counted.metricAnnotation(), counted.metadata().getName());
        }
        if ((metered = this.resolver.metered(bean, element)).isPresent()) {
            this.registry.meter(metered.metadata());
            this.extension.addMetricName(element, (Annotation)metered.metricAnnotation(), metered.metadata().getName());
        }
        if ((timed = this.resolver.timed(bean, element)).isPresent()) {
            this.registry.timer(timed.metadata());
            this.extension.addMetricName(element, (Annotation)timed.metricAnnotation(), timed.metadata().getName());
        }
    }

    @FFDCIgnore(value={InvocationTargetException.class})
    private static Object invokeMethod(Method method, Object object) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException cause) {
            throw new IllegalStateException("Error while calling method [" + method + "]", cause);
        }
    }

    private static Method[] getDeclaredMethods(Class<?> type) {
        if (System.getSecurityManager() == null) {
            return type.getDeclaredMethods();
        }
        return AccessController.doPrivileged(() -> type.getDeclaredMethods());
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class ForwardingGauge
    implements Gauge<Object> {
        private final Method method;
        private final Object object;
        static final long serialVersionUID = -2483559993799480208L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ForwardingGauge(Method method, Object object) {
            this.method = method;
            this.object = object;
            AccessController.doPrivileged(() -> {
                method.setAccessible(true);
                return null;
            });
        }

        @FFDCIgnore(value={IllegalStateException.class})
        public Object getValue() {
            try {
                return MetricsInterceptor.invokeMethod(this.method, this.object);
            }
            catch (IllegalStateException e) {
                MetricRegistryFactory.getApplicationRegistry().removeMatching(new MetricFilter(){
                    static final long serialVersionUID = 8870284229572527164L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public boolean matches(String name, Metric metric) {
                        if (metric.equals(this)) {
                            Tr.warning((TraceComponent)tc, (String)"cannot.resolve.metric.warning.CWMMC3000W", (Object[])new Object[]{name});
                            return true;
                        }
                        return false;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.cdi.resources.MetricsCDI");
                    }
                });
                throw e;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ForwardingGauge.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.cdi.resources.MetricsCDI");
        }
    }
}

