/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.library.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.library.Library;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE)
public class LibraryStatusService {
    private static final TraceComponent tc = Tr.register(LibraryStatusService.class, (String)"SharedLibrary", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    public static final String LIBRARY_IDS = "active.library.ids";
    public static final String LIBRARY_PIDS = "active.library.pids";
    private final Collection<String> ids = new ConcurrentSkipListSet<String>();
    private final Collection<String> pids = new ConcurrentSkipListSet<String>();
    private final Map<String, Object> properties = Collections.unmodifiableMap(new HashMap<String, Object>(){
        static final long serialVersionUID = 2466867292290088222L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;
        {
            this.put("service.vendor", "IBM");
            this.put(LibraryStatusService.LIBRARY_IDS, LibraryStatusService.this.ids);
            this.put(LibraryStatusService.LIBRARY_PIDS, LibraryStatusService.this.pids);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class, (String)"SharedLibrary", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    });
    static final long serialVersionUID = 7187647979424919790L;

    @Reference(service=Library.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected Map<String, Object> setLibrary(ServiceReference<Library> libraryRef) {
        this.ids.add((String)libraryRef.getProperty("id"));
        this.pids.add((String)libraryRef.getProperty("service.pid"));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Added library " + (String)libraryRef.getProperty("id") + " with pid " + (String)libraryRef.getProperty("service.pid")), (Object[])new Object[0]);
        }
        return this.properties;
    }

    protected Map<String, Object> unsetLibrary(ServiceReference<Library> libraryRef) {
        this.ids.remove(libraryRef.getProperty("id"));
        this.pids.remove(libraryRef.getProperty("service.pid"));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Removed library " + (String)libraryRef.getProperty("id") + " with pid " + (String)libraryRef.getProperty("service.pid")), (Object[])new Object[0]);
        }
        return this.properties;
    }
}

