/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.attachment.AttachmentDeserializer;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.attachment.HeaderSizeExceededException;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.io.CacheSizeExceededException;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ProvidersImpl;
import org.apache.cxf.jaxrs.interceptor.AttachmentInputInterceptor;
import org.apache.cxf.jaxrs.interceptor.AttachmentOutputInterceptor;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MessageContextImpl
implements MessageContext {
    private Message m;
    static final long serialVersionUID = -2508024187525638439L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public MessageContextImpl(Message m) {
        this.m = m;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object get(Object key) {
        String keyValue = key.toString();
        if ("org.apache.cxf.jaxrs.attachments.inbound".equals(keyValue) || "org.apache.cxf.jaxrs.attachments.inbound.embedded".equals(keyValue)) {
            try {
                return this.createAttachments(key.toString());
            }
            catch (CacheSizeExceededException cacheSizeExceededException) {
                void e;
                FFDCFilter.processException((Throwable)cacheSizeExceededException, (String)"org.apache.cxf.jaxrs.ext.MessageContextImpl", (String)"80", (Object)this, (Object[])new Object[]{key});
                this.m.getExchange().put((Object)"cxf.io.cacheinput", (Object)Boolean.FALSE);
                throw new WebApplicationException((Throwable)e, 413);
            }
            catch (HeaderSizeExceededException e) {
                FFDCFilter.processException((Throwable)e, (String)"org.apache.cxf.jaxrs.ext.MessageContextImpl", (String)"83", (Object)this, (Object[])new Object[]{key});
                throw new WebApplicationException((Throwable)e, 413);
            }
        }
        if (keyValue.equals("WRITE-" + Message.ATTACHMENTS) && this.m.getExchange().getOutMessage() != null) {
            return this.m.getExchange().getOutMessage().get((Object)Message.ATTACHMENTS);
        }
        Message currentMessage = this.getCurrentMessage();
        Object value = currentMessage.get(key);
        if (value == null) {
            if (Message.class.getName().equals(key)) {
                return currentMessage;
            }
            Exchange exchange = currentMessage.getExchange();
            if (exchange != null) {
                Message otherMessage;
                Message message = otherMessage = exchange.getInMessage() == currentMessage ? exchange.getOutMessage() : exchange.getInMessage();
                if (otherMessage != null) {
                    value = otherMessage.get(key);
                }
                if (value == null) {
                    value = this.m.getExchange().get(key);
                }
            }
        }
        return value;
    }

    private Message getCurrentMessage() {
        Message currentMessage = JAXRSUtils.getCurrentMessage();
        if (currentMessage == null) {
            currentMessage = this.m;
        }
        return currentMessage;
    }

    @Override
    public <T> T getContent(Class<T> format) {
        if (MessageUtils.isRequestor((Message)this.m) && this.m.getExchange().getInMessage() != null) {
            Message inMessage = this.m.getExchange().getInMessage();
            return (T)inMessage.getContent(format);
        }
        return (T)this.m.getContent(format);
    }

    @Override
    public Object getContextualProperty(Object key) {
        Object value = this.m.getContextualProperty(key.toString());
        if (value == null && key.getClass() == Class.class) {
            return this.m.getExchange().get((Class)key);
        }
        return value;
    }

    @Override
    public <T> T getContext(Class<T> contextClass) {
        return this.getContext(contextClass, contextClass);
    }

    protected <T> T getContext(Type genericType, Class<T> clazz) {
        return JAXRSUtils.createContextValue(this.m, genericType, clazz);
    }

    @Override
    public <T, E> T getResolver(Class<T> resolverClazz, Class<E> resolveClazz) {
        if (ContextResolver.class == resolverClazz) {
            return resolverClazz.cast(this.getContext(resolveClazz, ContextResolver.class));
        }
        return null;
    }

    @Override
    public Request getRequest() {
        return this.getContext(Request.class);
    }

    @Override
    public HttpHeaders getHttpHeaders() {
        return this.getContext(HttpHeaders.class);
    }

    @Override
    public Providers getProviders() {
        return this.getContext(Providers.class);
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.getContext(SecurityContext.class);
    }

    @Override
    public UriInfo getUriInfo() {
        return this.getContext(UriInfo.class);
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        try {
            return this.getContext(HttpServletRequest.class);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.jaxrs.ext.MessageContextImpl", (String)"178", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    @Override
    public HttpServletResponse getHttpServletResponse() {
        return this.getContext(HttpServletResponse.class);
    }

    @Override
    public ServletConfig getServletConfig() {
        return this.getContext(ServletConfig.class);
    }

    @Override
    public ServletContext getServletContext() {
        return this.getContext(ServletContext.class);
    }

    @Override
    public void put(Object key, Object value) {
        if ("org.apache.cxf.jaxrs.attachments.outbound".equals(key.toString())) {
            this.convertToAttachments(value);
        }
        Message currentMessage = this.getCurrentMessage();
        currentMessage.put((Object)key.toString(), value);
        currentMessage.getExchange().put((Object)key.toString(), value);
    }

    private void convertToAttachments(Object value) {
        String messageContentType;
        int index;
        List handlers = (List)value;
        ArrayList<AttachmentImpl> atts = new ArrayList<AttachmentImpl>();
        for (int i = 1; i < handlers.size(); ++i) {
            Attachment handler = (Attachment)handlers.get(i);
            AttachmentImpl att = new AttachmentImpl(handler.getContentId(), handler.getDataHandler());
            for (String key : handler.getHeaders().keySet()) {
                att.setHeader(key, handler.getHeader(key));
            }
            att.setXOP(false);
            atts.add(att);
        }
        Message outMessage = this.getOutMessage();
        outMessage.setAttachments(atts);
        outMessage.put((Object)"write.attachments", (Object)"true");
        Attachment root = (Attachment)handlers.get(0);
        String rootContentType = root.getContentType().toString();
        MetadataMap rootHeaders = new MetadataMap(root.getHeaders());
        if (!AttachmentUtil.isMtomEnabled((Message)outMessage)) {
            rootHeaders.putSingle("Content-Type", rootContentType);
        }
        if ((index = (messageContentType = outMessage.get((Object)"Content-Type").toString()).indexOf(";type")) > 0) {
            messageContentType = messageContentType.substring(0, index).trim();
        }
        AttachmentOutputInterceptor attInterceptor = new AttachmentOutputInterceptor(messageContentType, (Map<String, List<String>>)((Object)rootHeaders));
        outMessage.put((Object)"Content-Type", (Object)rootContentType);
        Map allHeaders = CastUtils.cast((Map)((Map)outMessage.get((Object)Message.PROTOCOL_HEADERS)));
        if (allHeaders != null) {
            allHeaders.remove("Content-Type");
        }
        attInterceptor.handleMessage(outMessage);
    }

    private Message getOutMessage() {
        Message message = this.m.getExchange().getOutMessage();
        if (message == null) {
            Endpoint ep = this.m.getExchange().getEndpoint();
            message = new MessageImpl();
            message.setExchange(this.m.getExchange());
            message = ep.getBinding().createMessage(message);
            this.m.getExchange().setOutMessage(message);
        }
        return message;
    }

    /*
     * WARNING - void declaration
     */
    private MultipartBody createAttachments(String propertyName) {
        Message inMessage = this.m.getExchange().getInMessage();
        boolean embeddedAttachment = inMessage.get((Object)"org.apache.cxf.multipart.embedded") != null;
        Object o = inMessage.get((Object)propertyName);
        if (o != null) {
            return (MultipartBody)o;
        }
        if (embeddedAttachment) {
            inMessage = new MessageImpl();
            inMessage.setExchange((Exchange)new ExchangeImpl());
            inMessage.put((Object)"attachment-directory", this.m.getExchange().getInMessage().get((Object)"attachment-directory"));
            inMessage.put((Object)"attachment-memory-threshold", this.m.getExchange().getInMessage().get((Object)"attachment-memory-threshold"));
            inMessage.put((Object)"attachment-max-size", this.m.getExchange().getInMessage().get((Object)"attachment-max-size"));
            inMessage.put((Object)"attachment-max-header-size", this.m.getExchange().getInMessage().get((Object)"attachment-max-header-size"));
            inMessage.setContent(InputStream.class, this.m.getExchange().getInMessage().get((Object)"org.apache.cxf.multipart.embedded.input"));
            inMessage.put((Object)"Content-Type", (Object)this.m.getExchange().getInMessage().get((Object)"org.apache.cxf.multipart.embedded.ctype").toString());
        }
        new AttachmentInputInterceptor().handleMessage(inMessage);
        LinkedList<Attachment> newAttachments = new LinkedList<Attachment>();
        try {
            Map headers = CastUtils.cast((Map)((Map)inMessage.get((Object)AttachmentDeserializer.ATTACHMENT_PART_HEADERS)));
            Attachment first = new Attachment(AttachmentUtil.createAttachment((InputStream)((InputStream)inMessage.getContent(InputStream.class)), (Map)headers), new ProvidersImpl(inMessage));
            newAttachments.add(first);
        }
        catch (IOException headers) {
            void ex;
            FFDCFilter.processException((Throwable)headers, (String)"org.apache.cxf.jaxrs.ext.MessageContextImpl", (String)"300", (Object)this, (Object[])new Object[]{propertyName});
            throw ExceptionUtils.toInternalServerErrorException((Throwable)ex, null);
        }
        List<org.apache.cxf.message.Attachment> childAttachments = inMessage.getAttachments();
        if (childAttachments == null) {
            childAttachments = Collections.emptyList();
        }
        childAttachments.size();
        for (org.apache.cxf.message.Attachment a : childAttachments) {
            newAttachments.add(new Attachment(a, new ProvidersImpl(inMessage)));
        }
        MediaType mt = embeddedAttachment ? (MediaType)inMessage.get((Object)"org.apache.cxf.multipart.embedded.ctype") : this.getHttpHeaders().getMediaType();
        MultipartBody body = new MultipartBody(newAttachments, mt, false);
        inMessage.put((Object)propertyName, (Object)body);
        return body;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MessageContextImpl.class, null, null);
    }
}

