/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.jca;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.data.AuthData;
import com.ibm.websphere.security.auth.data.AuthDataProvider;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.security.auth.callback.WSManagedConnectionFactoryCallback;
import com.ibm.wsspi.security.auth.callback.WSMappingPropertiesCallback;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSPrincipalMappingLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(WSPrincipalMappingLoginModule.class, (String)"AuthData", (String)"com.ibm.ws.security.auth.data.internal.resources.AuthDataMessages");
    private static final WebSphereRuntimePermission GET_PASSWORD_CREDENTIAL_PERMISSION = new WebSphereRuntimePermission("getPasswordCredential");
    private CallbackHandler callbackHandler;
    private Subject subject;
    private Subject temporarySubject;
    private boolean succeeded = false;
    static final long serialVersionUID = 7051885732826986993L;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.callbackHandler = callbackHandler;
        this.subject = subject;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean login() throws LoginException {
        try {
            Callback[] callbacks = this.getHandledCallbacks();
            this.setPasswordCredentialInTemporarySubject(callbacks);
        }
        catch (Exception callbacks) {
            void e;
            FFDCFilter.processException((Throwable)callbacks, (String)"com.ibm.websphere.security.jca.WSPrincipalMappingLoginModule", (String)"63", (Object)this, (Object[])new Object[0]);
            throw new LoginException(e.getMessage());
        }
        return this.succeeded;
    }

    private Callback[] getHandledCallbacks() throws IOException, UnsupportedCallbackException {
        Callback[] callbacks = new Callback[]{new WSManagedConnectionFactoryCallback("Target ManagedConnectionFactory: "), new WSMappingPropertiesCallback("Mapping Properties (HashMap): ")};
        this.callbackHandler.handle(callbacks);
        return callbacks;
    }

    private void setPasswordCredentialInTemporarySubject(Callback[] callbacks) throws Exception {
        String alias = this.getAlias(callbacks);
        if (alias != null) {
            this.validateCallerHasPermission();
            this.setupTemporarySubject(callbacks, alias);
        }
    }

    private String getAlias(Callback[] callbacks) {
        String alias = null;
        Map properties = ((WSMappingPropertiesCallback)callbacks[1]).getProperties();
        if (properties != null) {
            alias = (String)properties.get("com.ibm.mapping.authDataAlias");
            if (alias != null) {
                alias = alias.trim();
            } else {
                Tr.error((TraceComponent)tc, (String)"MISSING_MAPPING_ALIAS_IN_CALLBACK_WSMAPPINGCALLBAKHANDLER", (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
            Tr.error((TraceComponent)tc, (String)"MISSING_MAP_IN_CALLBACK_WSMAPPINGCALLBAKHANDLER", (Object[])new Object[0]);
        }
        return alias;
    }

    private void validateCallerHasPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)GET_PASSWORD_CREDENTIAL_PERMISSION);
        }
    }

    private void setupTemporarySubject(Callback[] callbacks, String alias) throws LoginException {
        this.temporarySubject = new Subject();
        AuthData authData = AuthDataProvider.getAuthData((String)alias);
        ManagedConnectionFactory managedConnectionFactory = ((WSManagedConnectionFactoryCallback)callbacks[0]).getManagedConnectionFacotry();
        PasswordCredential passwordCredential = new PasswordCredential(authData.getUserName(), authData.getPassword());
        passwordCredential.setManagedConnectionFactory(managedConnectionFactory);
        this.temporarySubject.getPrivateCredentials().add(passwordCredential);
        this.succeeded = true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.setUpSubject();
        return true;
    }

    private void setUpSubject() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){
            static final long serialVersionUID = -8399447235463174685L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object run() {
                WSPrincipalMappingLoginModule.this.updateSubjectWithTemporarySubjectContents();
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"AuthData", (String)"com.ibm.ws.security.auth.data.internal.resources.AuthDataMessages");
            }
        });
    }

    private void updateSubjectWithTemporarySubjectContents() {
        Set<Object> privateCredentials = this.temporarySubject.getPrivateCredentials();
        this.subject.getPrivateCredentials().addAll(privateCredentials);
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.cleanUpSubject();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.cleanUpSubject();
        return true;
    }

    private void cleanUpSubject() {
        if (this.temporarySubject != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){
                static final long serialVersionUID = -5098437160951724224L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() {
                    WSPrincipalMappingLoginModule.this.removeSubjectPrivateCredentials();
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class, (String)"AuthData", (String)"com.ibm.ws.security.auth.data.internal.resources.AuthDataMessages");
                }
            });
        }
        this.temporarySubject = null;
    }

    private void removeSubjectPrivateCredentials() {
        Set<Object> privateCredentials = this.subject.getPrivateCredentials();
        privateCredentials.removeAll(this.temporarySubject.getPrivateCredentials());
    }
}

