/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.kernel.service.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceElement;
import com.ibm.wsspi.kernel.service.utils.ServiceAndServiceReferencePair;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConcurrentServiceReferenceSet<T> {
    private final String referenceName;
    private final AtomicReference<ComponentContext> contextRef;
    private final Map<ServiceReference<T>, ConcurrentServiceReferenceElement<T>> elementMap = new LinkedHashMap<ServiceReference<T>, ConcurrentServiceReferenceElement<T>>();
    private ConcurrentSkipListSet<ConcurrentServiceReferenceElement<T>> elementSet = new ConcurrentSkipListSet();
    private boolean elementSetUnsorted;
    static final long serialVersionUID = 756240983881166148L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ConcurrentServiceReferenceSet(String name) {
        this(name, new AtomicReference<ComponentContext>());
    }

    ConcurrentServiceReferenceSet(String name, AtomicReference<ComponentContext> contextRef) {
        this.referenceName = name;
        this.contextRef = contextRef;
    }

    public void activate(ComponentContext context) {
        if (this.contextRef.get() != null) {
            throw new IllegalStateException("already activated");
        }
        this.contextRef.set(context);
    }

    public void deactivate(ComponentContext context) {
        if (this.contextRef.get() == null) {
            throw new IllegalStateException("not activated");
        }
        this.contextRef.set(null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[refName=" + this.referenceName + ", isEmpty=" + this.isEmpty() + ", isActive=" + this.isActive() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addReference(ServiceReference<T> reference) {
        if (reference == null) {
            return false;
        }
        ConcurrentServiceReferenceElement<T> element = new ConcurrentServiceReferenceElement<T>(this.referenceName, reference);
        Map<ServiceReference<T>, ConcurrentServiceReferenceElement<T>> map = this.elementMap;
        synchronized (map) {
            ConcurrentServiceReferenceElement<T> oldElement = this.elementMap.put(reference, element);
            if (oldElement != null) {
                if (!element.getRanking().equals(oldElement.getRanking())) {
                    this.elementSetUnsorted = true;
                }
                return true;
            }
            this.elementSet.add(element);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeReference(ServiceReference<T> reference) {
        Map<ServiceReference<T>, ConcurrentServiceReferenceElement<T>> map = this.elementMap;
        synchronized (map) {
            ConcurrentServiceReferenceElement<T> element = this.elementMap.remove(reference);
            if (element == null) {
                return false;
            }
            this.elementSet.remove(element);
            return true;
        }
    }

    public boolean isEmpty() {
        return this.elementSet.isEmpty();
    }

    public boolean isActive() {
        return this.contextRef.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getService(ServiceReference<T> serviceReference) {
        ComponentContext ctx;
        if (serviceReference != null && (ctx = this.contextRef.get()) != null) {
            ConcurrentServiceReferenceElement<T> element;
            Map<ServiceReference<T>, ConcurrentServiceReferenceElement<T>> map = this.elementMap;
            synchronized (map) {
                element = this.elementMap.get(serviceReference);
            }
            if (element != null) {
                return element.getService(ctx);
            }
        }
        return null;
    }

    public T getHighestRankedService() {
        Iterator<T> iterator = this.getServices();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public ServiceReference<T> getHighestRankedReference() {
        Iterator<ConcurrentServiceReferenceElement<T>> iterator = this.elementSet.iterator();
        return iterator.hasNext() ? iterator.next().getReference() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<ConcurrentServiceReferenceElement<T>> elements() {
        ConcurrentSkipListSet<ConcurrentServiceReferenceElement<T>> set;
        Map<ServiceReference<T>, ConcurrentServiceReferenceElement<T>> map = this.elementMap;
        synchronized (map) {
            if (this.elementSetUnsorted) {
                this.elementSet = new ConcurrentSkipListSet<ConcurrentServiceReferenceElement<T>>(this.elementMap.values());
                this.elementSetUnsorted = false;
            }
            set = this.elementSet;
        }
        return set.iterator();
    }

    public Iterator<T> getServices() {
        List empty = Collections.emptyList();
        if (this.contextRef.get() == null) {
            return empty.iterator();
        }
        return new ServiceIterator(this.elements());
    }

    public Iterator<ServiceAndServiceReferencePair<T>> getServicesWithReferences() {
        List empty = Collections.emptyList();
        if (this.contextRef.get() == null) {
            return empty.iterator();
        }
        return new ServiceAndReferenceIterator(this.elements());
    }

    public Iterable<T> services() {
        return new Iterable<T>(){
            static final long serialVersionUID = 1872521747807383083L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Iterator<T> iterator() {
                return ConcurrentServiceReferenceSet.this.getServices();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
            }
        };
    }

    public Iterable<ServiceReference<T>> references() {
        return new Iterable<ServiceReference<T>>(){
            static final long serialVersionUID = 5306705510894385511L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Iterator<ServiceReference<T>> iterator() {
                return new Iterator<ServiceReference<T>>(){
                    Iterator<ConcurrentServiceReferenceElement<T>> it;
                    static final long serialVersionUID = 5934314309034231130L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;
                    {
                        this.it = ConcurrentServiceReferenceSet.this.elements();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public ServiceReference<T> next() {
                        ConcurrentServiceReferenceElement e = this.it.next();
                        return e.getReference();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                    }
                };
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
            }
        };
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ConcurrentServiceReferenceSet.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private final class ServiceAndReferenceIterator
    implements Iterator<ServiceAndServiceReferencePair<T>> {
        final Iterator<ConcurrentServiceReferenceElement<T>> c_refs;
        ServiceAndServiceReferencePair<T> next;
        static final long serialVersionUID = 7556003178669906792L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ServiceAndReferenceIterator(Iterator<ConcurrentServiceReferenceElement<T>> iterator) {
            this.c_refs = iterator;
        }

        @Override
        public boolean hasNext() {
            ComponentContext ctx = (ComponentContext)ConcurrentServiceReferenceSet.this.contextRef.get();
            if (ctx == null) {
                return false;
            }
            while (this.next == null && this.c_refs.hasNext()) {
                final ConcurrentServiceReferenceElement element = this.c_refs.next();
                final Object service = element.getService(ctx);
                if (service == null) continue;
                this.next = new ServiceAndServiceReferencePair<T>(){
                    static final long serialVersionUID = -6242425501525657238L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public T getService() {
                        return service;
                    }

                    @Override
                    public ServiceReference<T> getServiceReference() {
                        return element.getReference();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                    }
                };
            }
            return this.next != null;
        }

        @Override
        public ServiceAndServiceReferencePair<T> next() {
            ServiceAndServiceReferencePair pair = this.next;
            if (pair == null) {
                throw new NoSuchElementException();
            }
            this.next = null;
            return pair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[next=" + this.next + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ServiceAndReferenceIterator.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private final class ServiceIterator
    implements Iterator<T> {
        final Iterator<ConcurrentServiceReferenceElement<T>> c_refs;
        T next;
        static final long serialVersionUID = -492278560885444393L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ServiceIterator(Iterator<ConcurrentServiceReferenceElement<T>> iterator) {
            this.c_refs = iterator;
        }

        @Override
        public boolean hasNext() {
            ComponentContext ctx = (ComponentContext)ConcurrentServiceReferenceSet.this.contextRef.get();
            if (ctx == null) {
                return false;
            }
            while (this.next == null && this.c_refs.hasNext()) {
                this.next = this.c_refs.next().getService(ctx);
            }
            return this.next != null;
        }

        @Override
        public T next() {
            Object service = this.next;
            if (service == null) {
                throw new NoSuchElementException();
            }
            this.next = null;
            return service;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[next=" + this.next + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ServiceIterator.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    }
}

