/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils;

import com.ibm.ws.sib.utils.CryptoHash;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;

abstract class SIBUuidLength {
    private static final String className = SIBUuidLength.class.getName();
    private byte[] uuid;
    private static final String ipaddress = SIBUuidLength.getIPAddress();
    private int hashcode;
    private int stringLength = 0;
    private String string;

    protected SIBUuidLength(int length) {
        this.uuid = new byte[length];
        byte[] seed = UUID.randomUUID().toString().getBytes();
        CryptoHash.hash(seed, this.uuid);
    }

    protected SIBUuidLength(int length, byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException();
        }
        this.uuid = new byte[length];
        System.arraycopy(bytes, 0, this.uuid, 0, Math.min(this.uuid.length, bytes.length));
    }

    protected SIBUuidLength(int length, String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.uuid = new byte[length];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch == '-') continue;
            sb.append(ch);
        }
        String string2 = sb.toString();
        int j = 0;
        for (int i = 0; i < string2.length() && j < this.uuid.length; i += 2) {
            sb = new StringBuffer();
            sb.append(string2.substring(i, i + 1));
            if (i + 1 < string2.length()) {
                sb.append(string2.substring(i + 1, i + 2));
            } else {
                sb.append("0");
            }
            this.uuid[j++] = (byte)Integer.parseInt(sb.toString(), 16);
        }
    }

    public byte[] toByteArray() {
        return this.uuid;
    }

    public boolean equals(Object o) {
        boolean rc = false;
        if (this == o) {
            rc = true;
        } else if (o != null && o.getClass() == this.getClass()) {
            rc = Arrays.equals(this.uuid, ((SIBUuidLength)o).uuid);
        }
        return rc;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            int rc = 0;
            for (int i = 0; i < this.uuid.length; ++i) {
                rc += this.uuid[i];
            }
            this.hashcode = rc;
        }
        return this.hashcode;
    }

    public int getStringLength() {
        if (this.stringLength == 0) {
            this.stringLength = this.uuid.length * 2;
        }
        return this.stringLength;
    }

    public String toString() {
        char[] _NIBBLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (this.string == null) {
            char[] chars = new char[this.getStringLength()];
            int j = 0;
            for (int i = 0; i < chars.length; ++i) {
                chars[i++] = _NIBBLE[(this.uuid[j] & 0xF0) >>> 4];
                chars[i] = _NIBBLE[(this.uuid[j++] & 0xF) >>> 0];
            }
            this.string = new String(chars);
        }
        return this.string;
    }

    private static String getIPAddress() {
        String rc;
        try {
            rc = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            rc = Long.valueOf(new Random().nextLong()).toString();
        }
        return rc;
    }
}

