/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.error;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.error.ErrorHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SamlException
extends Exception {
    private static TraceComponent tc = Tr.register(SamlException.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    private static final long serialVersionUID = 6451370128254992895L;
    protected Constants.SamlSsoVersion _samlVersion = Constants.SamlSsoVersion.SAMLSSO20;
    protected String _message = null;
    protected String _msgKey = null;
    protected Object[] _objects = null;
    protected String _defaultMsg = null;
    protected boolean ffdcAlready = false;
    protected int httpErrorCode = 403;
    protected ErrorHandler errorHandler = null;
    protected String errorMessage = null;

    public SamlException(String msgKey, Exception cause, Object[] objects) {
        this(msgKey, cause, cause != null, objects);
    }

    public SamlException(Exception cause) {
        this(cause, false);
    }

    public SamlException(Exception cause, boolean ffdcAlready) {
        this.ffdcAlready = ffdcAlready;
        this.handleUnexpectException(cause);
    }

    public SamlException(String message, Exception cause) {
        this(message, cause, cause != null);
    }

    public SamlException(String message, Exception cause, boolean ffdcAlready) {
        super(message, cause);
        this.ffdcAlready = ffdcAlready;
        this._message = message;
    }

    public SamlException(String msgKey, Exception cause, boolean ffdcAlready, Object[] objects) {
        super(cause);
        this.ffdcAlready = ffdcAlready;
        this.handleInternalMessage(msgKey, objects);
    }

    public SamlException(String message) {
        super(message);
        this._message = message;
        this.ffdcAlready = true;
        this.setExternalMsg();
    }

    public void setErrorHanlder(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHanlder() {
        return this.errorHandler;
    }

    public Constants.SamlSsoVersion getSamlVersion() {
        return this._samlVersion;
    }

    public void setSamlVersion(Constants.SamlSsoVersion samlVersion) {
        this._samlVersion = samlVersion;
    }

    public void setHttpErrorCode(int httpErrorCode) {
        this.httpErrorCode = httpErrorCode;
    }

    public int getHttpErrorCode() {
        return this.httpErrorCode;
    }

    public String getMsgKey() {
        return this._msgKey;
    }

    public Object[] getObjects() {
        return this._objects;
    }

    public boolean ffdcAlready() {
        return this.ffdcAlready;
    }

    public void setFfdcAlready(boolean ffdcAlready) {
        this.ffdcAlready = ffdcAlready;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ffdc already handled? " + ffdcAlready), (Object[])new Object[0]);
        }
    }

    @Override
    @Trivial
    public String getMessage() {
        if (this._message == null) {
            this.setExternalMsg();
        }
        return this._message;
    }

    @Trivial
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Trivial
    public static String formatMessage(String msgKey, String defaultMsg, Object[] objects) {
        return TraceNLS.getFormattedMessage(SamlException.class, (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages", (String)msgKey, (Object[])objects, (String)defaultMsg);
    }

    @Trivial
    protected void handleUnexpectException(Exception cause) {
        this.setExternalMsg();
        String exceptionName = cause.getClass().getName();
        String msg = cause.getMessage();
        StringBuffer sb = SamlException.dumpStackTrace(cause, 6);
        Tr.error((TraceComponent)tc, (String)"SAML20_SERVER_INTERNAL_LOG_ERROR", (Object[])new Object[]{exceptionName, msg, sb.toString()});
        this.errorMessage = SamlException.formatMessage("SAML20_SERVER_INTERNAL_LOG_ERROR", null, new Object[]{exceptionName, msg, sb.toString()});
    }

    protected void handleInternalMessage(String msgKey, Object[] objects) {
        this.setExternalMsg();
        Tr.error((TraceComponent)tc, (String)msgKey, (Object[])objects);
        this.errorMessage = SamlException.formatMessage(msgKey, null, objects);
    }

    private void setExternalMsg() {
        this._msgKey = "SAML20_AUTHENTICATION_FAIL";
        this._objects = new Object[0];
        this._defaultMsg = "CWWKS5063E: SAML Exception: The SAML service provider (SP) failed to process the authentication request.";
    }

    @Trivial
    public static StringBuffer dumpStackTrace(Throwable cause, int iLimited) {
        int iI;
        StackTraceElement[] stackTrace = cause.getStackTrace();
        if (iLimited == -1 || iLimited > stackTrace.length) {
            iLimited = stackTrace.length;
        }
        StringBuffer sb = new StringBuffer("\n  ");
        for (iI = 0; iI < iLimited; ++iI) {
            sb.append(stackTrace[iI].toString() + "\n  ");
        }
        if (iI < stackTrace.length) {
            sb.append("  ....\n");
        }
        return sb;
    }
}

